"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SinglePageApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
This custom construct is to create a standard deployment for static websites. Includes:
S3 bucket - storage for website files
S3 deployment - manage assets deployments in the bucket
Cloudfront distribution - CDN for the files
Route53 - [Optional] route53 record for the provided hosted zone
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class SinglePageApp extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.domainName = props.hostedZone
            ? `${props.domainPrefix}.${props.hostedZone.zoneName}`.toLowerCase()
            : undefined;
        this.bucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'SampleSPABucketWebsite', {
            bucketName: props.hostedZone ? this.domainName : undefined,
            publicReadAccess: true,
            websiteIndexDocument: 'index.html',
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            autoDeleteObjects: true,
        });
        this.certificate = props.hostedZone
            ? new aws_cdk_lib_1.aws_certificatemanager.DnsValidatedCertificate(this, `Certificate-${props.domainPrefix}`, {
                hostedZone: props.hostedZone,
                domainName: this.domainName ? this.domainName : '',
                region: 'us-east-1',
            })
            : undefined;
        this.distribution = new aws_cdk_lib_1.aws_cloudfront.Distribution(this, 'SampleSPADistribution', {
            defaultBehavior: { origin: new aws_cdk_lib_1.aws_cloudfront_origins.S3Origin(this.bucket) },
            certificate: this.certificate,
            domainNames: this.domainName ? [this.domainName] : undefined,
        });
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'DeploySampleSPA', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(props.buildPath)],
            destinationBucket: this.bucket,
            distribution: this.distribution,
            distributionPaths: ['/*'],
        });
        if (props.hostedZone && this.domainName) {
            new aws_cdk_lib_1.CfnOutput(this, this.domainName, {
                value: this.domainName,
            });
            new aws_cdk_lib_1.aws_route53.ARecord(this, 'AliasRecord', {
                zone: props.hostedZone,
                recordName: this.domainName,
                target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
            });
        }
        else {
            new aws_cdk_lib_1.CfnOutput(this, this.distribution.domainName, {
                value: this.distribution.domainName,
            });
        }
    }
}
exports.SinglePageApp = SinglePageApp;
_a = JSII_RTTI_SYMBOL_1;
SinglePageApp[_a] = { fqn: "@sparkgeo/awscdk-constructs-library.SinglePageApp", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,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