# Generated by Django 3.1 on 2021-03-11 01:03
from django.db import migrations, models

import pymess.models.emails


def assert_email_contents_are_migrated(apps, schema_editor):
    EmailMessage = apps.get_model('pymess', 'EmailMessage')
    assert not EmailMessage.objects.filter(old_content__isnull=False).exists(), (
        'Please update first to version 0.5.0 and run "migrate_email_contents_to_files" command.'
    )


class Migration(migrations.Migration):

    dependencies = [
        ('pymess', '0023_migration'),
    ]

    operations = [
        migrations.RunPython(assert_email_contents_are_migrated),
        migrations.AlterField(
            model_name='emailmessage',
            name='content_file',
            field=models.FileField(upload_to=pymess.models.emails.generate_content_filename,
                                   verbose_name='content file'),
        ),
        migrations.RemoveField(
            model_name='emailmessage',
            name='old_content',
        ),
    ]
