# quantecon-book-theme
A Jupyter Book Theme for QuantEcon Book Style Projects

## Usage

To use this theme in [Jupyter Book](https://github.com/executablebooks/jupyter-book):

1. Install the theme

  `pip install git+https://github.com/QuantEcon/quantecon-book-theme.git`

2. Add the theme to your `_config.yml` file:

  ```yaml
  sphinx:
      config:
          html_theme: quantecon_book_theme
  ```

## Updating Fixtures for Tests

### Updating test regression files on layout changes

It is advisable to update the test files for file regression checks when releavant layout files change.

For example, at present we have a sidebar file-regression check to validate html across tests.
The file which it compares against is `tests/test_build/test_build_book.html`.

If updating the sidebar html, then one of the easier steps to update this test file is:

1. Delete the file `tests/test_build/test_build_book.html`.
2. Run `pytest` in your command line, which will then generate a new file. Check if the file is at par with your expectations, contains elements which you added/modified.

Now future pytests will test against this file, and the subsequent tests should pass.

## Contributing Guide

The docs for the contributing guide of this repository: https://github.com/QuantEcon/quantecon-book-theme/blob/master/docs/contributing.md
