/*
 * SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * SPDX-License-Identifier: BSD-3-Clause
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#include <yarp/dev/MobileBaseVelocity.h>

namespace yarp::dev {

// Constructor with field values
MobileBaseVelocity::MobileBaseVelocity(const double vel_x,
                                       const double vel_y,
                                       const double vel_theta) :
        WirePortable(),
        vel_x(vel_x),
        vel_y(vel_y),
        vel_theta(vel_theta)
{
}

// Read structure on a Wire
bool MobileBaseVelocity::read(yarp::os::idl::WireReader& reader)
{
    if (!read_vel_x(reader)) {
        return false;
    }
    if (!read_vel_y(reader)) {
        return false;
    }
    if (!read_vel_theta(reader)) {
        return false;
    }
    return !reader.isError();
}

// Read structure on a Connection
bool MobileBaseVelocity::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader(3)) {
        return false;
    }
    return read(reader);
}

// Write structure on a Wire
bool MobileBaseVelocity::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!write_vel_x(writer)) {
        return false;
    }
    if (!write_vel_y(writer)) {
        return false;
    }
    if (!write_vel_theta(writer)) {
        return false;
    }
    return !writer.isError();
}

// Write structure on a Connection
bool MobileBaseVelocity::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(3)) {
        return false;
    }
    return write(writer);
}

// Convert to a printable string
std::string MobileBaseVelocity::toString() const
{
    yarp::os::Bottle b;
    b.read(*this);
    return b.toString();
}

// Editor: default constructor
MobileBaseVelocity::Editor::Editor()
{
    group = 0;
    obj_owned = true;
    obj = new MobileBaseVelocity;
    dirty_flags(false);
    yarp().setOwner(*this);
}

// Editor: constructor with base class
MobileBaseVelocity::Editor::Editor(MobileBaseVelocity& obj)
{
    group = 0;
    obj_owned = false;
    edit(obj, false);
    yarp().setOwner(*this);
}

// Editor: destructor
MobileBaseVelocity::Editor::~Editor()
{
    if (obj_owned) {
        delete obj;
    }
}

// Editor: edit
bool MobileBaseVelocity::Editor::edit(MobileBaseVelocity& obj, bool dirty)
{
    if (obj_owned) {
        delete this->obj;
    }
    this->obj = &obj;
    obj_owned = false;
    dirty_flags(dirty);
    return true;
}

// Editor: validity check
bool MobileBaseVelocity::Editor::isValid() const
{
    return obj != nullptr;
}

// Editor: state
MobileBaseVelocity& MobileBaseVelocity::Editor::state()
{
    return *obj;
}

// Editor: grouping begin
void MobileBaseVelocity::Editor::start_editing()
{
    group++;
}

// Editor: grouping end
void MobileBaseVelocity::Editor::stop_editing()
{
    group--;
    if (group == 0 && is_dirty) {
        communicate();
    }
}
// Editor: vel_x setter
void MobileBaseVelocity::Editor::set_vel_x(const double vel_x)
{
    will_set_vel_x();
    obj->vel_x = vel_x;
    mark_dirty_vel_x();
    communicate();
    did_set_vel_x();
}

// Editor: vel_x getter
double MobileBaseVelocity::Editor::get_vel_x() const
{
    return obj->vel_x;
}

// Editor: vel_x will_set
bool MobileBaseVelocity::Editor::will_set_vel_x()
{
    return true;
}

// Editor: vel_x did_set
bool MobileBaseVelocity::Editor::did_set_vel_x()
{
    return true;
}

// Editor: vel_y setter
void MobileBaseVelocity::Editor::set_vel_y(const double vel_y)
{
    will_set_vel_y();
    obj->vel_y = vel_y;
    mark_dirty_vel_y();
    communicate();
    did_set_vel_y();
}

// Editor: vel_y getter
double MobileBaseVelocity::Editor::get_vel_y() const
{
    return obj->vel_y;
}

// Editor: vel_y will_set
bool MobileBaseVelocity::Editor::will_set_vel_y()
{
    return true;
}

// Editor: vel_y did_set
bool MobileBaseVelocity::Editor::did_set_vel_y()
{
    return true;
}

// Editor: vel_theta setter
void MobileBaseVelocity::Editor::set_vel_theta(const double vel_theta)
{
    will_set_vel_theta();
    obj->vel_theta = vel_theta;
    mark_dirty_vel_theta();
    communicate();
    did_set_vel_theta();
}

// Editor: vel_theta getter
double MobileBaseVelocity::Editor::get_vel_theta() const
{
    return obj->vel_theta;
}

// Editor: vel_theta will_set
bool MobileBaseVelocity::Editor::will_set_vel_theta()
{
    return true;
}

// Editor: vel_theta did_set
bool MobileBaseVelocity::Editor::did_set_vel_theta()
{
    return true;
}

// Editor: clean
void MobileBaseVelocity::Editor::clean()
{
    dirty_flags(false);
}

// Editor: read
bool MobileBaseVelocity::Editor::read(yarp::os::ConnectionReader& connection)
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireReader reader(connection);
    reader.expectAccept();
    if (!reader.readListHeader()) {
        return false;
    }
    int len = reader.getLength();
    if (len == 0) {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(1)) {
            return false;
        }
        writer.writeString("send: 'help' or 'patch (param1 val1) (param2 val2)'");
        return true;
    }
    std::string tag;
    if (!reader.readString(tag)) {
        return false;
    }
    if (tag == "help") {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(2)) {
            return false;
        }
        if (!writer.writeTag("many", 1, 0)) {
            return false;
        }
        if (reader.getLength() > 0) {
            std::string field;
            if (!reader.readString(field)) {
                return false;
            }
            if (field == "vel_x") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double vel_x")) {
                    return false;
                }
                if (!writer.writeString("velocity of the robot [m/s]")) {
                    return false;
                }
            }
            if (field == "vel_y") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double vel_y")) {
                    return false;
                }
                if (!writer.writeString("velocity of the robot [m/s]")) {
                    return false;
                }
            }
            if (field == "vel_theta") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double vel_theta")) {
                    return false;
                }
                if (!writer.writeString("angular velocity of the robot [deg/s]")) {
                    return false;
                }
            }
        }
        if (!writer.writeListHeader(4)) {
            return false;
        }
        writer.writeString("*** Available fields:");
        writer.writeString("vel_x");
        writer.writeString("vel_y");
        writer.writeString("vel_theta");
        return true;
    }
    bool nested = true;
    bool have_act = false;
    if (tag != "patch") {
        if (((len - 1) % 2) != 0) {
            return false;
        }
        len = 1 + ((len - 1) / 2);
        nested = false;
        have_act = true;
    }
    for (int i = 1; i < len; ++i) {
        if (nested && !reader.readListHeader(3)) {
            return false;
        }
        std::string act;
        std::string key;
        if (have_act) {
            act = tag;
        } else if (!reader.readString(act)) {
            return false;
        }
        if (!reader.readString(key)) {
            return false;
        }
        if (key == "vel_x") {
            will_set_vel_x();
            if (!obj->nested_read_vel_x(reader)) {
                return false;
            }
            did_set_vel_x();
        } else if (key == "vel_y") {
            will_set_vel_y();
            if (!obj->nested_read_vel_y(reader)) {
                return false;
            }
            did_set_vel_y();
        } else if (key == "vel_theta") {
            will_set_vel_theta();
            if (!obj->nested_read_vel_theta(reader)) {
                return false;
            }
            did_set_vel_theta();
        } else {
            // would be useful to have a fallback here
        }
    }
    reader.accept();
    yarp::os::idl::WireWriter writer(reader);
    if (writer.isNull()) {
        return true;
    }
    writer.writeListHeader(1);
    writer.writeVocab32('o', 'k');
    return true;
}

// Editor: write
bool MobileBaseVelocity::Editor::write(yarp::os::ConnectionWriter& connection) const
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(dirty_count + 1)) {
        return false;
    }
    if (!writer.writeString("patch")) {
        return false;
    }
    if (is_dirty_vel_x) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("vel_x")) {
            return false;
        }
        if (!obj->nested_write_vel_x(writer)) {
            return false;
        }
    }
    if (is_dirty_vel_y) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("vel_y")) {
            return false;
        }
        if (!obj->nested_write_vel_y(writer)) {
            return false;
        }
    }
    if (is_dirty_vel_theta) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("vel_theta")) {
            return false;
        }
        if (!obj->nested_write_vel_theta(writer)) {
            return false;
        }
    }
    return !writer.isError();
}

// Editor: send if possible
void MobileBaseVelocity::Editor::communicate()
{
    if (group != 0) {
        return;
    }
    if (yarp().canWrite()) {
        yarp().write(*this);
        clean();
    }
}

// Editor: mark dirty overall
void MobileBaseVelocity::Editor::mark_dirty()
{
    is_dirty = true;
}

// Editor: vel_x mark_dirty
void MobileBaseVelocity::Editor::mark_dirty_vel_x()
{
    if (is_dirty_vel_x) {
        return;
    }
    dirty_count++;
    is_dirty_vel_x = true;
    mark_dirty();
}

// Editor: vel_y mark_dirty
void MobileBaseVelocity::Editor::mark_dirty_vel_y()
{
    if (is_dirty_vel_y) {
        return;
    }
    dirty_count++;
    is_dirty_vel_y = true;
    mark_dirty();
}

// Editor: vel_theta mark_dirty
void MobileBaseVelocity::Editor::mark_dirty_vel_theta()
{
    if (is_dirty_vel_theta) {
        return;
    }
    dirty_count++;
    is_dirty_vel_theta = true;
    mark_dirty();
}

// Editor: dirty_flags
void MobileBaseVelocity::Editor::dirty_flags(bool flag)
{
    is_dirty = flag;
    is_dirty_vel_x = flag;
    is_dirty_vel_y = flag;
    is_dirty_vel_theta = flag;
    dirty_count = flag ? 3 : 0;
}

// read vel_x field
bool MobileBaseVelocity::read_vel_x(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(vel_x)) {
        reader.fail();
        return false;
    }
    return true;
}

// write vel_x field
bool MobileBaseVelocity::write_vel_x(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(vel_x)) {
        return false;
    }
    return true;
}

// read (nested) vel_x field
bool MobileBaseVelocity::nested_read_vel_x(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(vel_x)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) vel_x field
bool MobileBaseVelocity::nested_write_vel_x(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(vel_x)) {
        return false;
    }
    return true;
}

// read vel_y field
bool MobileBaseVelocity::read_vel_y(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(vel_y)) {
        reader.fail();
        return false;
    }
    return true;
}

// write vel_y field
bool MobileBaseVelocity::write_vel_y(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(vel_y)) {
        return false;
    }
    return true;
}

// read (nested) vel_y field
bool MobileBaseVelocity::nested_read_vel_y(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(vel_y)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) vel_y field
bool MobileBaseVelocity::nested_write_vel_y(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(vel_y)) {
        return false;
    }
    return true;
}

// read vel_theta field
bool MobileBaseVelocity::read_vel_theta(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(vel_theta)) {
        reader.fail();
        return false;
    }
    return true;
}

// write vel_theta field
bool MobileBaseVelocity::write_vel_theta(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(vel_theta)) {
        return false;
    }
    return true;
}

// read (nested) vel_theta field
bool MobileBaseVelocity::nested_read_vel_theta(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(vel_theta)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) vel_theta field
bool MobileBaseVelocity::nested_write_vel_theta(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(vel_theta)) {
        return false;
    }
    return true;
}

} // namespace yarp::dev
