"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
/**
 * A GitLab Runner cache consisting of an Amazon S3 bucket.
 *
 * The bucket is encrypted with a KMS managed master key, it has public access blocked and will be cleared and deleted on CFN stack deletion.
 *
 * @stability stable
 */
class Cache extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        const bucketName = props.bucketName || "runner-cache";
        const uniqueCacheBucketName = `${scope.stackName}-${bucketName}-${scope.account}-${scope.region}`.toLocaleLowerCase();
        /* Enabled if not 0. If 0 - cache doesnt't expire. If undefined - expiration sets to expire in 30 days */
        this.expiration = (_b = props.expiration) !== null && _b !== void 0 ? _b : core_1.Duration.days(30);
        this.lifeCycleRuleEnabled = this.expiration.toDays() !== 0;
        this.bucket = new aws_s3_1.Bucket(scope, "CacheBucket", {
            bucketName: uniqueCacheBucketName,
            lifecycleRules: [
                {
                    enabled: this.lifeCycleRuleEnabled,
                    expiration: this.expiration,
                },
            ],
            encryption: aws_s3_1.BucketEncryption.KMS_MANAGED,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            autoDeleteObjects: true,
            removalPolicy: core_1.RemovalPolicy.DESTROY,
        });
    }
}
exports.Cache = Cache;
_a = JSII_RTTI_SYMBOL_1;
Cache[_a] = { fqn: "@pepperize-testing/cdk-autoscaling-gitlab-runner.Cache", version: "0.0.70" };
//# sourceMappingURL=data:application/json;base64,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