/**
 * You can change the behavior of GitLab Runner and of individual registered runners.
 *
 * This imitates the structure of Gitlab Runner advanced configuration that originally is set with config.toml file.
 *
 * @see {@link https://docs.gitlab.com/runner/configuration/advanced-configuration.html}
 * @stability stable
 */
export interface GlobalConfiguration {
    /**
     * The limit of the jobs that can be run concurrently across all runners (concurrent).
     *
     * @default 10
     * @stability stable
     */
    readonly concurrent?: number;
    /**
     * The check_interval option defines how often the runner should check GitLab for new jobs| in seconds.
     *
     * @default 0
     * @stability stable
     */
    readonly checkInterval?: number;
    /**
     * The log format.
     *
     * @default "runner"
     * @stability stable
     */
    readonly logFormat?: LogFormat;
    /**
     * The log_level.
     *
     * @default "info"
     * @stability stable
     */
    readonly logLevel?: LogLevel;
}
export declare type LogLevel = "debug" | "info" | "warn" | "error" | "fatal" | "panic";
export declare type LogFormat = "runner" | "text" | "json";
