"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalRuleTemplateRepositoryAssociation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const directories_1 = require("./directories");
class ApprovalRuleTemplateRepositoryAssociation extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.repository = props.repository;
        const resourceType = 'Custom::ApprovalRuleTemplateRepositoryAssociation';
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, resourceType, {
            codeDirectory: directories_1.approvalRuleTemplateRepositoryAssociationDir,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: ['codecommit:AssociateApprovalRuleTemplateWithRepository', 'codecommit:DisassociateApprovalRuleTemplateFromRepository'],
                    Resource: this.repository.repositoryArn,
                },
            ],
        });
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType,
            properties: {
                ApprovalRuleTemplateName: props.approvalRuleTemplateName,
                RepositoryName: this.repository.repositoryName,
            },
        });
    }
    onOverridden(id, options) {
        const rule = this.repository.onPullRequestStateChange(id, options);
        rule.addEventPattern({
            detail: {
                event: ['pullRequestApprovalRuleOverridden'],
            },
        });
        return rule;
    }
}
exports.ApprovalRuleTemplateRepositoryAssociation = ApprovalRuleTemplateRepositoryAssociation;
_a = JSII_RTTI_SYMBOL_1;
ApprovalRuleTemplateRepositoryAssociation[_a] = { fqn: "@cloudcomponents/cdk-pull-request-approval-rule.ApprovalRuleTemplateRepositoryAssociation", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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