/*
 * Decompiled with CFR 0.152.
 */
package emddf.file;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EMDDFileDescr {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_WAVE = 0;
    public static final int TYPE_WAVE64 = 5;
    public static final int TYPE_RAW = 4;
    private static final int NUM_TYPES = 1;
    public static final int FORMAT_INT = 0;
    public static final int FORMAT_FLOAT = 1;
    public File file;
    public int type;
    public int channels;
    public double rate;
    public int bitsPerSample;
    public int sampleFormat;
    public long length;
    public String SURF_initial_timestamp = "";
    public String SURF_timezone = "";
    public float SURF_sample_rate = 0.0f;
    public float[] SURF_channel_calibration;
    public static final String KEY_LABELS = "labels";
    public static final String KEY_NOTES = "notes";
    public static final String KEY_REGIONS = "regions";
    public static final String KEY_MARKERS = "markers";
    public static final String KEY_MISSINGDATA = "missingdata";
    public static final String KEY_COMMENTS = "comment";
    public static final String KEY_METADATA = "metadata";
    public static final String KEY_INFO = "info";
    public static final String KEY_CONFIG = "config";
    private final Map<String, Object> properties;
    private static final Set[] supports;
    private List<PropertyChangeListener> pcs = null;
    private static final String[] FORMAT_SUFFICES;

    static {
        FORMAT_SUFFICES = new String[]{"wav", "raw", "w64"};
        supports = new Set[1];
        HashSet<String> set = new HashSet<String>(6);
        set.add(KEY_LABELS);
        set.add(KEY_NOTES);
        set.add(KEY_REGIONS);
        set.add(KEY_COMMENTS);
        set.add(KEY_METADATA);
        set.add(KEY_CONFIG);
        set.add(KEY_INFO);
        EMDDFileDescr.supports[0] = set;
    }

    public EMDDFileDescr() {
        this.properties = new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EMDDFileDescr(EMDDFileDescr orig) {
        this.file = orig.file;
        this.type = orig.type;
        this.channels = orig.channels;
        this.rate = orig.rate;
        this.bitsPerSample = orig.bitsPerSample;
        this.sampleFormat = orig.sampleFormat;
        this.length = orig.length;
        Map<String, Object> map = orig.properties;
        synchronized (map) {
            this.properties = new HashMap<String, Object>(orig.properties);
        }
        this.SURF_initial_timestamp = orig.SURF_initial_timestamp;
        this.SURF_timezone = orig.SURF_timezone;
        this.SURF_sample_rate = orig.SURF_sample_rate;
        this.SURF_channel_calibration = orig.SURF_channel_calibration;
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(Object key) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            return this.properties.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, Object value) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(Object source, String key, Object value) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            Object oldValue = this.properties.put(key, value);
            if (source != null && this.pcs != null) {
                PropertyChangeEvent e = new PropertyChangeEvent(source, key, oldValue, value);
                int i = 0;
                while (i < this.pcs.size()) {
                    this.pcs.get(i).propertyChange(e);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            if (this.pcs == null) {
                this.pcs = new ArrayList<PropertyChangeListener>();
            }
            this.pcs.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener l) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            if (this.pcs == null) {
                this.pcs.remove(l);
            }
        }
    }

    public boolean isPropertySupported(String key) {
        if (this.type >= 0 && this.type < supports.length) {
            return supports[this.type].contains(key);
        }
        return false;
    }

    public static String getFormatSuffix(int type) {
        if (type >= 0 && type < FORMAT_SUFFICES.length) {
            return FORMAT_SUFFICES[type];
        }
        return null;
    }

    public static double millisToSamples(EMDDFileDescr afd, double ms) {
        return ms / 1000.0 * afd.rate;
    }

    public static double samplesToMillis(EMDDFileDescr afd, long samples) {
        return (double)samples / afd.rate * 1000.0;
    }
}

