/*
 * Decompiled with CFR 0.152.
 */
package emddf.file;

import de.sciss.io.IOUtil;
import de.sciss.io.InterleavedStreamFile;
import de.sciss.io.Marker;
import de.sciss.io.Region;
import de.sciss.io.Span;
import emddf.file.Annotation;
import emddf.file.Config;
import emddf.file.EMDDFileDescr;
import emddf.file.Info;
import emddf.file.MissingData;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class EMDDFile
implements InterleavedStreamFile {
    private static final int MODE_READONLY = 0;
    private static final int MODE_READWRITE = 1;
    protected final RandomAccessFile raf;
    protected final FileChannel fch;
    private final int mode;
    protected EMDDFileDescr afd;
    private AudioFileHeader afh;
    protected ByteBuffer byteBuf;
    private int byteBufCapacity;
    protected int bytesPerFrame;
    protected int frameBufCapacity;
    private BufferHandler bh;
    protected int channels;
    private long framePosition;
    private long updateTime;
    private long updateLen;
    private long updateStep;

    public static EMDDFile openAsRead(File f) throws IOException {
        EMDDFile sf = new EMDDFile(f, 0);
        sf.afd = new EMDDFileDescr();
        sf.afd.file = f;
        String fileExtension = f.toString().split("\\.")[1];
        if (fileExtension.equals("raw")) {
            EMDDFileDescr eMDDFileDescr = sf.afd;
            sf.getDescr();
            eMDDFileDescr.type = 4;
            sf.afd.channels = 2;
            sf.afd.bitsPerSample = 16;
            sf.afd.rate = 60.0;
            sf.afd.sampleFormat = 0;
            sf.afd.length = 60000000L;
        } else {
            sf.afd.type = sf.retrieveType();
        }
        sf.afh = sf.createHeader();
        sf.afh.readHeader(sf.afd);
        sf.init();
        sf.seekFrame(0L);
        return sf;
    }

    public static EMDDFile openAsWrite(EMDDFileDescr afd) throws IOException {
        if (afd.file.exists()) {
            afd.file.delete();
        }
        EMDDFile sf = new EMDDFile(afd.file, 1);
        sf.afd = afd;
        afd.length = 0L;
        sf.afh = sf.createHeader();
        sf.afh.writeHeader(sf.afd);
        sf.init();
        sf.seekFrame(0L);
        sf.updateLen = sf.updateStep = (long)afd.rate * 20L;
        sf.updateTime = System.currentTimeMillis() + 10000L;
        return sf;
    }

    public static EMDDFile openAsWriteWithoutWriteHeaders(File file, EMDDFileDescr afd) throws IOException {
        EMDDFile sf = new EMDDFile(file, 1);
        sf.afd = afd;
        afd.length = 0L;
        sf.afh = sf.createHeader();
        sf.afh.readHeader(sf.afd);
        sf.init();
        sf.seekFrame(0L);
        return sf;
    }

    public static int retrieveType(File f) throws IOException {
        EMDDFile sf = new EMDDFile(f, 0);
        int type = sf.retrieveType();
        sf.cleanUp();
        return type;
    }

    private EMDDFile(File f, int mode) throws IOException {
        this.raf = new RandomAccessFile(f, mode == 1 ? "rw" : "r");
        this.fch = this.raf.getChannel();
        this.mode = mode;
    }

    public EMDDFileDescr getDescr() {
        return this.afd;
    }

    public File getFile() {
        return this.afd.file;
    }

    private void init() throws IOException {
        this.channels = this.afd.channels;
        this.bytesPerFrame = (this.afd.bitsPerSample >> 3) * this.channels;
        this.frameBufCapacity = Math.max(1, 65536 / Math.max(1, this.bytesPerFrame));
        this.byteBufCapacity = this.frameBufCapacity * this.bytesPerFrame;
        this.byteBuf = ByteBuffer.allocateDirect(this.byteBufCapacity);
        this.byteBuf.order(this.afh.getByteOrder());
        this.bh = null;
        block0 : switch (this.afd.sampleFormat) {
            case 0: {
                switch (this.afd.bitsPerSample) {
                    case 8: {
                        if (this.afh.isUnsignedPCM()) {
                            this.bh = new UByteBufferHandler();
                            break;
                        }
                        this.bh = new ByteBufferHandler();
                        break;
                    }
                    case 16: {
                        this.bh = new ShortBufferHandler();
                        break;
                    }
                    case 24: {
                        if (this.afh.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                            this.bh = new ThreeByteBufferHandler();
                            break;
                        }
                        this.bh = new ThreeLittleByteBufferHandler();
                        break;
                    }
                    case 32: {
                        this.bh = new IntBufferHandler();
                    }
                }
                break;
            }
            case 1: {
                switch (this.afd.bitsPerSample) {
                    case 32: {
                        this.bh = new FloatBufferHandler();
                        break block0;
                    }
                    case 64: {
                        this.bh = new DoubleBufferHandler();
                    }
                }
            }
        }
        if (this.bh == null) {
            throw new IOException(EMDDFile.getResourceString("errAudioFileEncoding"));
        }
    }

    private AudioFileHeader createHeader() throws IOException {
        switch (this.afd.getType()) {
            case 0: {
                return new WAVEHeader();
            }
            case 5: {
                return new Wave64Header();
            }
            case 4: {
                return new RawHeader();
            }
        }
        throw new IOException(EMDDFile.getResourceString("errAudioFileType"));
    }

    private int retrieveType() throws IOException {
        long len = this.raf.length();
        long oldpos = this.raf.getFilePointer();
        int type = -1;
        if (len < 4L) {
            return type;
        }
        this.raf.seek(0L);
        int magic = this.raf.readInt();
        switch (magic) {
            case 1380533830: {
                if (len < 12L) break;
                this.raf.readInt();
                magic = this.raf.readInt();
                switch (magic) {
                    case 1463899717: {
                        type = 0;
                    }
                }
                break;
            }
            case 1919510118: {
                if (len < 40L || this.raf.readInt() != 781307665 || this.raf.readLong() != -6496960491292655616L) break;
                this.raf.readLong();
                if (this.raf.readLong() != 8602286943506322193L || this.raf.readLong() != -8299851812298630262L) break;
                type = 5;
                break;
            }
        }
        this.raf.seek(oldpos);
        return type;
    }

    public void seekFrame(long frame) throws IOException {
        long physical = this.afh.getSampleDataOffset() + frame * (long)this.bytesPerFrame;
        this.raf.seek(physical);
        this.framePosition = frame;
    }

    public void flush() throws IOException {
        this.updateTime = System.currentTimeMillis() + 10000L;
        this.afd.length = this.framePosition;
        this.afh.updateHeader(this.afd);
        this.updateLen = this.framePosition + this.updateStep;
        this.fch.force(true);
    }

    public long getFramePosition() throws IOException {
        return this.framePosition;
    }

    public void readFrames(float[][] data, int offset, int length) throws IOException {
        this.bh.readFrames(data, offset, length);
        this.framePosition += (long)length;
    }

    public void writeFrames(float[][] data, int offset, int length) throws IOException {
        this.bh.writeFrames(data, offset, length);
        this.framePosition += (long)length;
        if (this.framePosition > this.afd.length) {
            if (this.framePosition > this.updateLen || System.currentTimeMillis() > this.updateTime) {
                this.flush();
            } else {
                this.afd.length = this.framePosition;
            }
        }
    }

    public long getFrameNum() throws IOException {
        return this.afd.length;
    }

    public void setFrameNum(long frame) throws IOException {
        long physical = this.afh.getSampleDataOffset() + frame * (long)this.bytesPerFrame;
        this.raf.setLength(physical);
        if (this.framePosition > frame) {
            this.framePosition = frame;
        }
        this.afd.length = frame;
    }

    public int getChannelNum() {
        return this.afd.channels;
    }

    public void truncate() throws IOException {
        this.fch.truncate(this.fch.position());
        if (this.framePosition != this.afd.length) {
            this.afd.length = this.framePosition;
            this.updateTime = System.currentTimeMillis() + 10000L;
            this.afh.updateHeader(this.afd);
            this.updateLen = this.framePosition + this.updateStep;
        }
    }

    public void copyFrames(InterleavedStreamFile target, long length) throws IOException {
        int tempBufSize = (int)Math.min(length, 600000L);
        float[][] tempBuf = new float[this.channels][tempBufSize];
        while (length > 0L) {
            int chunkLength = (int)Math.min(length, (long)tempBufSize);
            this.readFrames(tempBuf, 0, chunkLength);
            target.writeFrames(tempBuf, 0, chunkLength);
            length -= (long)chunkLength;
        }
    }

    public void close() throws IOException {
        if (this.mode == 1) {
            this.fch.force(true);
            this.afh.updateHeader(this.afd);
        }
        this.raf.close();
    }

    public void cleanUp() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readMetadata() throws IOException {
        this.afh.readMetadata();
    }

    public void readMarkers() throws IOException {
        this.afh.readMarkers();
        this.afh.readMissingDataChunks();
    }

    protected static final String getResourceString(String key) {
        return IOUtil.getResourceString((String)key);
    }

    private abstract class AbstractRIFFHeader
    extends AudioFileHeader {
        protected static final int ADTL_MAGIC = 1633973356;
        protected static final int LABL_MAGIC = 1818321516;
        protected static final int LTXT_MAGIC = 1819572340;
        protected static final int NOTE_MAGIC = 1852798053;
        protected static final int RGN_MAGIC = 1919381024;
        protected static final int FORMAT_PCM = 1;
        protected static final int FORMAT_FLOAT = 3;
        protected static final int FORMAT_EXT = 65534;
        protected static final int INFO_MAGIC = 1229866575;
        protected static final int IARL_MAGIC = 1229017676;
        protected static final int IART_MAGIC = 1229017684;
        protected static final int ICMS_MAGIC = 1229147475;
        protected static final int ICMT_MAGIC = 1229147476;
        protected static final int ICOP_MAGIC = 1229147984;
        protected static final int ICRD_MAGIC = 1229148740;
        protected static final int IKEY_MAGIC = 1229669721;
        protected static final int INAM_MAGIC = 1229865293;
        protected static final int IPRD_MAGIC = 1230000708;
        protected static final int ISBJ_MAGIC = 1230193226;
        protected static final int ISFT_MAGIC = 1230194260;
        protected static final int ISRC_MAGIC = 1230197315;
        protected static final int ISRF_MAGIC = 1230197318;
        protected long sampleDataOffset;
        protected long dataLengthOffset;
        protected long factSmpNumOffset;
        protected long lastUpdateLength;
        protected boolean isFloat;
        protected boolean unsignedPCM;

        protected AbstractRIFFHeader() {
            this.lastUpdateLength = 0L;
            this.isFloat = false;
        }
    }

    private abstract class AudioFileHeader {
        protected AudioFileHeader() {
        }

        protected abstract void readHeader(EMDDFileDescr var1) throws IOException;

        protected abstract void writeHeader(EMDDFileDescr var1) throws IOException;

        protected abstract void updateHeader(EMDDFileDescr var1) throws IOException;

        protected abstract long getSampleDataOffset();

        protected abstract ByteOrder getByteOrder();

        protected boolean isUnsignedPCM() {
            return false;
        }

        protected void readMetadata() throws IOException {
        }

        protected void readMarkers() throws IOException {
        }

        protected void readMissingDataChunks() throws IOException {
        }

        protected final int readLittleUShort() throws IOException {
            int i = EMDDFile.this.raf.readUnsignedShort();
            return i >> 8 | (i & 0xFF) << 8;
        }

        protected final int readLittleInt() throws IOException {
            int i = EMDDFile.this.raf.readInt();
            return i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24;
        }

        protected final float readLittleFloat() throws IOException {
            int i = EMDDFile.this.raf.readInt();
            return Float.intBitsToFloat(i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24);
        }

        protected final long readLittleLong() throws IOException {
            long n = EMDDFile.this.raf.readLong();
            return n >> 56 & 0xFFL | n >> 40 & 0xFF00L | n >> 24 & 0xFF0000L | n >> 8 & 0xFF000000L | n << 8 & 0xFF00000000L | n << 24 & 0xFF0000000000L | n << 40 & 0xFF000000000000L | n << 56;
        }

        protected final void writeLittleShort(int i) throws IOException {
            EMDDFile.this.raf.writeShort(i >> 8 | (i & 0xFF) << 8);
        }

        protected final void writeLittleInt(int i) throws IOException {
            EMDDFile.this.raf.writeInt(i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24);
        }

        protected final void writeLittleLong(long n) throws IOException {
            EMDDFile.this.raf.writeLong(n >> 56 & 0xFFL | n >> 40 & 0xFF00L | n >> 24 & 0xFF0000L | n >> 8 & 0xFF000000L | n << 8 & 0xFF00000000L | n << 24 & 0xFF0000000000L | n << 40 & 0xFF000000000000L | n << 56);
        }

        protected int getSize(String src) {
            int size = 0;
            try {
                size = src.getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return size;
        }

        protected byte[] getBytes(String src) {
            byte[] bytes = new byte[1];
            try {
                bytes = src.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return bytes;
        }
    }

    private abstract class BufferHandler {
        protected BufferHandler() {
        }

        protected abstract void writeFrames(float[][] var1, int var2, int var3) throws IOException;

        protected abstract void readFrames(float[][] var1, int var2, int var3) throws IOException;
    }

    private class ByteBufferHandler
    extends BufferHandler {
        private final byte[] arrayBuf;

        protected ByteBufferHandler() {
            this.arrayBuf = new byte[EMDDFile.this.byteBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.bytesPerFrame;
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    int i = ch;
                    int j = offset;
                    while (i < m) {
                        this.arrayBuf[i] = (byte)(b[j] * 127.0f);
                        i += EMDDFile.this.channels;
                        ++j;
                    }
                    ++ch;
                }
                EMDDFile.this.byteBuf.clear();
                EMDDFile.this.byteBuf.put(this.arrayBuf, 0, m);
                EMDDFile.this.byteBuf.flip();
                EMDDFile.this.fch.write(EMDDFile.this.byteBuf);
                length -= chunkLength;
                offset += chunkLength;
            }
        }

        @Override
        protected void readFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.bytesPerFrame;
                EMDDFile.this.byteBuf.rewind().limit(m);
                EMDDFile.this.fch.read(EMDDFile.this.byteBuf);
                EMDDFile.this.byteBuf.flip();
                EMDDFile.this.byteBuf.get(this.arrayBuf, 0, m);
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    if (b != null) {
                        int i = ch;
                        int j = offset;
                        while (i < m) {
                            b[j] = (float)this.arrayBuf[i] / 127.0f;
                            i += EMDDFile.this.channels;
                            ++j;
                        }
                    }
                    ++ch;
                }
                length -= chunkLength;
                offset += chunkLength;
            }
        }
    }

    private class DoubleBufferHandler
    extends BufferHandler {
        private final DoubleBuffer viewBuf;
        private final double[] arrayBuf;

        protected DoubleBufferHandler() {
            EMDDFile.this.byteBuf.clear();
            this.viewBuf = EMDDFile.this.byteBuf.asDoubleBuffer();
            this.arrayBuf = new double[this.viewBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.channels;
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    int i = ch;
                    int j = offset;
                    while (i < m) {
                        this.arrayBuf[i] = b[j];
                        i += EMDDFile.this.channels;
                        ++j;
                    }
                    ++ch;
                }
                this.viewBuf.clear();
                this.viewBuf.put(this.arrayBuf, 0, m);
                EMDDFile.this.byteBuf.rewind().limit(chunkLength * EMDDFile.this.bytesPerFrame);
                EMDDFile.this.fch.write(EMDDFile.this.byteBuf);
                length -= chunkLength;
                offset += chunkLength;
            }
        }

        @Override
        protected void readFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.channels;
                EMDDFile.this.byteBuf.rewind().limit(chunkLength * EMDDFile.this.bytesPerFrame);
                EMDDFile.this.fch.read(EMDDFile.this.byteBuf);
                this.viewBuf.clear();
                this.viewBuf.get(this.arrayBuf, 0, m);
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    if (b != null) {
                        int i = ch;
                        int j = offset;
                        while (i < m) {
                            b[j] = (float)this.arrayBuf[i];
                            i += EMDDFile.this.channels;
                            ++j;
                        }
                    }
                    ++ch;
                }
                length -= chunkLength;
                offset += chunkLength;
            }
        }
    }

    private class FloatBufferHandler
    extends BufferHandler {
        private final FloatBuffer viewBuf;
        private final float[] arrayBuf;

        protected FloatBufferHandler() {
            EMDDFile.this.byteBuf.clear();
            this.viewBuf = EMDDFile.this.byteBuf.asFloatBuffer();
            this.arrayBuf = new float[this.viewBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.channels;
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    int i = ch;
                    int j = offset;
                    while (i < m) {
                        this.arrayBuf[i] = b[j];
                        i += EMDDFile.this.channels;
                        ++j;
                    }
                    ++ch;
                }
                this.viewBuf.clear();
                this.viewBuf.put(this.arrayBuf, 0, m);
                EMDDFile.this.byteBuf.rewind().limit(chunkLength * EMDDFile.this.bytesPerFrame);
                EMDDFile.this.fch.write(EMDDFile.this.byteBuf);
                length -= chunkLength;
                offset += chunkLength;
            }
        }

        @Override
        protected void readFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.channels;
                EMDDFile.this.byteBuf.rewind().limit(chunkLength * EMDDFile.this.bytesPerFrame);
                EMDDFile.this.fch.read(EMDDFile.this.byteBuf);
                this.viewBuf.clear();
                this.viewBuf.get(this.arrayBuf, 0, m);
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    if (b != null) {
                        int i = ch;
                        int j = offset;
                        while (i < m) {
                            b[j] = this.arrayBuf[i];
                            i += EMDDFile.this.channels;
                            ++j;
                        }
                    }
                    ++ch;
                }
                length -= chunkLength;
                offset += chunkLength;
            }
        }
    }

    private class IntBufferHandler
    extends BufferHandler {
        private final IntBuffer viewBuf;
        private final int[] arrayBuf;

        protected IntBufferHandler() {
            EMDDFile.this.byteBuf.clear();
            this.viewBuf = EMDDFile.this.byteBuf.asIntBuffer();
            this.arrayBuf = new int[this.viewBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.channels;
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    int i = ch;
                    int j = offset;
                    while (i < m) {
                        this.arrayBuf[i] = (int)(b[j] * 2.1474836E9f);
                        i += EMDDFile.this.channels;
                        ++j;
                    }
                    ++ch;
                }
                this.viewBuf.clear();
                this.viewBuf.put(this.arrayBuf, 0, m);
                EMDDFile.this.byteBuf.rewind().limit(chunkLength * EMDDFile.this.bytesPerFrame);
                EMDDFile.this.fch.write(EMDDFile.this.byteBuf);
                length -= chunkLength;
                offset += chunkLength;
            }
        }

        @Override
        protected void readFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.channels;
                EMDDFile.this.byteBuf.rewind().limit(chunkLength * EMDDFile.this.bytesPerFrame);
                EMDDFile.this.fch.read(EMDDFile.this.byteBuf);
                this.viewBuf.clear();
                this.viewBuf.get(this.arrayBuf, 0, m);
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    if (b != null) {
                        int i = ch;
                        int j = offset;
                        while (i < m) {
                            b[j] = (float)this.arrayBuf[i] / 2.1474836E9f;
                            i += EMDDFile.this.channels;
                            ++j;
                        }
                    }
                    ++ch;
                }
                length -= chunkLength;
                offset += chunkLength;
            }
        }
    }

    private class RawHeader
    extends AudioFileHeader {
        protected RawHeader() {
        }

        @Override
        protected void readHeader(EMDDFileDescr descr) throws IOException {
        }

        @Override
        protected void writeHeader(EMDDFileDescr descr) throws IOException {
        }

        @Override
        protected void updateHeader(EMDDFileDescr descr) throws IOException {
        }

        @Override
        protected long getSampleDataOffset() {
            return 0L;
        }

        @Override
        protected ByteOrder getByteOrder() {
            return ByteOrder.BIG_ENDIAN;
        }
    }

    private class ShortBufferHandler
    extends BufferHandler {
        private final ShortBuffer viewBuf;
        private final short[] arrayBuf;

        protected ShortBufferHandler() {
            EMDDFile.this.byteBuf.clear();
            this.viewBuf = EMDDFile.this.byteBuf.asShortBuffer();
            this.arrayBuf = new short[this.viewBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.channels;
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    if (b != null) {
                        int i = ch;
                        int j = offset;
                        while (i < m) {
                            this.arrayBuf[i] = (short)(b[j] * 32767.0f);
                            i += EMDDFile.this.channels;
                            ++j;
                        }
                    }
                    ++ch;
                }
                this.viewBuf.clear();
                this.viewBuf.put(this.arrayBuf, 0, m);
                EMDDFile.this.byteBuf.rewind().limit(chunkLength * EMDDFile.this.bytesPerFrame);
                EMDDFile.this.fch.write(EMDDFile.this.byteBuf);
                length -= chunkLength;
                offset += chunkLength;
            }
        }

        @Override
        protected void readFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.channels;
                EMDDFile.this.byteBuf.rewind().limit(chunkLength * EMDDFile.this.bytesPerFrame);
                EMDDFile.this.fch.read(EMDDFile.this.byteBuf);
                this.viewBuf.clear();
                this.viewBuf.get(this.arrayBuf, 0, m);
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    if (b != null) {
                        int i = ch;
                        int j = offset;
                        while (i < m) {
                            b[j] = (float)this.arrayBuf[i] / 32767.0f;
                            i += EMDDFile.this.channels;
                            ++j;
                        }
                    }
                    ++ch;
                }
                length -= chunkLength;
                offset += chunkLength;
            }
        }
    }

    private class ThreeByteBufferHandler
    extends BufferHandler {
        private final byte[] arrayBuf;
        private final int chStep;

        protected ThreeByteBufferHandler() {
            this.chStep = (EMDDFile.this.channels - 1) * 3;
            this.arrayBuf = new byte[EMDDFile.this.byteBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.bytesPerFrame;
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    int i = ch * 3;
                    int j = offset;
                    while (i < m) {
                        int k = (int)(b[j] * 8388607.0f);
                        this.arrayBuf[i++] = (byte)(k >> 16);
                        this.arrayBuf[i++] = (byte)(k >> 8);
                        this.arrayBuf[i++] = (byte)k;
                        i += this.chStep;
                        ++j;
                    }
                    ++ch;
                }
                EMDDFile.this.byteBuf.clear();
                EMDDFile.this.byteBuf.put(this.arrayBuf, 0, m);
                EMDDFile.this.byteBuf.flip();
                EMDDFile.this.fch.write(EMDDFile.this.byteBuf);
                length -= chunkLength;
                offset += chunkLength;
            }
        }

        @Override
        protected void readFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.bytesPerFrame;
                EMDDFile.this.byteBuf.rewind().limit(m);
                EMDDFile.this.fch.read(EMDDFile.this.byteBuf);
                EMDDFile.this.byteBuf.flip();
                EMDDFile.this.byteBuf.get(this.arrayBuf, 0, m);
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    if (b != null) {
                        int i = ch * 3;
                        int j = offset;
                        while (i < m) {
                            b[j] = (float)(this.arrayBuf[i++] << 16 | (this.arrayBuf[i++] & 0xFF) << 8 | this.arrayBuf[i++] & 0xFF) / 8388607.0f;
                            i += this.chStep;
                            ++j;
                        }
                    }
                    ++ch;
                }
                length -= chunkLength;
                offset += chunkLength;
            }
        }
    }

    private class ThreeLittleByteBufferHandler
    extends BufferHandler {
        private final byte[] arrayBuf;
        private final int chStep;

        protected ThreeLittleByteBufferHandler() {
            this.chStep = (EMDDFile.this.channels - 1) * 3;
            this.arrayBuf = new byte[EMDDFile.this.byteBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.bytesPerFrame;
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    if (b != null) {
                        int i = ch * 3;
                        int j = offset;
                        while (i < m) {
                            int k = (int)(b[j] * 8388607.0f);
                            this.arrayBuf[i++] = (byte)k;
                            this.arrayBuf[i++] = (byte)(k >> 8);
                            this.arrayBuf[i++] = (byte)(k >> 16);
                            i += this.chStep;
                            ++j;
                        }
                    }
                    ++ch;
                }
                EMDDFile.this.byteBuf.clear();
                EMDDFile.this.byteBuf.put(this.arrayBuf, 0, m);
                EMDDFile.this.byteBuf.flip();
                EMDDFile.this.fch.write(EMDDFile.this.byteBuf);
                length -= chunkLength;
                offset += chunkLength;
            }
        }

        @Override
        protected void readFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.bytesPerFrame;
                EMDDFile.this.byteBuf.rewind().limit(m);
                EMDDFile.this.fch.read(EMDDFile.this.byteBuf);
                EMDDFile.this.byteBuf.flip();
                EMDDFile.this.byteBuf.get(this.arrayBuf, 0, m);
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    if (b != null) {
                        int i = ch * 3;
                        int j = offset;
                        while (i < m) {
                            b[j] = (float)(this.arrayBuf[i++] & 0xFF | (this.arrayBuf[i++] & 0xFF) << 8 | this.arrayBuf[i++] << 16) / 8388607.0f;
                            i += this.chStep;
                            ++j;
                        }
                    }
                    ++ch;
                }
                length -= chunkLength;
                offset += chunkLength;
            }
        }
    }

    private class UByteBufferHandler
    extends BufferHandler {
        private final byte[] arrayBuf;

        protected UByteBufferHandler() {
            this.arrayBuf = new byte[EMDDFile.this.byteBuf.capacity()];
        }

        @Override
        protected void writeFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.bytesPerFrame;
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    int i = ch;
                    int j = offset;
                    while (i < m) {
                        this.arrayBuf[i] = (byte)(b[j] * 127.0f + 128.0f);
                        i += EMDDFile.this.channels;
                        ++j;
                    }
                    ++ch;
                }
                EMDDFile.this.byteBuf.clear();
                EMDDFile.this.byteBuf.put(this.arrayBuf, 0, m);
                EMDDFile.this.byteBuf.flip();
                EMDDFile.this.fch.write(EMDDFile.this.byteBuf);
                length -= chunkLength;
                offset += chunkLength;
            }
        }

        @Override
        protected void readFrames(float[][] frames, int offset, int length) throws IOException {
            while (length > 0) {
                int chunkLength = Math.min(EMDDFile.this.frameBufCapacity, length);
                int m = chunkLength * EMDDFile.this.bytesPerFrame;
                EMDDFile.this.byteBuf.rewind().limit(m);
                EMDDFile.this.fch.read(EMDDFile.this.byteBuf);
                EMDDFile.this.byteBuf.flip();
                EMDDFile.this.byteBuf.get(this.arrayBuf, 0, m);
                int ch = 0;
                while (ch < EMDDFile.this.channels) {
                    float[] b = frames[ch];
                    if (b != null) {
                        int i = ch;
                        int j = offset;
                        while (i < m) {
                            b[j] = this.arrayBuf[i] < 0 ? (float)(128 + this.arrayBuf[i]) / 127.0f : (float)(this.arrayBuf[i] - 128) / 127.0f;
                            i += EMDDFile.this.channels;
                            ++j;
                        }
                    }
                    ++ch;
                }
                length -= chunkLength;
                offset += chunkLength;
            }
        }
    }

    private class WAVEHeader
    extends AbstractRIFFHeader {
        private static final int RIFF_MAGIC = 1380533830;
        private static final int WAVE_MAGIC = 1463899717;
        private static final int MDL_MAGIC = 1296321568;
        private static final int MD_MAGIC = 1296318804;
        private static final int FMT_MAGIC = 1718449184;
        private static final int DATA_MAGIC = 1684108385;
        private static final int CUE_MAGIC = 1668637984;
        private static final int LIST_MAGIC = 1818850164;
        private static final int LIST_MAGIC2 = 1279873876;
        private static final int COMT_MAGIC = 1129270612;
        private static final int ANNO_MAGIC = 1095650895;
        private static final int META_MAGIC = 1296389185;
        private static final int CNFG_MAGIC = 1129203271;
        private static final int TMST_MAGIC = 1414353748;
        private static final int TMZN_MAGIC = 1414355534;
        private static final int SPRT_MAGIC = 1397772884;
        private static final int CHCC_MAGIC = 0x43484343;
        private static final long riffLengthOffset = 4L;
        private long listMagicOff = 0L;
        private long listMagicLen = 0L;
        private long mdlMagicOff = 0L;
        private long mdlMagicLen = 0L;
        private long cueMagicOff = 0L;
        private long annoMagicOff = 0L;
        private long annoMagicLen = 0L;
        private long cnfgMagicOff = 0L;
        private long cnfgMagicLen = 0L;
        private long infoMagicOff = 0L;
        private long infoMagicLen = 0L;

        protected WAVEHeader() {
        }

        @Override
        protected void readHeader(EMDDFileDescr descr) throws IOException {
            int dataLen = 0;
            int bpf = 0;
            EMDDFile.this.raf.readInt();
            EMDDFile.this.raf.readInt();
            long len = EMDDFile.this.raf.length() - 8L;
            EMDDFile.this.raf.readInt();
            len -= 4L;
            int chunkLen = 0;
            int essentials = 2;
            while (len > 0L && essentials > 0) {
                if (chunkLen != 0) {
                    EMDDFile.this.raf.seek(EMDDFile.this.raf.getFilePointer() + (long)chunkLen);
                }
                int magic = EMDDFile.this.raf.readInt();
                chunkLen = this.readLittleInt() + 1 & 0xFFFFFFFE;
                len -= (long)(chunkLen + 8);
                block0 : switch (magic) {
                    case 1718449184: {
                        --essentials;
                        int i = this.readLittleUShort();
                        descr.channels = this.readLittleUShort();
                        int i1 = this.readLittleInt();
                        descr.rate = i1;
                        int i2 = this.readLittleInt();
                        bpf = this.readLittleUShort();
                        descr.bitsPerSample = this.readLittleUShort();
                        if ((descr.bitsPerSample & 7) != 0 || (descr.bitsPerSample >> 3) * descr.channels != bpf || (descr.bitsPerSample >> 3) * descr.channels * i1 != i2) {
                            throw new IOException(EMDDFile.getResourceString("errAudioFileEncoding"));
                        }
                        this.unsignedPCM = bpf == 1;
                        chunkLen -= 16;
                        switch (i) {
                            case 1: {
                                descr.sampleFormat = 0;
                                break block0;
                            }
                            case 3: {
                                descr.sampleFormat = 1;
                                break block0;
                            }
                            case 65534: {
                                if (chunkLen < 24) {
                                    throw new IOException(EMDDFile.getResourceString("errAudioFileIncomplete"));
                                }
                                i1 = this.readLittleUShort();
                                if (i1 < 22) {
                                    throw new IOException(EMDDFile.getResourceString("errAudioFileIncomplete"));
                                }
                                i2 = this.readLittleUShort();
                                EMDDFile.this.raf.readInt();
                                int i3 = this.readLittleUShort();
                                if (i2 != descr.bitsPerSample || i3 != 1 && i3 != 3) {
                                    throw new IOException(EMDDFile.getResourceString("errAudioFileEncoding"));
                                }
                                descr.sampleFormat = i3 == 1 ? 0 : 1;
                                chunkLen -= 10;
                                break block0;
                            }
                        }
                        throw new IOException(EMDDFile.getResourceString("errAudioFileEncoding"));
                    }
                    case 1684108385: {
                        --essentials;
                        this.sampleDataOffset = EMDDFile.this.raf.getFilePointer();
                        dataLen = chunkLen;
                        break;
                    }
                    case 1668637984: {
                        this.cueMagicOff = EMDDFile.this.raf.getFilePointer();
                        break;
                    }
                    case 1279873876: 
                    case 1818850164: {
                        int i = EMDDFile.this.raf.readInt();
                        chunkLen -= 4;
                        if (i == 1296321568) {
                            this.mdlMagicOff = EMDDFile.this.raf.getFilePointer();
                            this.mdlMagicLen = chunkLen;
                        }
                        if (i == 1633973356) {
                            this.listMagicOff = EMDDFile.this.raf.getFilePointer();
                            this.listMagicLen = chunkLen;
                        }
                        if (i == 1095650895) {
                            this.annoMagicOff = EMDDFile.this.raf.getFilePointer();
                            this.annoMagicLen = chunkLen;
                        }
                        if (i == 1129203271) {
                            this.cnfgMagicOff = EMDDFile.this.raf.getFilePointer();
                            this.cnfgMagicLen = chunkLen;
                        }
                        if (i != 1229866575) break;
                        this.infoMagicOff = EMDDFile.this.raf.getFilePointer();
                        this.infoMagicLen = chunkLen;
                        break;
                    }
                }
            }
            if (essentials > 0) {
                throw new IOException(EMDDFile.getResourceString("errAudioFileIncomplete"));
            }
            descr.length = dataLen / bpf;
        }

        @Override
        protected void writeHeader(EMDDFileDescr descr) throws IOException {
            Config config;
            descr.SURF_sample_rate = (float)descr.rate;
            descr.rate = descr.SURF_sample_rate >= 1.0f ? (double)descr.SURF_sample_rate : 1.0;
            this.isFloat = descr.sampleFormat == 1;
            EMDDFile.this.raf.writeInt(1380533830);
            EMDDFile.this.raf.writeInt(0);
            EMDDFile.this.raf.writeInt(1463899717);
            EMDDFile.this.raf.writeInt(1718449184);
            this.writeLittleInt(this.isFloat ? 18 : 16);
            this.writeLittleShort(this.isFloat ? 3 : 1);
            this.writeLittleShort(descr.channels);
            int i1 = (int)(descr.rate + 0.5);
            this.writeLittleInt(i1);
            int i2 = (descr.bitsPerSample >> 3) * descr.channels;
            this.writeLittleInt(i1 * i2);
            this.writeLittleShort(i2);
            this.writeLittleShort(descr.bitsPerSample);
            if (this.isFloat) {
                EMDDFile.this.raf.writeShort(0);
            }
            if ((config = (Config)descr.getProperty("config")) == null) {
                config = new Config();
            }
            EMDDFile.this.raf.writeInt(1818850164);
            long pos = EMDDFile.this.raf.getFilePointer();
            EMDDFile.this.raf.writeInt(0);
            EMDDFile.this.raf.writeInt(1129203271);
            int i3 = this.getSize(config.surf_initial_timestamp) + 1;
            EMDDFile.this.raf.writeInt(1414353748);
            this.writeLittleInt(i3);
            EMDDFile.this.raf.writeBytes(config.surf_initial_timestamp);
            if ((i3 & 1) == 0) {
                EMDDFile.this.raf.writeByte(0);
            } else {
                EMDDFile.this.raf.writeShort(0);
            }
            i3 = this.getSize(config.surf_timezone) + 1;
            EMDDFile.this.raf.writeInt(1414355534);
            this.writeLittleInt(i3);
            EMDDFile.this.raf.writeBytes(config.surf_timezone);
            if ((i3 & 1) == 0) {
                EMDDFile.this.raf.writeByte(0);
            } else {
                EMDDFile.this.raf.writeShort(0);
            }
            i3 = 4;
            EMDDFile.this.raf.writeInt(1397772884);
            this.writeLittleInt(i3);
            EMDDFile.this.raf.writeFloat(config.surf_sampling_rate);
            i3 = 4;
            if (config.surf_channel_callibration == null) {
                config.surf_channel_callibration = new float[]{1.0f, 1.0f};
            }
            int c = 0;
            while (c < EMDDFile.this.afd.channels) {
                EMDDFile.this.raf.writeInt(0x43484343);
                this.writeLittleInt(i3);
                EMDDFile.this.raf.writeFloat(config.surf_channel_callibration[c]);
                ++c;
            }
            long pos2 = EMDDFile.this.raf.getFilePointer();
            int i = (int)(pos2 - pos - 4L);
            if ((i & 1) == 1) {
                EMDDFile.this.raf.write(0);
                ++pos2;
            }
            EMDDFile.this.raf.seek(pos);
            this.writeLittleInt(i);
            EMDDFile.this.raf.seek(pos2);
            EMDDFile.this.raf.writeInt(1818850164);
            pos = EMDDFile.this.raf.getFilePointer();
            EMDDFile.this.raf.writeInt(0);
            EMDDFile.this.raf.writeInt(1296321568);
            List mdlist = (List)descr.getProperty("missingdata");
            int mdSize = 0;
            if (mdlist != null) {
                i = 0;
                while (i < mdlist.size()) {
                    MissingData md = (MissingData)mdlist.get(i);
                    mdSize = this.getSize(md.toJSON()) + 1;
                    EMDDFile.this.raf.writeInt(1296318804);
                    this.writeLittleInt(mdSize);
                    EMDDFile.this.raf.write(this.getBytes(md.toJSON()));
                    if ((mdSize & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                    ++i;
                }
            }
            if (((i = (int)((pos2 = EMDDFile.this.raf.getFilePointer()) - pos - 4L)) & 1) == 1) {
                EMDDFile.this.raf.write(0);
                ++pos2;
            }
            EMDDFile.this.raf.seek(pos);
            this.writeLittleInt(i);
            EMDDFile.this.raf.seek(pos2);
            ArrayList labels = (ArrayList)descr.getProperty("labels");
            ArrayList regions = (ArrayList)descr.getProperty("regions");
            ArrayList notes = (ArrayList)descr.getProperty("notes");
            ArrayList comments = (ArrayList)descr.getProperty("comment");
            ArrayList metadata = (ArrayList)descr.getProperty("metadata");
            Info SURF_info = (Info)descr.getProperty("info");
            if (labels != null && !labels.isEmpty() || regions != null && !regions.isEmpty() || notes != null && !notes.isEmpty()) {
                Region region;
                Marker marker;
                if (labels == null) {
                    labels = new ArrayList();
                }
                if (regions == null) {
                    regions = new ArrayList();
                }
                if (notes == null) {
                    notes = new ArrayList();
                }
                EMDDFile.this.raf.writeInt(1668637984);
                i2 = labels.size() + regions.size() + notes.size();
                this.writeLittleInt(24 * i2 + 4);
                this.writeLittleInt(i2);
                i = 0;
                i1 = 1;
                while (i < labels.size()) {
                    marker = (Marker)labels.get(i);
                    this.writeLittleInt(i1);
                    this.writeLittleInt(i1);
                    EMDDFile.this.raf.writeInt(1684108385);
                    EMDDFile.this.raf.writeLong(0L);
                    this.writeLittleInt((int)marker.pos);
                    ++i;
                    ++i1;
                }
                i = 0;
                while (i < regions.size()) {
                    region = (Region)regions.get(i);
                    this.writeLittleInt(i1);
                    this.writeLittleInt(i1);
                    EMDDFile.this.raf.writeInt(1684108385);
                    EMDDFile.this.raf.writeLong(0L);
                    this.writeLittleInt((int)region.span.getStart());
                    ++i;
                    ++i1;
                }
                i = 0;
                while (i < notes.size()) {
                    marker = (Marker)notes.get(i);
                    this.writeLittleInt(i1);
                    this.writeLittleInt(i1);
                    EMDDFile.this.raf.writeInt(1684108385);
                    EMDDFile.this.raf.writeLong(0L);
                    this.writeLittleInt((int)marker.pos);
                    ++i;
                    ++i1;
                }
                EMDDFile.this.raf.writeInt(1818850164);
                pos = EMDDFile.this.raf.getFilePointer();
                EMDDFile.this.raf.writeInt(0);
                EMDDFile.this.raf.writeInt(1633973356);
                i = 0;
                i1 = 1;
                while (i < labels.size()) {
                    marker = (Marker)labels.get(i);
                    i3 = this.getSize(marker.name) + 5;
                    EMDDFile.this.raf.writeInt(1818321516);
                    this.writeLittleInt(i3);
                    this.writeLittleInt(i1);
                    EMDDFile.this.raf.write(this.getBytes(marker.name));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                    ++i;
                    ++i1;
                }
                i = 0;
                while (i < notes.size()) {
                    marker = (Marker)notes.get(i);
                    i3 = this.getSize(marker.name) + 5;
                    EMDDFile.this.raf.writeInt(1852798053);
                    this.writeLittleInt(i3);
                    this.writeLittleInt(i1);
                    EMDDFile.this.raf.write(this.getBytes(marker.name));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                    ++i;
                    ++i1;
                }
                i = 0;
                while (i < regions.size()) {
                    region = (Region)regions.get(i);
                    EMDDFile.this.raf.writeInt(1819572340);
                    i3 = this.getSize(region.name) + 21;
                    this.writeLittleInt(i3);
                    this.writeLittleInt(i1);
                    this.writeLittleInt((int)region.span.stop);
                    EMDDFile.this.raf.writeInt(1919381024);
                    EMDDFile.this.raf.writeLong(0L);
                    EMDDFile.this.raf.write(this.getBytes(region.name));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                    ++i;
                    ++i1;
                }
                pos2 = EMDDFile.this.raf.getFilePointer();
                i = (int)(pos2 - pos - 4L);
                if ((i & 1) == 1) {
                    EMDDFile.this.raf.write(0);
                    ++pos2;
                }
                EMDDFile.this.raf.seek(pos);
                this.writeLittleInt(i);
                EMDDFile.this.raf.seek(pos2);
            }
            if (metadata != null && !metadata.isEmpty() || comments != null && !comments.isEmpty()) {
                Annotation annotation;
                if (metadata == null) {
                    metadata = new ArrayList();
                }
                if (comments == null) {
                    comments = new ArrayList();
                }
                EMDDFile.this.raf.writeInt(1818850164);
                pos = EMDDFile.this.raf.getFilePointer();
                EMDDFile.this.raf.writeInt(0);
                EMDDFile.this.raf.writeInt(1095650895);
                i = 0;
                i1 = 1;
                while (i < metadata.size()) {
                    annotation = (Annotation)metadata.get(i);
                    i3 = this.getSize(annotation.content) + 1;
                    EMDDFile.this.raf.writeInt(1296389185);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(annotation.content));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                    ++i;
                    ++i1;
                }
                i = 0;
                i1 = 1;
                while (i < comments.size()) {
                    annotation = (Annotation)comments.get(i);
                    i3 = this.getSize(annotation.content) + 1;
                    EMDDFile.this.raf.writeInt(1129270612);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(annotation.content));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                    ++i;
                    ++i1;
                }
                pos2 = EMDDFile.this.raf.getFilePointer();
                i = (int)(pos2 - pos - 4L);
                if ((i & 1) == 1) {
                    EMDDFile.this.raf.write(0);
                    ++pos2;
                }
                EMDDFile.this.raf.seek(pos);
                this.writeLittleInt(i);
                EMDDFile.this.raf.seek(pos2);
            }
            if (SURF_info != null) {
                EMDDFile.this.raf.writeInt(1818850164);
                pos = EMDDFile.this.raf.getFilePointer();
                EMDDFile.this.raf.writeInt(0);
                EMDDFile.this.raf.writeInt(1229866575);
                if (SURF_info.archival_location != "") {
                    i3 = this.getSize(SURF_info.archival_location) + 1;
                    EMDDFile.this.raf.writeInt(1229017676);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.archival_location));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.file_creator != "") {
                    i3 = this.getSize(SURF_info.file_creator) + 1;
                    EMDDFile.this.raf.writeInt(1229017684);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.file_creator));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.commissioner != "") {
                    i3 = this.getSize(SURF_info.commissioner) + 1;
                    EMDDFile.this.raf.writeInt(1229147475);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.commissioner));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.comments != "") {
                    i3 = this.getSize(SURF_info.comments) + 1;
                    EMDDFile.this.raf.writeInt(1229147476);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.comments));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.copyright != "") {
                    i3 = this.getSize(SURF_info.copyright) + 1;
                    EMDDFile.this.raf.writeInt(1229147984);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.copyright));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.creation_date != "") {
                    i3 = this.getSize(SURF_info.creation_date) + 1;
                    EMDDFile.this.raf.writeInt(1229148740);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.creation_date));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.keywords != "") {
                    i3 = this.getSize(SURF_info.keywords) + 1;
                    EMDDFile.this.raf.writeInt(1229669721);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.keywords));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.name != "") {
                    i3 = this.getSize(SURF_info.name) + 1;
                    EMDDFile.this.raf.writeInt(1229865293);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.name));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.product != "") {
                    i3 = this.getSize(SURF_info.product) + 1;
                    EMDDFile.this.raf.writeInt(1230000708);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.product));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.subject != "") {
                    i3 = this.getSize(SURF_info.subject) + 1;
                    EMDDFile.this.raf.writeInt(1230193226);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.subject));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.software != "") {
                    i3 = this.getSize(SURF_info.software) + 1;
                    EMDDFile.this.raf.writeInt(1230194260);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.software));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.source != "") {
                    i3 = this.getSize(SURF_info.source) + 1;
                    EMDDFile.this.raf.writeInt(1230197315);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.source));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (SURF_info.source_form != "") {
                    i3 = this.getSize(SURF_info.source_form) + 1;
                    EMDDFile.this.raf.writeInt(1230197318);
                    this.writeLittleInt(i3);
                    EMDDFile.this.raf.write(this.getBytes(SURF_info.source_form));
                    if ((i3 & 1) == 0) {
                        EMDDFile.this.raf.writeByte(0);
                    } else {
                        EMDDFile.this.raf.writeShort(0);
                    }
                }
                if (((i = (int)((pos2 = EMDDFile.this.raf.getFilePointer()) - pos - 4L)) & 1) == 1) {
                    EMDDFile.this.raf.write(0);
                    ++pos2;
                }
                EMDDFile.this.raf.seek(pos);
                this.writeLittleInt(i);
                EMDDFile.this.raf.seek(pos2);
            }
            EMDDFile.this.raf.writeInt(1684108385);
            this.dataLengthOffset = EMDDFile.this.raf.getFilePointer();
            EMDDFile.this.raf.writeInt(0);
            this.sampleDataOffset = EMDDFile.this.raf.getFilePointer();
            this.updateHeader(descr);
        }

        @Override
        protected void updateHeader(EMDDFileDescr descr) throws IOException {
            long oldPos = EMDDFile.this.raf.getFilePointer();
            long len = EMDDFile.this.raf.length();
            if (len == this.lastUpdateLength) {
                return;
            }
            if (len >= 8L) {
                EMDDFile.this.raf.seek(4L);
                this.writeLittleInt((int)(len - 8L));
            }
            if (len >= this.dataLengthOffset + 4L) {
                EMDDFile.this.raf.seek(this.dataLengthOffset);
                this.writeLittleInt((int)(len - (this.dataLengthOffset + 4L)));
            }
            EMDDFile.this.raf.seek(oldPos);
            this.lastUpdateLength = len;
        }

        @Override
        protected long getSampleDataOffset() {
            return this.sampleDataOffset;
        }

        @Override
        protected ByteOrder getByteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        @Override
        protected boolean isUnsignedPCM() {
            return this.unsignedPCM;
        }

        @Override
        protected void readMissingDataChunks() throws IOException {
            HashMap mapCues = new HashMap();
            HashMap mapCueLengths = new HashMap();
            HashMap mapCueNames = new HashMap();
            HashMap mapCueTypes = new HashMap();
            long oldPos = EMDDFile.this.raf.getFilePointer();
            byte[] strBuf = null;
            ArrayList<MissingData> missingdata = new ArrayList<MissingData>();
            if (this.mdlMagicOff > 0L) {
                EMDDFile.this.raf.seek(this.mdlMagicOff);
                long chunkLen = this.mdlMagicLen;
                while (chunkLen >= 8L) {
                    int i = EMDDFile.this.raf.readInt();
                    int i1 = this.readLittleInt();
                    int i2 = i1 + 1 & 0xFFFFFFFE;
                    chunkLen -= 8L;
                    switch (i) {
                        case 1296318804: {
                            if (strBuf == null || strBuf.length < i1) {
                                strBuf = new byte[Math.max(64, i1)];
                            }
                            EMDDFile.this.raf.readFully(strBuf, 0, i1);
                            missingdata.add(new MissingData(new String(strBuf, 0, i1 - 1)));
                            chunkLen -= (long)i1;
                            i2 -= i1;
                            break;
                        }
                    }
                    if (i2 == 0) continue;
                    EMDDFile.this.raf.seek(EMDDFile.this.raf.getFilePointer() + (long)i2);
                    chunkLen -= (long)i2;
                }
            }
            if (!missingdata.isEmpty()) {
                EMDDFile.this.afd.setProperty("missingdata", missingdata);
            }
        }

        @Override
        protected void readMarkers() throws IOException {
            if (this.listMagicOff == 0L && this.annoMagicOff == 0L && this.cnfgMagicOff == 0L) {
                return;
            }
            HashMap<Integer, Integer> mapCues = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> mapCueLengths = new HashMap<Integer, Integer>();
            HashMap<Integer, String> mapCueNames = new HashMap<Integer, String>();
            HashMap<Integer, Integer> mapCueTypes = new HashMap<Integer, Integer>();
            long oldPos = EMDDFile.this.raf.getFilePointer();
            byte[] strBuf = null;
            try {
                int i3;
                int i2;
                int i1;
                int i;
                if (this.listMagicOff > 0L) {
                    EMDDFile.this.raf.seek(this.listMagicOff);
                    long chunkLen = this.listMagicLen;
                    while (chunkLen >= 8L) {
                        i = EMDDFile.this.raf.readInt();
                        i1 = this.readLittleInt();
                        i2 = i1 + 1 & 0xFFFFFFFE;
                        chunkLen -= 8L;
                        switch (i) {
                            case 1818321516: {
                                i3 = this.readLittleInt();
                                i2 -= 4;
                                chunkLen -= 4L;
                                if (strBuf == null || strBuf.length < (i1 -= 4)) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                mapCueNames.put(new Integer(i3), new String(strBuf, 0, i1 - 1));
                                mapCueTypes.put(new Integer(i3), new Integer(1818321516));
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1852798053: {
                                i3 = this.readLittleInt();
                                i2 -= 4;
                                chunkLen -= 4L;
                                if (strBuf == null || strBuf.length < (i1 -= 4)) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                mapCueNames.put(new Integer(i3), new String(strBuf, 0, i1 - 1));
                                mapCueTypes.put(new Integer(i3), new Integer(1852798053));
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1819572340: {
                                i3 = this.readLittleInt();
                                int i4 = this.readLittleInt();
                                int i5 = EMDDFile.this.raf.readInt();
                                EMDDFile.this.raf.readLong();
                                i2 -= 20;
                                chunkLen -= 20L;
                                Object o = new Integer(i3);
                                if ((i1 -= 20) > 0 && !mapCueNames.containsKey(o)) {
                                    if (strBuf == null || strBuf.length < i1) {
                                        strBuf = new byte[Math.max(64, i1)];
                                    }
                                    EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                    mapCueNames.put((Integer)o, new String(strBuf, 0, i1 - 1));
                                    mapCueTypes.put(new Integer(i3), new Integer(1819572340));
                                    chunkLen -= (long)i1;
                                    i2 -= i1;
                                }
                                if (i4 <= 0 && i5 != 1919381024) break;
                                mapCueLengths.put((Integer)o, new Integer(i4));
                                break;
                            }
                        }
                        if (i2 == 0) continue;
                        EMDDFile.this.raf.seek(EMDDFile.this.raf.getFilePointer() + (long)i2);
                        chunkLen -= (long)i2;
                    }
                }
                if (this.cueMagicOff > 0L) {
                    EMDDFile.this.raf.seek(this.cueMagicOff);
                    i = this.readLittleInt();
                    int j = 0;
                    while (j < i) {
                        i1 = this.readLittleInt();
                        EMDDFile.this.raf.readInt();
                        i2 = EMDDFile.this.raf.readInt();
                        EMDDFile.this.raf.readLong();
                        i3 = this.readLittleInt();
                        if (i2 == 1684108385) {
                            mapCues.put(new Integer(i1), new Integer(i3));
                        }
                        ++j;
                    }
                }
                if (!mapCues.isEmpty()) {
                    ArrayList<Marker> markers = new ArrayList<Marker>();
                    ArrayList<Region> regions = new ArrayList<Region>();
                    ArrayList<Marker> notes = new ArrayList<Marker>();
                    for (Object o : mapCues.keySet()) {
                        i = (Integer)mapCues.get(o);
                        String str = (String)mapCueNames.get(o);
                        int type = (Integer)mapCueTypes.get(o);
                        o = mapCueLengths.get(o);
                        switch (type) {
                            case 1818321516: {
                                if (str == null) {
                                    str = "THIS IS A LABEL CHUNK";
                                }
                                markers.add(new Marker((long)i, str));
                                break;
                            }
                            case 1852798053: {
                                if (str == null) {
                                    str = "THIS IS A NOTE CHUNK";
                                }
                                notes.add(new Marker((long)i, str));
                                break;
                            }
                            case 1819572340: {
                                if (str == null) {
                                    str = "THIS IS A LTXT CHUNK";
                                }
                                regions.add(new Region(new Span((long)i, (long)((Integer)o).intValue()), str));
                                break;
                            }
                        }
                    }
                    if (!markers.isEmpty()) {
                        EMDDFile.this.afd.setProperty("labels", markers);
                    }
                    if (!regions.isEmpty()) {
                        EMDDFile.this.afd.setProperty("regions", regions);
                    }
                    if (!notes.isEmpty()) {
                        EMDDFile.this.afd.setProperty("notes", notes);
                    }
                }
                ArrayList<Annotation> comments = new ArrayList<Annotation>();
                ArrayList<Annotation> metadata = new ArrayList<Annotation>();
                if (this.annoMagicOff > 0L) {
                    EMDDFile.this.raf.seek(this.annoMagicOff);
                    long chunkLen = this.annoMagicLen;
                    while (chunkLen >= 8L) {
                        i = EMDDFile.this.raf.readInt();
                        i1 = this.readLittleInt();
                        i2 = i1 + 1 & 0xFFFFFFFE;
                        chunkLen -= 8L;
                        switch (i) {
                            case 1129270612: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                comments.add(new Annotation(new String(strBuf, 0, i1 - 1)));
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1296389185: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                metadata.add(new Annotation(new String(strBuf, 0, i1 - 1)));
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                        }
                        if (i2 == 0) continue;
                        EMDDFile.this.raf.seek(EMDDFile.this.raf.getFilePointer() + (long)i2);
                        chunkLen -= (long)i2;
                    }
                }
                if (!comments.isEmpty()) {
                    EMDDFile.this.afd.setProperty("comment", comments);
                }
                if (!metadata.isEmpty()) {
                    EMDDFile.this.afd.setProperty("metadata", metadata);
                }
                Config config = new Config();
                if (this.cnfgMagicOff > 0L) {
                    float[] cc = new float[EMDDFile.this.afd.channels];
                    int cc_count = 0;
                    EMDDFile.this.raf.seek(this.cnfgMagicOff);
                    long chunkLen = this.cnfgMagicLen;
                    while (chunkLen >= 8L) {
                        i = EMDDFile.this.raf.readInt();
                        i1 = this.readLittleInt();
                        i2 = i1 + 1 & 0xFFFFFFFE;
                        chunkLen -= 8L;
                        switch (i) {
                            case 1414353748: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                config.surf_initial_timestamp = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1414355534: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                config.surf_timezone = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1397772884: {
                                config.surf_sampling_rate = EMDDFile.this.raf.readFloat();
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 0x43484343: {
                                cc[cc_count] = EMDDFile.this.raf.readFloat();
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                ++cc_count;
                                break;
                            }
                        }
                        if (i2 == 0) continue;
                        EMDDFile.this.raf.seek(EMDDFile.this.raf.getFilePointer() + (long)i2);
                        chunkLen -= (long)i2;
                    }
                    config.surf_channel_callibration = cc;
                }
                EMDDFile.this.afd.setProperty("config", config);
                if (this.infoMagicOff > 0L) {
                    EMDDFile.this.raf.seek(this.infoMagicOff);
                    Info SURF_info = new Info();
                    long chunkLen = this.infoMagicLen;
                    while (chunkLen >= 8L) {
                        i = EMDDFile.this.raf.readInt();
                        i1 = this.readLittleInt();
                        i2 = i1 + 1 & 0xFFFFFFFE;
                        chunkLen -= 8L;
                        switch (i) {
                            case 1229017676: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.archival_location = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1229017684: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.file_creator = new String(strBuf, 0, i1 - 1, "UTF-8");
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1229147475: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.commissioner = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1229147476: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.comments = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1229147984: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.copyright = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1229148740: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.creation_date = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1229669721: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.keywords = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1229865293: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.name = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1230000708: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.product = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1230193226: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.subject = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1230194260: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.software = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1230197315: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.source = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            case 1230197318: {
                                if (strBuf == null || strBuf.length < i1) {
                                    strBuf = new byte[Math.max(64, i1)];
                                }
                                EMDDFile.this.raf.readFully(strBuf, 0, i1);
                                SURF_info.source_form = new String(strBuf, 0, i1 - 1);
                                chunkLen -= (long)i1;
                                i2 -= i1;
                                break;
                            }
                            default: {
                                System.out.println("Not a valid MAGIC");
                            }
                        }
                        if (i2 == 0) continue;
                        EMDDFile.this.raf.seek(EMDDFile.this.raf.getFilePointer() + (long)i2);
                        chunkLen -= (long)i2;
                    }
                    EMDDFile.this.afd.setProperty("info", SURF_info);
                }
            }
            finally {
                EMDDFile.this.raf.seek(oldPos);
            }
        }

        public String FourCCtoString(int value) {
            String s = "";
            s = String.valueOf(s) + (char)(value >> 24 & 0xFF);
            s = String.valueOf(s) + (char)(value >> 16 & 0xFF);
            s = String.valueOf(s) + (char)(value >> 8 & 0xFF);
            s = String.valueOf(s) + (char)(value & 0xFF);
            return s;
        }
    }

    private class Wave64Header
    extends AbstractRIFFHeader {
        private static final int RIFF_MAGIC1a = 1919510118;
        private static final int RIFF_MAGIC1b = 781307665;
        private static final long RIFF_MAGIC1 = 8244233181932408593L;
        private static final long RIFF_MAGIC2 = -6496960491292655616L;
        private static final long WAVE_MAGIC1 = 8602286943506322193L;
        private static final long WAVE_MAGIC2 = -8299851812298630262L;
        private static final long FMT_MAGIC1 = 7380683049206076177L;
        private static final long FMT_MAGIC2 = -8299851812298630262L;
        private static final long FACT_MAGIC1 = 7377287018565128977L;
        private static final long FACT_MAGIC2 = -8299851812298630262L;
        private static final long DATA_MAGIC1 = 7233190440582566673L;
        private static final long DATA_MAGIC2 = -8299851812298630262L;
        private static final long MARKER_MAGIC1 = 6224809949549679121L;
        private static final long MARKER_MAGIC2 = -8735012126293304438L;
        private final Charset charset = Charset.forName("UTF-16LE");
        private long markersOffset = 0L;
        private static final long riffLengthOffset = 16L;

        protected Wave64Header() {
        }

        @Override
        protected void readHeader(EMDDFileDescr descr) throws IOException {
            int bpf = 0;
            long dataLen = 0L;
            EMDDFile.this.raf.readLong();
            EMDDFile.this.raf.readLong();
            long len = this.readLittleLong();
            EMDDFile.this.raf.readLong();
            EMDDFile.this.raf.readLong();
            len -= 40L;
            long chunkLen = 0L;
            int essentials = 2;
            block5: while (len >= 24L && essentials > 0) {
                if (chunkLen != 0L) {
                    EMDDFile.this.raf.seek(EMDDFile.this.raf.getFilePointer() + chunkLen);
                }
                long magic1 = EMDDFile.this.raf.readLong();
                long magic2 = EMDDFile.this.raf.readLong();
                chunkLen = this.readLittleLong() + 7L & 0xFFFFFFFFFFFFFFF8L;
                len -= chunkLen;
                chunkLen -= 24L;
                if (magic1 == 7380683049206076177L && magic2 == -8299851812298630262L) {
                    --essentials;
                    int i = this.readLittleUShort();
                    descr.channels = this.readLittleUShort();
                    int i1 = this.readLittleInt();
                    descr.rate = i1;
                    int i2 = this.readLittleInt();
                    bpf = this.readLittleUShort();
                    descr.bitsPerSample = this.readLittleUShort();
                    if ((descr.bitsPerSample & 7) != 0 || (descr.bitsPerSample >> 3) * descr.channels != bpf || (descr.bitsPerSample >> 3) * descr.channels * i1 != i2) {
                        throw new IOException(EMDDFile.getResourceString("errAudioFileEncoding"));
                    }
                    this.unsignedPCM = bpf == 1;
                    chunkLen -= 16L;
                    switch (i) {
                        case 1: {
                            descr.sampleFormat = 0;
                            continue block5;
                        }
                        case 3: {
                            descr.sampleFormat = 1;
                            continue block5;
                        }
                        case 65534: {
                            if (chunkLen < 24L) {
                                throw new IOException(EMDDFile.getResourceString("errAudioFileIncomplete"));
                            }
                            i1 = this.readLittleUShort();
                            if (i1 < 22) {
                                throw new IOException(EMDDFile.getResourceString("errAudioFileIncomplete"));
                            }
                            i2 = this.readLittleUShort();
                            EMDDFile.this.raf.readInt();
                            int i3 = this.readLittleUShort();
                            if (i2 != descr.bitsPerSample || i3 != 1 && i3 != 3) {
                                throw new IOException(EMDDFile.getResourceString("errAudioFileEncoding"));
                            }
                            descr.sampleFormat = i3 == 1 ? 0 : 1;
                            chunkLen -= 10L;
                            continue block5;
                        }
                        default: {
                            throw new IOException(EMDDFile.getResourceString("errAudioFileEncoding"));
                        }
                    }
                }
                if (magic1 == 7233190440582566673L && magic2 == -8299851812298630262L) {
                    --essentials;
                    this.sampleDataOffset = EMDDFile.this.raf.getFilePointer();
                    dataLen = chunkLen;
                    continue;
                }
                if (magic1 != 6224809949549679121L || magic2 != -8735012126293304438L) continue;
                this.markersOffset = EMDDFile.this.raf.getFilePointer();
            }
            if (essentials > 0) {
                throw new IOException(EMDDFile.getResourceString("errAudioFileIncomplete"));
            }
            descr.length = dataLen / (long)bpf;
        }

        @Override
        protected void writeHeader(EMDDFileDescr descr) throws IOException {
            this.isFloat = descr.sampleFormat == 1;
            EMDDFile.this.raf.writeLong(8244233181932408593L);
            EMDDFile.this.raf.writeLong(-6496960491292655616L);
            EMDDFile.this.raf.writeLong(40L);
            EMDDFile.this.raf.writeLong(8602286943506322193L);
            EMDDFile.this.raf.writeLong(-8299851812298630262L);
            EMDDFile.this.raf.writeLong(7380683049206076177L);
            EMDDFile.this.raf.writeLong(-8299851812298630262L);
            this.writeLittleLong(this.isFloat ? 42 : 40);
            this.writeLittleShort(this.isFloat ? 3 : 1);
            this.writeLittleShort(descr.channels);
            int i1 = (int)(descr.rate + 0.5);
            this.writeLittleInt(i1);
            int i2 = (descr.bitsPerSample >> 3) * descr.channels;
            this.writeLittleInt(i1 * i2);
            this.writeLittleShort(i2);
            this.writeLittleShort(descr.bitsPerSample);
            if (this.isFloat) {
                EMDDFile.this.raf.writeLong(0L);
            }
            if (this.isFloat) {
                EMDDFile.this.raf.writeLong(7377287018565128977L);
                EMDDFile.this.raf.writeLong(-8299851812298630262L);
                this.writeLittleLong(32L);
                this.factSmpNumOffset = EMDDFile.this.raf.getFilePointer();
                EMDDFile.this.raf.writeLong(0L);
            }
            List labels = (List)descr.getProperty("labels");
            List regions = (List)descr.getProperty("regions");
            List notes = (List)descr.getProperty("notes");
            List comments = (List)descr.getProperty("comment");
            List metadata = (List)descr.getProperty("metadata");
            List missingdata = (List)descr.getProperty("missingdata");
            if (missingdata != null && !missingdata.isEmpty() || labels != null && !labels.isEmpty() || regions != null && !regions.isEmpty() || notes != null && !notes.isEmpty() || comments != null && !comments.isEmpty() || metadata != null && !metadata.isEmpty()) {
                long n1;
                CharsetEncoder enc = this.charset.newEncoder();
                Buffer cbuf = null;
                ByteBuffer bbuf = null;
                List[] cues = new List[]{regions == null ? Collections.EMPTY_LIST : regions, labels == null ? Collections.EMPTY_LIST : labels, notes == null ? Collections.EMPTY_LIST : notes, comments == null ? Collections.EMPTY_LIST : comments, metadata == null ? Collections.EMPTY_LIST : metadata, missingdata == null ? Collections.EMPTY_LIST : missingdata};
                EMDDFile.this.raf.writeLong(6224809949549679121L);
                EMDDFile.this.raf.writeLong(-8735012126293304438L);
                long pos = EMDDFile.this.raf.getFilePointer();
                EMDDFile.this.raf.writeLong(0L);
                i2 = cues[0].size() + cues[1].size() + cues[2].size() + cues[3].size() + cues[4].size() + cues[5].size();
                this.writeLittleInt(i2);
                int i = 0;
                int id = 1;
                while (i < 6) {
                    int j = 0;
                    while (j < cues[i].size()) {
                        String str;
                        long n2;
                        switch (i) {
                            case 0: {
                                Region region = (Region)cues[i].get(j);
                                n1 = region.span.start;
                                n2 = region.span.getLength();
                                str = region.name;
                                break;
                            }
                            case 1: {
                                Marker marker = (Marker)cues[i].get(j);
                                n1 = marker.pos;
                                n2 = 0L;
                                str = marker.name;
                                break;
                            }
                            case 2: {
                                Marker marker = (Marker)cues[i].get(j);
                                n1 = marker.pos;
                                n2 = 1L;
                                str = marker.name;
                                break;
                            }
                            case 3: {
                                Annotation annotation = (Annotation)cues[i].get(j);
                                n1 = -1L;
                                n2 = 2L;
                                str = annotation.content;
                                break;
                            }
                            case 5: {
                                MissingData md = (MissingData)cues[i].get(j);
                                n1 = -1L;
                                n2 = 5L;
                                str = md.toJSON();
                                break;
                            }
                            default: {
                                Annotation annotation = (Annotation)cues[i].get(j);
                                n1 = -1L;
                                n2 = 3L;
                                str = annotation.content;
                            }
                        }
                        this.writeLittleInt(id);
                        EMDDFile.this.raf.writeInt(0);
                        this.writeLittleLong(n1);
                        this.writeLittleLong(n2);
                        if (cbuf == null || cbuf.capacity() < str.length()) {
                            cbuf = CharBuffer.allocate(str.length() + 8);
                            bbuf = ByteBuffer.allocate(cbuf.capacity() + 1 << 1);
                        }
                        ((CharBuffer)cbuf).clear();
                        ((CharBuffer)cbuf).put(str);
                        ((CharBuffer)cbuf).flip();
                        bbuf.clear();
                        enc.reset();
                        enc.encode((CharBuffer)cbuf, bbuf, true);
                        enc.flush(bbuf);
                        bbuf.putShort((short)0);
                        bbuf.flip();
                        this.writeLittleInt(bbuf.remaining());
                        EMDDFile.this.raf.writeInt(0);
                        EMDDFile.this.fch.write(bbuf);
                        ++j;
                        ++id;
                    }
                    ++i;
                }
                long pos2 = EMDDFile.this.raf.getFilePointer();
                n1 = pos2 - pos;
                int pad = (int)((n1 + 7L & 0xFFFFFFFFFFFFFFF8L) - n1);
                int i3 = 0;
                while (i3 < pad) {
                    EMDDFile.this.raf.write(0);
                    ++i3;
                }
                EMDDFile.this.raf.seek(pos);
                this.writeLittleLong(n1 + 16L);
                EMDDFile.this.raf.seek(pos2 + (long)pad);
            }
            EMDDFile.this.raf.writeLong(7233190440582566673L);
            EMDDFile.this.raf.writeLong(-8299851812298630262L);
            this.dataLengthOffset = EMDDFile.this.raf.getFilePointer();
            EMDDFile.this.raf.writeLong(24L);
            this.sampleDataOffset = EMDDFile.this.raf.getFilePointer();
            this.updateHeader(descr);
        }

        @Override
        protected void updateHeader(EMDDFileDescr descr) throws IOException {
            long oldPos = EMDDFile.this.raf.getFilePointer();
            long len = EMDDFile.this.raf.length();
            if (len == this.lastUpdateLength) {
                return;
            }
            long lenM8 = len - 8L;
            if (lenM8 >= 16L) {
                EMDDFile.this.raf.seek(16L);
                this.writeLittleLong(len);
            }
            if (this.isFloat && lenM8 >= this.factSmpNumOffset) {
                EMDDFile.this.raf.seek(this.factSmpNumOffset);
                this.writeLittleLong(descr.length * (long)descr.channels);
            }
            if (lenM8 >= this.dataLengthOffset) {
                EMDDFile.this.raf.seek(this.dataLengthOffset);
                this.writeLittleLong(len - (this.dataLengthOffset - 16L));
            }
            EMDDFile.this.raf.seek(oldPos);
            this.lastUpdateLength = len;
        }

        @Override
        protected long getSampleDataOffset() {
            return this.sampleDataOffset;
        }

        @Override
        protected ByteOrder getByteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        @Override
        protected boolean isUnsignedPCM() {
            return this.unsignedPCM;
        }

        @Override
        protected void readMarkers() throws IOException {
            if (this.markersOffset == 0L) {
                return;
            }
            ArrayList<Marker> labels = new ArrayList<Marker>();
            ArrayList<Marker> notes = new ArrayList<Marker>();
            ArrayList<Region> regions = new ArrayList<Region>();
            ArrayList<Annotation> comments = new ArrayList<Annotation>();
            ArrayList<Annotation> metadata = new ArrayList<Annotation>();
            ArrayList<MissingData> missingdata = new ArrayList<MissingData>();
            CharsetDecoder dec = this.charset.newDecoder();
            CharBuffer cbuf = null;
            Buffer bbuf = null;
            long oldPos = EMDDFile.this.raf.getFilePointer();
            try {
                EMDDFile.this.raf.seek(this.markersOffset);
                int numCues = this.readLittleInt();
                int cue = 0;
                while (cue < numCues) {
                    EMDDFile.this.raf.readInt();
                    EMDDFile.this.raf.readInt();
                    long n1 = this.readLittleLong();
                    long n2 = this.readLittleLong();
                    int numBytes = this.readLittleInt();
                    EMDDFile.this.raf.readInt();
                    if (bbuf == null || bbuf.capacity() < numBytes) {
                        bbuf = ByteBuffer.allocate(numBytes + 16);
                        cbuf = CharBuffer.allocate(bbuf.capacity() >> 1);
                    }
                    ((ByteBuffer)bbuf).rewind().limit(numBytes);
                    EMDDFile.this.fch.read((ByteBuffer)bbuf);
                    if (numBytes >= 2 && ((ByteBuffer)bbuf).get(numBytes - 2) == 0 && ((ByteBuffer)bbuf).get(numBytes - 1) == 0) {
                        ((ByteBuffer)bbuf).rewind().limit(numBytes - 2);
                    } else {
                        ((ByteBuffer)bbuf).flip();
                    }
                    cbuf.clear();
                    dec.reset();
                    CoderResult result = dec.decode((ByteBuffer)bbuf, cbuf, true);
                    if (result.isError()) {
                        throw new IOException("Error Reading Cue Name" + (result.isMalformed() ? ": Malformed Input" : (result.isOverflow() ? ": Overflow" : (result.isUnderflow() ? ": Underflow" : (result.isUnmappable() ? ": Unmappable" : "")))));
                    }
                    dec.flush(cbuf);
                    cbuf.flip();
                    String str = cbuf.toString();
                    if (n2 == 0L) {
                        labels.add(new Marker(n1, str));
                    } else if (n2 == 1L) {
                        notes.add(new Marker(n1, str));
                    } else if (n2 == 2L) {
                        comments.add(new Annotation(str));
                    } else if (n2 == 3L) {
                        metadata.add(new Annotation(str));
                    } else if (n2 == 5L) {
                        missingdata.add(new MissingData(str));
                    } else {
                        regions.add(new Region(new Span(n1, n1 + n2), str));
                    }
                    ++cue;
                }
                EMDDFile.this.afd.setProperty("labels", labels);
                EMDDFile.this.afd.setProperty("notes", notes);
                EMDDFile.this.afd.setProperty("regions", regions);
                EMDDFile.this.afd.setProperty("comment", comments);
                EMDDFile.this.afd.setProperty("metadata", metadata);
                EMDDFile.this.afd.setProperty("missingdata", missingdata);
            }
            finally {
                EMDDFile.this.raf.seek(oldPos);
            }
        }
    }
}

