/*
 * Decompiled with CFR 0.152.
 */
package emddf.demo;

import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import emddf.api.create.Merger;
import emddf.api.read.Reader;
import emddf.api.update.Update;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SustDataED {
    public static void main(String[] args) throws IOException, ProcessingException, ParseException {
        String path = "J:\\datasets\\SustDataPM_W64\\";
        File folder = new File(path);
        File[] files = folder.listFiles();
        String fileName = files[0].getName().split(".w64")[0];
        Reader r = new Reader(files[0]);
        Update u = new Update(5, path, fileName);
        HashMap<Long, Long> forbiddenRegions = new HashMap<Long, Long>();
        long numSamples = 0L;
        int i = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File fileEntry = fileArray[n2];
            try {
                Reader read = new Reader(fileEntry);
                long timestamp = Long.parseLong(files[i + 1].getName().split(".w64")[0]);
                System.out.println("Timestamp of file: " + timestamp);
                String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timestamp));
                long startTimestamp = 0L;
                forbiddenRegions.put(startTimestamp, timestamp);
                System.out.println("Regiao inadmissivel: [" + startTimestamp + "," + timestamp + "]");
                u.addMissingData(date, (numSamples += read.getNumFrames()) + 1L);
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println(e.getMessage());
            }
            ++i;
            ++n2;
        }
        Timestamp initialTimeStamp = null;
        long initialTimeStampInMiliSecs = 0L;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
        try {
            String initial_timestamp = "2011-10-20 11:58:32.634";
            Date parsedDate = dateFormat.parse(initial_timestamp);
            initialTimeStamp = new Timestamp(parsedDate.getTime());
            initialTimeStampInMiliSecs = initialTimeStamp.getTime();
        }
        catch (Exception initial_timestamp) {
            // empty catch block
        }
        long TimeStampInMiliSecs = 0L;
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:J:\\datasets\\SustDataED.sqlite3");
            c.setAutoCommit(false);
            System.out.println("Opened database successfully");
            int ki = 0;
            stmt = c.createStatement();
            ResultSet rs = stmt.executeQuery("Select * from plugwise_label, device where device.id = plugwise_label.device_id;");
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            while (rs.next()) {
                ++ki;
                int id = rs.getInt("id");
                int app_id = rs.getInt("device_id");
                String app_label = rs.getString("name");
                String timestamp = rs.getString("timestamp");
                long unixTimestamp = dateFormat2.parse(timestamp).getTime();
                long position = Math.round(r.getRate() / 1000.0 * (double)(unixTimestamp - dateFormat.parse(r.getInitialTimestamp(1L).getInitialTimestamp()).getTime() + r.getInitialTimestamp(1L).getInitialSample()));
                System.out.println("Position is " + position);
                float delta_p = rs.getFloat("delta");
                int type = rs.getInt("event_type");
                long epoch = dateFormat2.parse(timestamp).getTime();
                boolean isToInclude = true;
                for (Map.Entry entry : forbiddenRegions.entrySet()) {
                    if (epoch <= (Long)entry.getKey() || epoch > (Long)entry.getValue()) continue;
                    isToInclude = false;
                    break;
                }
                if (!isToInclude) {
                    System.out.println("Label " + epoch + " ignorada.");
                    continue;
                }
                try {
                    Date parsedDate = dateFormat.parse(timestamp);
                    Timestamp TimeStamp = new Timestamp(parsedDate.getTime());
                    TimeStampInMiliSecs = TimeStamp.getTime();
                }
                catch (Exception parsedDate) {
                    // empty catch block
                }
                String labelName = "{\"SURF_ID\":" + id + ",\"App_ID\":" + app_id + ",\"App_Label\":\"" + app_label + "\",\"Position\":" + position + ",\"Timestamp\":\"" + timestamp + "\",\"Delta_P\": " + delta_p + ",\"Type\":" + type + "}";
                u.addLabel(position, labelName);
            }
            rs.close();
            stmt.close();
            c.close();
        }
        catch (Exception e) {
            System.err.println(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
            System.exit(0);
        }
        System.out.println("Operation done successfully");
        u.saveChanges();
        Merger m = new Merger(files, "J:\\datasets\\SustDataPM_W64\\SUSTDATA_PM");
        System.out.println("Merging...");
        m.run();
    }
}

