/*
 * Decompiled with CFR 0.152.
 */
package emddf.demo;

import emddf.api.update.Update;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class BLUED {
    static Update uA;
    static String path;
    static String labels_path;
    static SimpleDateFormat dateFormat;

    static {
        path = "assets/";
        labels_path = "BLUED_labels.db";
        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static void addLabels() {
        Connection c = null;
        Statement stmt = null;
        try {
            Class.forName("org.sqlite.JDBC");
            c = DriverManager.getConnection("jdbc:sqlite:" + path + labels_path);
            c.setAutoCommit(false);
            stmt = c.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM blued_labels_ALL WHERE Phase = 'B';");
            while (rs.next()) {
                int id = rs.getInt("ID");
                int app_id = rs.getInt("App_ID");
                String app_label = rs.getString("App_Label");
                int position = rs.getInt("Position");
                String timestamp = rs.getString("Timestamp");
                float delta_p = rs.getFloat("Delta_P");
                float delta_q = rs.getFloat("Delta_Q");
                int type = delta_p > 0.0f ? 1 : -1;
                String labelName = "{\"ID\":" + id + ",\"App_ID\":" + app_id + ",\"App_Label\":\"" + app_label + "\",\"Position\":" + position + ",\"Timestamp\":\"" + timestamp + "\",\"Delta_P\": " + delta_p + ",\"Delta_Q\":" + delta_q + ",\"Type\":" + type + "}";
                System.out.println(labelName);
                uA.addLabel(position, labelName);
            }
            rs.close();
            stmt.close();
            c.close();
        }
        catch (Exception e) {
            System.err.println(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
            System.exit(0);
        }
        System.out.println("Operation done successfully");
    }

    public static void setInfo() {
        String archival_location = "http://nilm.cmubi.org";
        String comments = "This is the EMD-DF64 version of the BLUED dataset phase B at 60 Hz";
        String commissioner = "Mario Berg\u00e9s (marioberges@cmu.edu)";
        String copyright = "Inherited from the original source";
        String creation_date = dateFormat.format(Calendar.getInstance().getTime());
        String file_creator = "Lucas Pereira (lucas.pereira@iti.larsys.pt)";
        String keywords = "NILM, dataset, event-based";
        String name = "EMD-DF64-BLUED: Phase B";
        String product = "Event-based NILM performance evaluation";
        String software = "EMD-DF64";
        String subject = "Phase A: Real and Reactive power at 60 Hz";
        String source = "BLUED: Building-Level fUlly labeled Electricity Disaggregation Dataset";
        String source_form = "Matlab (.mat)";
        uA.setInfo(archival_location, file_creator, commissioner, comments, copyright, creation_date, keywords, name, product, subject, software, source, source_form);
    }

    public static void main(String[] args) {
        String file_name = "BLUED_B_raw";
        uA = new Update(0, path, file_name);
        float[] cc = new float[]{19200.0f, 19200.0f};
        uA.setConfig("2011-10-20 11:58:32.634", "EST", 60.0f, cc);
        BLUED.addLabels();
        uA.addNote(84532L, "This is a note on the first Refrigerator Event.");
        BLUED.setInfo();
        uA.addComment("This file was created to demonstrate the conversion of BLUED to EMD-DF64.");
        uA.addComment("For the original BLUED please refer to http:nilm.cmubi.org.");
        uA.saveChanges();
        System.out.println("Done");
    }
}

