/*
 * Decompiled with CFR 0.152.
 */
package emddf.api.update;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import de.sciss.io.Marker;
import de.sciss.io.Region;
import de.sciss.io.Span;
import emddf.api.read.Reader;
import emddf.api.update.Utils;
import emddf.file.Annotation;
import emddf.file.Config;
import emddf.file.EMDDFile;
import emddf.file.EMDDFileDescr;
import emddf.file.Info;
import emddf.file.MissingData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Update {
    String path;
    String fileName;
    List<Marker> labels;
    List<Marker> notes;
    List<Region> regions;
    List<Annotation> comments;
    List<Annotation> metadatas;
    List<MissingData> missingdata;
    Info info;
    Config config;
    int fileType;
    private File file_OUT;
    private EMDDFile SURF_file_IN;
    private EMDDFileDescr SURF_descr_IN;
    private EMDDFile SURF_file_OUT;
    private EMDDFileDescr SURF_descr_OUT;

    public Update(int fileType, String path, String fileName) {
        this.fileType = fileType;
        this.path = path;
        this.fileName = fileName;
        this.labels = new ArrayList<Marker>();
        this.notes = new ArrayList<Marker>();
        this.regions = new ArrayList<Region>();
        this.comments = new ArrayList<Annotation>();
        this.metadatas = new ArrayList<Annotation>();
        this.info = new Info();
        this.missingdata = new ArrayList<MissingData>();
    }

    public boolean noteAlreadyExists(long pos) {
        for (Marker n : this.notes) {
            if (n.pos != pos) continue;
            return true;
        }
        return false;
    }

    public boolean labelAlreadyExists(long pos, String name) {
        boolean contains = false;
        JSONObject json = new JSONObject();
        try {
            json = (JSONObject)this.parseJson(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int app_id = Integer.parseInt(json.get((Object)"App_ID").toString());
        int label_app_id = 0;
        for (Marker l : this.labels) {
            try {
                JSONObject jlabel = (JSONObject)this.parseJson(l.name);
                label_app_id = Integer.parseInt(jlabel.get((Object)"App_ID").toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (l.pos != pos || label_app_id != app_id) continue;
            contains = true;
        }
        return contains;
    }

    public String createJSONFile(String name) {
        String jsonFileName = "temp.json";
        try {
            File file = new File(jsonFileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(name);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "/temp.json";
    }

    public boolean correctJSONFormat(String aName, String aSchema) throws IOException, ProcessingException {
        String jsonFileName = "";
        jsonFileName = this.createJSONFile(aName);
        JsonNode fstabSchema = Utils.loadResource(aSchema);
        JsonNode jsonFile = Utils.loadResource(jsonFileName);
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        JsonSchema schema = factory.getJsonSchema(fstabSchema);
        ProcessingReport report = schema.validate(jsonFile);
        return report.isSuccess();
    }

    public String setDateInCorrectFormat(String date) {
        if (date.charAt(10) != 'T') {
            date = String.valueOf(date.substring(0, 10)) + "T" + date.substring(11);
        }
        if (date.length() < 24) {
            date = date.concat("Z");
        }
        return date;
    }

    public void addLabel(long pos, String name) throws IOException, ProcessingException {
        Reader r = new Reader(this.getFile());
        int labelsSize = 0;
        try {
            labelsSize = r.getLabels().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < labelsSize) {
            Marker m = r.getLabels().get(i);
            this.labels.add(new Marker(m.pos, m.name));
            ++i;
        }
        JSONObject json = new JSONObject();
        try {
            json = (JSONObject)this.parseJson(name);
        }
        catch (Exception e) {
            System.out.println("Error parsing json!");
            e.printStackTrace();
        }
        String date = json.get((Object)"Timestamp").toString();
        int posDate = name.indexOf(date);
        String[] sp = date.split("-");
        int month = Integer.parseInt(sp[1]);
        sp = sp[2].split(" ");
        int day = Integer.parseInt(sp[0]);
        if (String.valueOf(day).length() < 2) {
            day = Integer.parseInt("0" + day);
        }
        if (String.valueOf(month).length() < 2) {
            month = Integer.parseInt("0" + month);
        }
        date = String.valueOf(date.substring(0, 5)) + month + date.substring(4, 5) + day + date.substring(10);
        date = this.setDateInCorrectFormat(date);
        if (this.correctJSONFormat(name = name.substring(0, posDate).concat(date).concat(name.substring(posDate + date.length() - 1)), "/fstab.json")) {
            if (!this.labelAlreadyExists(pos, name)) {
                this.labels.add(new Marker(pos, name));
            } else {
                System.out.println("A label with that position and applicance id, already exists.");
            }
        } else {
            System.out.println("JSON Format is not correct.");
        }
    }

    public void addNote(long pos, String name) {
        Reader r = new Reader(this.getFile());
        int notesSize = 0;
        try {
            notesSize = r.getNotes().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < notesSize) {
            Marker m = r.getNotes().get(i);
            this.notes.add(new Marker(m.pos, m.name));
            ++i;
        }
        if (this.noteAlreadyExists(pos)) {
            long notePos = this.notes.get((int)0).pos;
            String noteName = this.notes.get((int)0).name;
            this.notes.remove(0);
            this.notes.add(new Marker(notePos, String.valueOf(noteName) + "\n" + name));
        } else {
            this.notes.add(new Marker(pos, name));
        }
    }

    public void updateNote(long pos, String name) {
        boolean removedNote = false;
        int index = 0;
        for (Marker n : this.notes) {
            if (n.pos == pos) {
                this.notes.remove(index);
                return;
            }
            ++index;
        }
        if (removedNote) {
            this.notes.add(new Marker(pos, name));
        } else {
            System.out.println("There's no notes in that position.");
        }
    }

    public void addRegion(long start, long end, String name) {
        this.addRegion(new Span(start, end), name);
    }

    private void addRegion(Span span, String name) {
        Reader r = new Reader(this.getFile());
        int regionsSize = 0;
        boolean alreadyExists = false;
        try {
            regionsSize = r.getRegions().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < regionsSize) {
            Region g = r.getRegions().get(i);
            if (g.span.start == span.start && g.span.stop == span.stop) {
                alreadyExists = true;
            }
            this.regions.add(new Region(g.span, g.name));
            ++i;
        }
        if (alreadyExists) {
            System.out.println("Already exists one region with that start and end positions.");
        } else {
            this.regions.add(new Region(span, name));
        }
    }

    public void addComment(String content) {
        Reader r = new Reader(this.getFile());
        int commentsSize = 0;
        try {
            commentsSize = r.getComments().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < commentsSize) {
            Annotation a = r.getComments().get(i);
            this.comments.add(new Annotation(a.content));
            ++i;
        }
        this.comments.add(new Annotation(content));
    }

    public void addMetadata(String content) {
        Reader r = new Reader(this.getFile());
        int metadatasSize = 0;
        try {
            metadatasSize = r.getMetadata().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < metadatasSize) {
            Annotation a = r.getMetadata().get(i);
            this.metadatas.add(new Annotation(a.content));
            ++i;
        }
        this.metadatas.add(new Annotation(content));
    }

    public void addMissingData(String aInitialTimestamp, long aInitialSample) {
        if (aInitialTimestamp != "" && aInitialSample != 0L) {
            this.missingdata.add(new MissingData(aInitialTimestamp, aInitialSample));
        }
    }

    public void addMissingData(String aContent) throws IOException, ProcessingException {
        if (this.correctJSONFormat(aContent, "/schemaMD.json")) {
            this.fillMissingDataList();
            this.missingdata.add(new MissingData(aContent));
        }
    }

    public void fillMissingDataList() {
        Reader r = new Reader(this.getFile());
        int missingDataSize = 0;
        try {
            missingDataSize = r.getMissingData().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < missingDataSize) {
            MissingData m = r.getMissingData().get(i);
            this.missingdata.add(new MissingData(m.getInitialTimestamp(), m.getInitialSample()));
            ++i;
        }
    }

    public void setConfig(String surf_initial_timestamp, String surf_timezone, float surf_sampling_rate, float[] surf_channel_callibration) {
        Reader r = new Reader(this.getFile());
        if (r.getConfig() != null) {
            this.config = r.getConfig();
            System.out.println("This is already a EMDDF File");
        } else {
            System.out.println("This is NOT YET a EMDDF File");
            this.config = new Config();
        }
        if (surf_initial_timestamp != "") {
            this.config.surf_initial_timestamp = surf_initial_timestamp;
        }
        if (surf_timezone != "") {
            this.config.surf_timezone = surf_timezone;
        }
        if (surf_sampling_rate != 0.0f) {
            this.config.surf_sampling_rate = surf_sampling_rate;
        }
        if (surf_channel_callibration != null) {
            this.config.surf_channel_callibration = surf_channel_callibration;
        }
    }

    public void setInfo(String archival_location, String file_creator, String commissioner, String comments, String copyright, String creation_date, String keywords, String name, String product, String subject, String software, String source, String source_form) {
        Reader r = new Reader(this.getFile());
        if (r.getInfo() != null) {
            this.info.archival_location = r.getInfo().archival_location;
            this.info.file_creator = r.getInfo().file_creator;
            this.info.commissioner = r.getInfo().commissioner;
            this.info.comments = r.getInfo().comments;
            this.info.copyright = r.getInfo().copyright;
            this.info.creation_date = r.getInfo().creation_date;
            this.info.keywords = r.getInfo().keywords;
            this.info.name = r.getInfo().name;
            this.info.product = r.getInfo().product;
            this.info.subject = r.getInfo().subject;
            this.info.software = r.getInfo().software;
            this.info.source = r.getInfo().source;
            this.info.source_form = r.getInfo().source_form;
        }
        if (archival_location != "") {
            this.info.archival_location = archival_location;
        }
        if (file_creator != "") {
            this.info.file_creator = file_creator;
        }
        if (commissioner != "") {
            this.info.commissioner = commissioner;
        }
        if (comments != "") {
            this.info.comments = comments;
        }
        if (copyright != "") {
            this.info.copyright = copyright;
        }
        if (creation_date != "") {
            this.info.creation_date = creation_date;
        }
        if (keywords != "") {
            this.info.keywords = keywords;
        }
        if (name != "") {
            this.info.name = name;
        }
        if (product != "") {
            this.info.product = product;
        }
        if (subject != "") {
            this.info.subject = subject;
        }
        if (software != "") {
            this.info.software = software;
        }
        if (source != "") {
            this.info.source = source;
        }
        if (source_form != "") {
            this.info.source_form = source_form;
        }
    }

    public String getExtension() {
        String extension = this.fileType == 5 ? "w64" : "wav";
        return extension;
    }

    public File getFile() {
        File f = this.fileType == 5 ? new File(String.valueOf(this.path) + this.fileName + ".w64") : new File(String.valueOf(this.path) + this.fileName + ".wav");
        return f;
    }

    public void saveChanges() {
        try {
            this.file_OUT = new File(String.valueOf(this.path) + this.fileName + "-update" + "." + this.getExtension());
            this.SURF_file_IN = EMDDFile.openAsRead(this.getFile());
            this.SURF_file_IN.readMarkers();
            this.SURF_descr_IN = this.SURF_file_IN.getDescr();
            this.SURF_descr_OUT = new EMDDFileDescr();
            this.SURF_descr_OUT.rate = this.SURF_descr_IN.rate;
            this.SURF_descr_OUT.bitsPerSample = this.SURF_descr_IN.bitsPerSample;
            this.SURF_descr_OUT.channels = this.SURF_descr_IN.channels;
            this.SURF_descr_OUT.type = this.SURF_descr_IN.type;
            this.SURF_descr_OUT.file = this.file_OUT;
            this.SURF_descr_OUT.setProperty("labels", this.labels);
            this.SURF_descr_OUT.setProperty("notes", this.notes);
            this.SURF_descr_OUT.setProperty("comment", this.comments);
            this.SURF_descr_OUT.setProperty("metadata", this.metadatas);
            this.SURF_descr_OUT.setProperty("regions", this.regions);
            this.SURF_descr_OUT.setProperty("info", this.info);
            this.SURF_descr_OUT.setProperty("config", this.config);
            System.out.println("teste");
            int i = 0;
            while (i < this.missingdata.size()) {
                System.out.println(this.missingdata.get(i));
                ++i;
            }
            this.SURF_descr_OUT.setProperty("missingdata", this.missingdata);
            this.SURF_file_OUT = EMDDFile.openAsWrite(this.SURF_descr_OUT);
            this.SURF_file_IN.copyFrames(this.SURF_file_OUT, this.SURF_descr_IN.length);
            this.SURF_file_OUT.cleanUp();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Object parseJson(String json) throws Exception {
        JSONParser jsonParser = new JSONParser();
        return jsonParser.parse(json);
    }
}

