/*
 * Decompiled with CFR 0.152.
 */
package emddf.api.read;

import de.sciss.io.Marker;
import de.sciss.io.Region;
import emddf.file.Annotation;
import emddf.file.Config;
import emddf.file.EMDDFile;
import emddf.file.EMDDFileDescr;
import emddf.file.Info;
import emddf.file.MissingData;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;

public class Reader {
    private File file;
    private int bufferSize = 600000;
    private int samplesRemaining = 0;
    private List<ArrayBlockingQueue<float[][]>> allBuffers;
    private EMDDFile SURF_file_IN;
    private EMDDFileDescr SURF_descr_IN;

    public Reader(File file) {
        this.file = file;
        try {
            this.allBuffers = new ArrayList<ArrayBlockingQueue<float[][]>>();
            this.SURF_file_IN = EMDDFile.openAsRead(file);
            int n = this.SURF_file_IN.getDescr().type;
            this.SURF_file_IN.getDescr();
            if (n != 4) {
                this.SURF_file_IN.readMarkers();
            }
            this.SURF_descr_IN = this.SURF_file_IN.getDescr();
            this.bufferSize = (int)Math.min(this.SURF_descr_IN.length, 600000L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Reader(File file, int bufferSize) {
        this.file = file;
        this.bufferSize = Math.min(bufferSize, 600000);
    }

    public void close() {
        this.SURF_file_IN.cleanUp();
    }

    public ArrayList<Marker> getLabels() {
        ArrayList labels = (ArrayList)this.SURF_descr_IN.getProperty("labels");
        return labels;
    }

    public ArrayList<Marker> getNotes() {
        ArrayList notes = (ArrayList)this.SURF_descr_IN.getProperty("notes");
        return notes;
    }

    public ArrayList<Region> getRegions() {
        ArrayList regions = (ArrayList)this.SURF_descr_IN.getProperty("regions");
        return regions;
    }

    public ArrayList<Annotation> getComments() {
        ArrayList comments = (ArrayList)this.SURF_descr_IN.getProperty("comment");
        return comments;
    }

    public ArrayList<Annotation> getMetadata() {
        ArrayList metadata = (ArrayList)this.SURF_descr_IN.getProperty("metadata");
        return metadata;
    }

    public Info getInfo() {
        Info SURFinfo = (Info)this.SURF_descr_IN.getProperty("info");
        return SURFinfo;
    }

    public ArrayList<MissingData> getMissingData() {
        ArrayList missingdata = (ArrayList)this.SURF_descr_IN.getProperty("missingdata");
        return missingdata;
    }

    public Config getConfig() {
        if (!this.isEMDDF()) {
            return null;
        }
        return (Config)this.SURF_descr_IN.getProperty("config");
    }

    private boolean isEMDDF64() {
        return this.SURF_descr_IN.SURF_initial_timestamp != null && this.SURF_descr_IN.SURF_timezone != null && this.SURF_descr_IN.SURF_sample_rate > 0.0f && this.SURF_descr_IN.SURF_channel_calibration != null;
    }

    private boolean isEMDDF() {
        Config cnfg = (Config)this.SURF_descr_IN.getProperty("config");
        if (cnfg == null) {
            return false;
        }
        return cnfg.isEMDDF();
    }

    public long getFinalTimestamp() {
        long initial = Long.parseLong("1446840524599");
        long finalTimestamp = initial + Math.round((double)this.getNumFrames() / this.getRate() * 1000.0);
        return finalTimestamp;
    }

    public MissingData getInitialTimestamp(long aSample) {
        Config conf = (Config)this.SURF_descr_IN.getProperty("config");
        String initialTimestamp = conf.surf_initial_timestamp;
        MissingData timestamp = new MissingData(initialTimestamp, 0L);
        int i = 0;
        try {
            i = 0;
            while (i < this.getMissingData().size()) {
                if (aSample >= this.getMissingData().get(i).getInitialSample()) {
                    if (aSample < this.getMissingData().get(i + 1).getInitialSample()) {
                        return this.getMissingData().get(i);
                    }
                } else {
                    return timestamp;
                }
                ++i;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException e) {
            return this.getMissingData().get(i);
        }
        return timestamp;
    }

    public String getTimestamp(long aSample) throws ParseException {
        MissingData md = this.getInitialTimestamp(aSample);
        long epoch = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(md.getInitialTimestamp()).getTime() / 1000L;
        long num = Math.round((double)(1000L * (aSample - md.getInitialSample())) / this.getRate() + (double)(epoch * 1000L));
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(num));
        return date;
    }

    public void Read(int buffer_size, int start, int samples) {
        ArrayBlockingQueue<float[][]> buffer = new ArrayBlockingQueue<float[][]>(buffer_size);
        new Thread(new ReaderThread1(buffer, start, samples)).start();
    }

    public void Read(int buffer_size, int start) {
        ArrayBlockingQueue<float[][]> buffer = new ArrayBlockingQueue<float[][]>(buffer_size);
        new Thread(new ReaderThread1(buffer, start, 0)).start();
    }

    public void ReadSync(int buffer_size, int start, int samples) {
        ArrayBlockingQueue<float[][]> buffer = new ArrayBlockingQueue<float[][]>(buffer_size);
        this.ReadFile(buffer, start, samples);
    }

    public void ReadSync(int buffer_size, int start) {
        ArrayBlockingQueue<float[][]> buffer = new ArrayBlockingQueue<float[][]>(buffer_size);
        this.ReadFile(buffer, start, 0);
    }

    private void ReadFile(ArrayBlockingQueue<float[][]> buffer, int start, int samples) {
        ArrayBlockingQueue<float[][]> surfData = buffer;
        int offset = start;
        int numSamples = 0;
        int numBuffers = 0;
        int channels = 0;
        try {
            EMDDFile surfFile = EMDDFile.openAsRead(this.file);
            channels = surfFile.getChannelNum();
            numSamples = samples == 0 ? (int)surfFile.getFrameNum() - offset : samples;
            if (numSamples % this.bufferSize == 0) {
                numBuffers = numSamples / this.bufferSize;
            } else {
                numBuffers = (int)Math.ceil(numSamples / this.bufferSize);
                this.samplesRemaining = numSamples - numBuffers * this.bufferSize;
            }
            float[][] frames = new float[channels][this.bufferSize];
            surfFile.seekFrame(offset);
            int saveNumBuffers = numBuffers;
            while (numBuffers > 0) {
                frames = new float[channels][this.bufferSize];
                surfFile.readFrames(frames, 0, this.bufferSize);
                --numBuffers;
                surfData.put(frames);
                ArrayBlockingQueue<float[][]> copy = new ArrayBlockingQueue<float[][]>(1000);
                if (surfData.size() == 1000) {
                    int totalSize = surfData.size();
                    int i = 0;
                    while (i < totalSize) {
                        copy.add(surfData.take());
                        ++i;
                    }
                    this.allBuffers.add(copy);
                    surfData.clear();
                    continue;
                }
                surfData.size();
                this.allBuffers.size();
            }
            if (this.samplesRemaining > 0) {
                frames = new float[channels][this.samplesRemaining];
                surfFile.readFrames(frames, 0, this.samplesRemaining);
                surfData.put(frames);
                this.allBuffers.add(surfData);
            }
            surfFile.cleanUp();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public List<ArrayBlockingQueue<float[][]>> getSamplesList() {
        return this.allBuffers;
    }

    public int getNumChannels() {
        return this.SURF_file_IN.getChannelNum();
    }

    public long getNumFrames() {
        return this.SURF_descr_IN.length;
    }

    public double getRate() {
        return this.SURF_descr_IN.rate;
    }

    public double getBitsPerSample() {
        return this.SURF_descr_IN.bitsPerSample;
    }

    public int getAudioType() {
        return this.SURF_descr_IN.getType();
    }

    public String getType() {
        if (this.SURF_descr_IN.getType() == 4) {
            return "RAW";
        }
        if (this.SURF_descr_IN.getType() == -1) {
            return "UNKNOWN";
        }
        if (this.SURF_descr_IN.getType() == 0) {
            return "WAVE";
        }
        if (this.SURF_descr_IN.getType() == 5) {
            return "WAVE64";
        }
        return "UNKNOWN";
    }

    public int getNumSamples() {
        int c = 0;
        int i = 0;
        while (i < this.allBuffers.size()) {
            ArrayBlockingQueue<float[][]> temp = this.allBuffers.get(i);
            Iterator<float[][]> iterator = temp.iterator();
            while (iterator.hasNext()) {
                float[][] obj;
                float[][] tempFrame = obj = iterator.next();
                int m = 0;
                while (m < this.getNumChannels()) {
                    int k = 0;
                    while (k < tempFrame[m].length) {
                        ++c;
                        ++k;
                    }
                    ++m;
                }
            }
            ++i;
        }
        return c;
    }

    public void printSamples() {
        int i = 0;
        while (i < this.allBuffers.size()) {
            ArrayBlockingQueue<float[][]> temp = this.allBuffers.get(i);
            Iterator<float[][]> iterator = temp.iterator();
            while (iterator.hasNext()) {
                float[][] obj;
                float[][] tempFrame = obj = iterator.next();
                int m = 0;
                while (m < this.getNumChannels()) {
                    int k = 0;
                    while (k < tempFrame[m].length) {
                        System.out.println(tempFrame[m][k]);
                        ++k;
                    }
                    ++m;
                }
            }
            ++i;
        }
    }

    private class ReaderThread1
    implements Runnable {
        private ArrayBlockingQueue<float[][]> surfData;
        int offset = 0;
        int numSamples = 0;

        public ReaderThread1(ArrayBlockingQueue<float[][]> _surfData, int _offset, int _numSamples) {
            this.offset = _offset;
            this.surfData = _surfData;
            this.numSamples = _numSamples;
        }

        @Override
        public void run() {
            Reader.this.ReadFile(this.surfData, this.offset, this.numSamples);
        }
    }
}

