/*
 * Decompiled with CFR 0.152.
 */
package emddf.api.read;

import emddf.api.read.Reader;
import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.util.Range;
import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import javax.swing.JFrame;

public class Chart
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 1L;
    private int chartSize;
    private int numChannels;
    private Chart2D pChart = new Chart2D();
    private ITrace2D pTrace;
    private ITrace2D qTrace;
    private ITrace2D[] traces;
    AAxis yAxis;
    AAxis xAxis;
    Reader reader;
    public List<ArrayBlockingQueue<float[][]>> samplesQueue;
    private Color[] colors;

    public Chart(int maxChartSamples, int numChannels, Reader reader) {
        this.chartSize = maxChartSamples;
        this.numChannels = numChannels;
        this.reader = reader;
        this.colors = new Color[]{Color.RED, Color.BLUE, Color.CYAN, Color.ORANGE, Color.GREEN, Color.MAGENTA, Color.YELLOW};
        this.init();
    }

    public void setPowerSamplesQueue(List<ArrayBlockingQueue<float[][]>> powerSamplesQueue) {
        this.samplesQueue = powerSamplesQueue;
    }

    private void init() {
        this.traces = new Trace2DLtd[this.numChannels];
        int i = 0;
        while (i < this.numChannels) {
            this.traces[i] = new Trace2DLtd(this.chartSize);
            ++i;
        }
        this.yAxis = new AxisLinear();
        this.xAxis = new AxisLinear();
        this.pChart.setAxisY(this.yAxis);
        this.xAxis.setFormatter((IAxisLabelFormatter)new LabelFormatterDate(new SimpleDateFormat("dd-MM-yyyy HH:mm:ss")));
        this.pChart.setAxisX(this.xAxis);
        this.yAxis.setRangePolicy((IRangePolicy)new RangePolicyMinimumViewport(new Range(-1.0, 1.0)));
        i = 0;
        while (i < this.numChannels) {
            this.pChart.addTrace(this.traces[i]);
            ++i;
        }
        i = 0;
        while (i < this.numChannels) {
            this.traces[i].setColor(this.colors[i]);
            this.traces[i].setName("Channel " + (i + 1));
            ++i;
        }
        this.getContentPane().add((Component)this.pChart);
        this.setSize(800, 300);
        this.setVisible(true);
    }

    public List<ArrayBlockingQueue<float[][]>> getPowerSamplesQueue() {
        if (this.samplesQueue == null) {
            this.samplesQueue = new ArrayList<ArrayBlockingQueue<float[][]>>();
        }
        return this.samplesQueue;
    }

    @Override
    public void run() {
        int counter = 0;
        int i = 0;
        while (i < this.samplesQueue.size()) {
            ArrayBlockingQueue<float[][]> temp = this.samplesQueue.get(i);
            float[][] tempFrame = new float[1][1];
            while (temp.size() > 0) {
                System.out.println("sq" + this.samplesQueue.size() + "\nt" + temp.size());
                try {
                    tempFrame = temp.take();
                    System.out.println("pause");
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                int k = 0;
                while (k < tempFrame[0].length) {
                    ++counter;
                    int m = 0;
                    while (m < tempFrame.length) {
                        ++m;
                    }
                    ++k;
                }
            }
            ++i;
        }
    }
}

