/*
 * Decompiled with CFR 0.152.
 */
package emddf.api.delete;

import de.sciss.io.Marker;
import de.sciss.io.Region;
import de.sciss.io.Span;
import emddf.api.read.Reader;
import emddf.file.Annotation;
import emddf.file.EMDDFile;
import emddf.file.EMDDFileDescr;
import emddf.file.Info;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Delete {
    String path;
    String fileName;
    List<Marker> labels;
    List<Marker> notes;
    List<Region> regions;
    List<Annotation> comments;
    List<Annotation> metadatas;
    Info info;
    int fileType;
    private File file_OUT;
    private EMDDFile SURF_file_IN;
    private EMDDFileDescr SURF_descr_IN;
    private EMDDFile SURF_file_OUT;
    private EMDDFileDescr SURF_descr_OUT;

    public Delete(int fileType, String path, String fileName) {
        this.fileType = fileType;
        this.path = path;
        this.fileName = fileName;
        this.labels = new ArrayList<Marker>();
        this.notes = new ArrayList<Marker>();
        this.regions = new ArrayList<Region>();
        this.comments = new ArrayList<Annotation>();
        this.metadatas = new ArrayList<Annotation>();
        this.info = new Info();
    }

    public void removeInfo() {
        this.info = null;
    }

    public void deleteLabel(long pos) {
        Reader r = new Reader(this.getFile());
        int labelsSize = 0;
        try {
            labelsSize = r.getLabels().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < labelsSize) {
            Marker m = r.getLabels().get(i);
            this.labels.add(new Marker(m.pos, m.name));
            ++i;
        }
        i = 0;
        while (i < this.labels.size()) {
            if (this.labels.get((int)i).pos == pos) {
                this.labels.remove(i);
            }
            ++i;
        }
    }

    public void deleteLabel(long pos, String name) {
        Reader r = new Reader(this.getFile());
        int labelsSize = 0;
        try {
            labelsSize = r.getLabels().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < labelsSize) {
            Marker m = r.getLabels().get(i);
            this.labels.add(new Marker(m.pos, m.name));
            ++i;
        }
        this.labels.remove(new Marker(pos, name));
    }

    public void deleteNote(long pos) {
        Reader r = new Reader(this.getFile());
        int notesSize = 0;
        try {
            notesSize = r.getNotes().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < notesSize) {
            Marker m = r.getNotes().get(i);
            this.notes.add(new Marker(m.pos, m.name));
            ++i;
        }
        i = 0;
        while (i < this.notes.size()) {
            if (this.notes.get((int)i).pos == pos) {
                this.notes.remove(i);
            }
            ++i;
        }
    }

    public void deleteComment(String content) {
        Reader r = new Reader(this.getFile());
        int commentsSize = 0;
        try {
            commentsSize = r.getComments().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < commentsSize) {
            Annotation a = r.getComments().get(i);
            this.comments.add(new Annotation(a.content));
            ++i;
        }
        this.comments.remove(new Annotation(content));
    }

    public void deleteComment(int id) {
        Reader r = new Reader(this.getFile());
        int commentsSize = 0;
        try {
            commentsSize = r.getComments().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < commentsSize) {
            Annotation a = r.getComments().get(i);
            this.comments.add(new Annotation(a.content));
            ++i;
        }
        this.comments.remove(id);
    }

    public void deleteMetadata(String content) {
        Reader r = new Reader(this.getFile());
        int metadatasSize = 0;
        try {
            metadatasSize = r.getMetadata().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < metadatasSize) {
            Annotation a = r.getMetadata().get(i);
            this.metadatas.add(new Annotation(a.content));
            ++i;
        }
        this.metadatas.remove(new Annotation(content));
    }

    public void deleteMetadata(int id) {
        Reader r = new Reader(this.getFile());
        int metadatasSize = 0;
        try {
            metadatasSize = r.getMetadata().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < metadatasSize) {
            Annotation a = r.getMetadata().get(i);
            this.metadatas.add(new Annotation(a.content));
            ++i;
        }
        this.metadatas.remove(id);
    }

    public void deleteRegion(Span span) {
        Reader r = new Reader(this.getFile());
        int regionsSize = 0;
        try {
            regionsSize = r.getRegions().size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int i = 0;
        while (i < regionsSize) {
            Region g = r.getRegions().get(i);
            this.regions.add(new Region(g.span, g.name));
            ++i;
        }
        i = 0;
        while (i < this.regions.size()) {
            if (this.regions.get((int)i).span == span) {
                this.regions.remove(i);
            }
            ++i;
        }
    }

    public String getExtension() {
        String extension = this.fileType == 5 ? "w64" : "wav";
        return extension;
    }

    public File getFile() {
        File f = this.fileType == 5 ? new File(String.valueOf(this.path) + this.fileName + ".w64") : new File(String.valueOf(this.path) + this.fileName + ".wav");
        return f;
    }

    public void saveChanges() {
        try {
            this.file_OUT = new File(String.valueOf(this.path) + this.fileName + "-update" + "." + this.getExtension());
            this.SURF_file_IN = EMDDFile.openAsRead(this.getFile());
            this.SURF_file_IN.readMarkers();
            this.SURF_descr_IN = this.SURF_file_IN.getDescr();
            this.SURF_descr_OUT = new EMDDFileDescr();
            this.SURF_descr_OUT.rate = this.SURF_descr_IN.rate;
            this.SURF_descr_OUT.bitsPerSample = this.SURF_descr_IN.bitsPerSample;
            this.SURF_descr_OUT.channels = this.SURF_descr_IN.channels;
            this.SURF_descr_OUT.type = this.SURF_descr_IN.type;
            this.SURF_descr_OUT.file = this.file_OUT;
            this.SURF_descr_OUT.setProperty("labels", this.labels);
            this.SURF_descr_OUT.setProperty("notes", this.notes);
            this.SURF_descr_OUT.setProperty("comment", this.comments);
            this.SURF_descr_OUT.setProperty("metadata", this.metadatas);
            this.SURF_descr_OUT.setProperty("regions", this.regions);
            this.SURF_descr_OUT.setProperty("info", this.info);
            this.SURF_file_OUT = EMDDFile.openAsWrite(this.SURF_descr_OUT);
            this.SURF_file_IN.copyFrames(this.SURF_file_OUT, this.SURF_descr_IN.length);
            this.SURF_file_OUT.cleanUp();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

