/*
 * Decompiled with CFR 0.152.
 */
package emddf.api.create;

import de.sciss.io.Marker;
import de.sciss.io.Region;
import emddf.file.Annotation;
import emddf.file.EMDDFile;
import emddf.file.EMDDFileDescr;
import emddf.file.Info;
import emddf.file.MissingData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;

public class SURFWriter
implements Runnable {
    private File file_OUT;
    private EMDDFile SURF_file_OUT;
    private EMDDFileDescr SURF_descr_OUT;
    private String file_OUT_path = "";
    private String file_OUT_name = "";
    private ArrayBlockingQueue<float[][]> source;
    private List<ArrayBlockingQueue<float[][]>> list;
    private long maxFileSizeInSamples;
    private int maxFileSizeInMegaBytes = 1024;
    private boolean mustQuit = false;
    private int option;
    private int fileType;

    public SURFWriter(int fileType, String filePath, String fileName, ArrayBlockingQueue<float[][]> source, int sampleRate, int bitsPerSample, int channels, int maxFileSizeMB) {
        this.source = source;
        this.maxFileSizeInMegaBytes = maxFileSizeMB;
        this.option = 1;
        this.fileType = fileType;
        this.file_OUT_path = filePath;
        this.file_OUT_name = fileName;
        this.maxFileSizeInSamples = this.maxFileSizeInMegaBytes * 1000000 / (channels * (bitsPerSample / 8));
        this.SURF_descr_OUT = new EMDDFileDescr();
        this.SURF_descr_OUT.rate = sampleRate;
        this.SURF_descr_OUT.bitsPerSample = bitsPerSample;
        this.SURF_descr_OUT.channels = channels;
        this.SURF_descr_OUT.type = fileType;
        if (this.SURF_descr_OUT.SURF_channel_calibration == null) {
            this.SURF_descr_OUT.SURF_channel_calibration = new float[]{1.0f, 1.0f};
        }
        this.SURF_descr_OUT.sampleFormat = bitsPerSample <= 16 ? 0 : 1;
    }

    public SURFWriter(int fileType, String filePath, String fileName, List<ArrayBlockingQueue<float[][]>> list, int sampleRate, int bitsPerSample, int channels, int maxFileSizeMB) {
        this.list = list;
        this.maxFileSizeInMegaBytes = maxFileSizeMB;
        this.option = 2;
        this.fileType = fileType;
        this.file_OUT_path = filePath;
        this.file_OUT_name = fileName;
        this.maxFileSizeInSamples = this.maxFileSizeInMegaBytes * 1000000 / (channels * (bitsPerSample / 8));
        this.SURF_descr_OUT = new EMDDFileDescr();
        this.SURF_descr_OUT.rate = sampleRate;
        this.SURF_descr_OUT.bitsPerSample = bitsPerSample;
        this.SURF_descr_OUT.channels = channels;
        this.SURF_descr_OUT.type = fileType;
        if (this.SURF_descr_OUT.SURF_channel_calibration == null) {
            this.SURF_descr_OUT.SURF_channel_calibration = new float[]{1.0f, 1.0f};
        }
        this.SURF_descr_OUT.sampleFormat = bitsPerSample <= 16 ? 0 : 1;
    }

    public void setLabels(List<Marker> labels) {
        this.SURF_descr_OUT.setProperty("labels", labels);
    }

    public void setNotes(List<Marker> notes) {
        this.SURF_descr_OUT.setProperty("notes", notes);
    }

    public void setRegions(List<Region> regions) {
        this.SURF_descr_OUT.setProperty("regions", regions);
    }

    public void setComments(List<Annotation> comments) {
        this.SURF_descr_OUT.setProperty("comment", comments);
    }

    public void setMetadata(List<Annotation> metadata) {
        this.SURF_descr_OUT.setProperty("metadata", metadata);
    }

    public void setMissingData(List<MissingData> missingdata) {
        this.SURF_descr_OUT.setProperty("missingdata", missingdata);
    }

    public void setInfo(Info SURFInfo) {
        this.SURF_descr_OUT.setProperty("info", SURFInfo);
    }

    public void start() {
        new Thread(this).start();
    }

    public void quit() {
        this.mustQuit = true;
    }

    @Override
    public void run() {
        long unixTimestamp = 0L;
        int fileCount = 1;
        long sampleCount = 0L;
        int i = 0;
        while (!this.mustQuit) {
            String extension = this.fileType == 5 ? ".w64" : ".wav";
            this.SURF_descr_OUT.file = this.file_OUT = new File(String.valueOf(this.file_OUT_path) + "/" + unixTimestamp + "_" + this.file_OUT_name + "-" + fileCount + extension);
            try {
                this.SURF_file_OUT = EMDDFile.openAsWrite(this.SURF_descr_OUT);
                while (sampleCount < this.maxFileSizeInSamples) {
                    float[][] tempFrames = null;
                    if (this.option == 1) {
                        tempFrames = this.source.take();
                        if (this.source.size() == 0) {
                            sampleCount = this.maxFileSizeInSamples;
                            this.quit();
                        }
                    }
                    if (this.option == 2) {
                        tempFrames = this.list.get(i).take();
                        if (i == this.list.size() - 1 && this.list.get(i).size() == 0) {
                            sampleCount = this.maxFileSizeInSamples;
                            this.quit();
                        } else if (this.list.get(i).size() == 0) {
                            ++i;
                        }
                    }
                    int tempFramesLength = tempFrames[0].length;
                    this.SURF_file_OUT.writeFrames(tempFrames, 0, tempFramesLength);
                    sampleCount += (long)tempFramesLength;
                }
                this.SURF_file_OUT.cleanUp();
                sampleCount = 0L;
                ++fileCount;
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

