/*
 * Decompiled with CFR 0.152.
 */
package emddf.api.create;

import de.sciss.io.Marker;
import de.sciss.io.Region;
import emddf.file.Annotation;
import emddf.file.EMDDFile;
import emddf.file.EMDDFileDescr;
import emddf.file.Info;
import emddf.file.MissingData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Merger
implements Runnable {
    private File file_OUT;
    private EMDDFile SURF_file_IN;
    private EMDDFileDescr SURF_descr_IN;
    private EMDDFile SURF_file_OUT;
    private EMDDFileDescr SURF_descr_OUT;
    private File[] files;
    private String fileName_out;
    List<Marker> labels;
    List<Marker> notes;
    List<Region> regions;
    List<Annotation> metadata;
    List<Annotation> comments;
    List<MissingData> missingdata;
    Info info;
    long filesLengthSum;
    double rate;

    public Merger(File[] files, String fileName_out) {
        this.files = files;
        this.fileName_out = fileName_out;
        this.labels = new ArrayList<Marker>();
        this.notes = new ArrayList<Marker>();
        this.regions = new ArrayList<Region>();
        this.metadata = new ArrayList<Annotation>();
        this.comments = new ArrayList<Annotation>();
        this.missingdata = new ArrayList<MissingData>();
    }

    @Override
    public void run() {
        try {
            this.file_OUT = new File(String.valueOf(this.fileName_out) + ".w64");
            this.SURF_file_IN = EMDDFile.openAsRead(this.files[0]);
            this.SURF_file_IN.readMarkers();
            this.SURF_descr_IN = this.SURF_file_IN.getDescr();
            this.SURF_descr_OUT = new EMDDFileDescr();
            this.SURF_descr_OUT.bitsPerSample = this.SURF_descr_IN.bitsPerSample;
            this.SURF_descr_OUT.channels = this.SURF_descr_IN.channels;
            this.SURF_descr_OUT.rate = this.SURF_descr_IN.rate;
            this.SURF_descr_OUT.sampleFormat = this.SURF_descr_IN.sampleFormat;
            this.SURF_descr_OUT.type = 5;
            this.SURF_descr_OUT.file = this.file_OUT;
            this.rate = EMDDFile.openAsRead((File)this.files[0]).getDescr().rate;
            int i = 0;
            while (i < this.files.length) {
                this.SURF_file_IN = EMDDFile.openAsRead(this.files[i]);
                if (this.rate != this.SURF_file_IN.getDescr().rate) {
                    System.out.println("It's not possible to merge files with different rates!");
                    return;
                }
                this.SURF_file_IN.readMarkers();
                this.SURF_descr_IN = this.SURF_file_IN.getDescr();
                if (i == 0) {
                    try {
                        this.info = (Info)this.SURF_descr_IN.getProperty("info");
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                try {
                    ArrayList temp_labels = (ArrayList)this.SURF_descr_IN.getProperty("labels");
                    int j = 0;
                    while (j < temp_labels.size()) {
                        Marker label = new Marker(((Marker)temp_labels.get((int)j)).pos + this.filesLengthSum, ((Marker)temp_labels.get((int)j)).name);
                        this.labels.add(label);
                        ++j;
                    }
                }
                catch (NullPointerException j) {
                    // empty catch block
                }
                try {
                    ArrayList temp_notes = (ArrayList)this.SURF_descr_IN.getProperty("notes");
                    int j = 0;
                    while (j < temp_notes.size()) {
                        Marker note = new Marker(((Marker)temp_notes.get((int)j)).pos + this.filesLengthSum, ((Marker)temp_notes.get((int)j)).name);
                        this.labels.add(note);
                        ++j;
                    }
                }
                catch (NullPointerException j) {
                    // empty catch block
                }
                try {
                    ArrayList temp_regions = (ArrayList)this.SURF_descr_IN.getProperty("regions");
                    int j = 0;
                    while (j < temp_regions.size()) {
                        this.regions.add((Region)temp_regions.get(j));
                        ++j;
                    }
                }
                catch (NullPointerException j) {
                    // empty catch block
                }
                try {
                    ArrayList temp_comments = (ArrayList)this.SURF_descr_IN.getProperty("comment");
                    int j = 0;
                    while (j < temp_comments.size()) {
                        this.comments.add((Annotation)temp_comments.get(j));
                        ++j;
                    }
                }
                catch (NullPointerException j) {
                    // empty catch block
                }
                try {
                    ArrayList temp_metadata = (ArrayList)this.SURF_descr_IN.getProperty("metadata");
                    int j = 0;
                    while (j < temp_metadata.size()) {
                        this.metadata.add((Annotation)temp_metadata.get(j));
                        ++j;
                    }
                }
                catch (NullPointerException j) {
                    // empty catch block
                }
                try {
                    ArrayList temp_missingdata = (ArrayList)this.SURF_descr_IN.getProperty("missingdata");
                    int j = 0;
                    while (j < temp_missingdata.size()) {
                        this.missingdata.add((MissingData)temp_missingdata.get(j));
                        ++j;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.filesLengthSum += EMDDFile.openAsRead((File)this.files[0]).getDescr().length;
                ++i;
            }
            this.SURF_descr_OUT.setProperty("labels", this.labels);
            this.SURF_descr_OUT.setProperty("notes", this.notes);
            this.SURF_descr_OUT.setProperty("regions", this.regions);
            this.SURF_descr_OUT.setProperty("comment", this.comments);
            this.SURF_descr_OUT.setProperty("metadata", this.metadata);
            this.SURF_descr_OUT.setProperty("info", this.info);
            this.SURF_descr_OUT.setProperty("missingdata", this.missingdata);
            this.SURF_file_OUT = EMDDFile.openAsWrite(this.SURF_descr_OUT);
            i = 0;
            while (i < this.files.length) {
                this.SURF_file_IN = EMDDFile.openAsRead(this.files[i]);
                this.SURF_descr_IN = this.SURF_file_IN.getDescr();
                this.SURF_file_IN.copyFrames(this.SURF_file_OUT, this.SURF_descr_IN.length);
                ++i;
            }
            this.SURF_file_OUT.cleanUp();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

