/*
 * Decompiled with CFR 0.152.
 */
package emddf.api.create;

import emddf.api.read.Reader;
import emddf.file.EMDDFile;
import emddf.file.EMDDFileDescr;
import java.io.File;
import java.io.IOException;

public class Converter {
    public String fileToConvert;
    private File file_OUT;
    private EMDDFile SURF_file_IN;
    private EMDDFileDescr SURF_descr_IN;
    private EMDDFile SURF_file_OUT;
    private EMDDFileDescr SURF_descr_OUT;
    private int fileTypeToConvert;
    private String[] extensions;
    private EMDDFileDescr descr;
    private boolean rawFile;

    public Converter(String fileToConvert, int fileTypeToConvert, EMDDFileDescr descr) {
        this.fileTypeToConvert = fileTypeToConvert;
        this.fileToConvert = fileToConvert;
        this.descr = descr;
        this.rawFile = true;
        this.extensions = new String[]{"wav", "", "", "", "raw", "w64"};
    }

    public Converter(String fileToConvert, int fileTypeToConvert) {
        this.fileTypeToConvert = fileTypeToConvert;
        this.fileToConvert = fileToConvert;
        this.rawFile = false;
        this.extensions = new String[]{"wav", "", "", "", "raw", "w64"};
    }

    public int getFileType(File f) {
        Reader r = new Reader(f);
        return r.getAudioType();
    }

    public void convert() {
        File f = new File(this.fileToConvert);
        String[] file = this.fileToConvert.split("." + this.extensions[this.getFileType(f)])[0].split("\\\\");
        String fileName = file[file.length - 1];
        file = this.fileToConvert.split("\\.wav")[0].split(fileName);
        String filePath = file[0];
        try {
            this.file_OUT = new File(String.valueOf(filePath) + fileName + "." + this.extensions[this.fileTypeToConvert]);
            this.SURF_file_IN = EMDDFile.openAsRead(f);
            this.SURF_file_IN.readMarkers();
            this.SURF_descr_IN = this.SURF_file_IN.getDescr();
            if (!this.rawFile) {
                this.SURF_descr_OUT = new EMDDFileDescr();
                this.SURF_descr_OUT.rate = this.SURF_descr_IN.rate;
                this.SURF_descr_OUT.bitsPerSample = this.SURF_descr_IN.bitsPerSample;
                this.SURF_descr_OUT.channels = this.SURF_descr_IN.channels;
            } else {
                this.SURF_descr_OUT = this.descr;
            }
            this.SURF_descr_OUT.type = this.fileTypeToConvert;
            this.SURF_descr_OUT.file = this.file_OUT;
            this.SURF_file_OUT = EMDDFile.openAsWrite(this.SURF_descr_OUT);
            this.SURF_file_IN.copyFrames(this.SURF_file_OUT, this.SURF_descr_IN.length);
            this.SURF_file_OUT.cleanUp();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

