"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VehicleModel = exports.CanDefinition = exports.NetworkFileDefinition = exports.CanVehicleSignal = exports.VehicleSignal = exports.CanVehicleInterface = exports.VehicleInterface = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class VehicleInterface {
    constructor() {
        this.intf = {};
    }
    toObject() {
        return (this.intf);
    }
}
exports.VehicleInterface = VehicleInterface;
_a = JSII_RTTI_SYMBOL_1;
VehicleInterface[_a] = { fqn: "cdk-aws-iotfleetwise.VehicleInterface", version: "0.2.0" };
class CanVehicleInterface extends VehicleInterface {
    constructor(interfaceId, name) {
        super();
        this.intf = {
            type: 'CAN_INTERFACE',
            interfaceId,
            canInterface: {
                canInterfaceName: name,
                protocolName: 'CAN',
                protocolVersion: '2.0b',
            },
        };
    }
}
exports.CanVehicleInterface = CanVehicleInterface;
_b = JSII_RTTI_SYMBOL_1;
CanVehicleInterface[_b] = { fqn: "cdk-aws-iotfleetwise.CanVehicleInterface", version: "0.2.0" };
class VehicleSignal {
    constructor() {
        this.signal = {};
    }
    toObject() {
        return (this.signal);
    }
}
exports.VehicleSignal = VehicleSignal;
_c = JSII_RTTI_SYMBOL_1;
VehicleSignal[_c] = { fqn: "cdk-aws-iotfleetwise.VehicleSignal", version: "0.2.0" };
class CanVehicleSignal extends VehicleSignal {
    constructor(name, fullyQualifiedName, interfaceId, messageId, factor, isBigEndian, isSigned, length, offset, startBit) {
        super();
        this.signal = {
            type: 'CAN_SIGNAL',
            fullyQualifiedName,
            interfaceId,
            canSignal: {
                canSignalName: name,
                factor,
                isBigEndian,
                isSigned,
                length,
                messageId,
                offset,
                startBit,
            },
        };
    }
}
exports.CanVehicleSignal = CanVehicleSignal;
_d = JSII_RTTI_SYMBOL_1;
CanVehicleSignal[_d] = { fqn: "cdk-aws-iotfleetwise.CanVehicleSignal", version: "0.2.0" };
class NetworkFileDefinition {
    constructor() {
        this.definition = {};
    }
    toObject() {
        return (this.definition);
    }
}
exports.NetworkFileDefinition = NetworkFileDefinition;
_e = JSII_RTTI_SYMBOL_1;
NetworkFileDefinition[_e] = { fqn: "cdk-aws-iotfleetwise.NetworkFileDefinition", version: "0.2.0" };
class CanDefinition extends NetworkFileDefinition {
    constructor(networkInterface, signalsMap, canDbcFiles) {
        super();
        this.definition = {
            networkFileType: 'CAN_DBC',
            canDbc: {
                canDbcFiles,
                networkInterface,
                signalsMap,
            },
        };
    }
}
exports.CanDefinition = CanDefinition;
_f = JSII_RTTI_SYMBOL_1;
CanDefinition[_f] = { fqn: "cdk-aws-iotfleetwise.CanDefinition", version: "0.2.0" };
class VehicleModel extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name;
        this.signalCatalog = props.signalCatalog;
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Lambda', {
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: 'vehiclemodelhandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.signalCatalog.lambdaLayer],
            role: this.signalCatalog.lambdaRole,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: onEventHandler,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                name: this.name,
                signal_catalog_arn: props.signalCatalog.arn,
                model_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:model-manifest/${this.name}`,
                description: props.description,
                network_interfaces: JSON.stringify(props.networkInterfaces.map(i => i.toObject())),
                signals: (props.signals) ? JSON.stringify(props.signals.map(s => s.toObject())) : '{}',
                network_file_definitions: (props.networkFileDefinitions) ? JSON.stringify(props.networkFileDefinitions.map(s => s.toObject())) : '{}',
            },
        });
        resource.node.addDependency(this.signalCatalog);
    }
}
exports.VehicleModel = VehicleModel;
_g = JSII_RTTI_SYMBOL_1;
VehicleModel[_g] = { fqn: "cdk-aws-iotfleetwise.VehicleModel", version: "0.2.0" };
//# sourceMappingURL=data:application/json;base64,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