"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Vehicle = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * The vehicle of a specific type from which IoT FleetWise collect signals.
 */
class Vehicle extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:vehicle/${props.vehicleId}`;
        this.vehicleModel = props.vehicleModel;
        this.vehicleId = props.vehicleId;
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Lambda', {
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: 'vehiclehandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.vehicleModel.signalCatalog.lambdaLayer],
            role: this.vehicleModel.signalCatalog.lambdaRole,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: onEventHandler,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                vehicle_id: props.vehicleId,
                create_iot_thing: props.createIotThing,
                decoder_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:decoder-manifest/${props.vehicleModel.name}`,
                model_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:model-manifest/${props.vehicleModel.name}`,
            },
        });
        resource.node.addDependency(this.vehicleModel);
        if (props.createIotThing) {
            this.endpointAddress = resource.getAtt('endpointAddress').toString();
            this.certificateId = resource.getAtt('certificateId').toString();
            this.certificateArn = resource.getAtt('certificateArn').toString();
            this.certificatePem = resource.getAtt('certificatePem').toString();
            this.privateKey = resource.getAtt('privateKey').toString();
            const policy = new aws_cdk_lib_1.aws_iot.CfnPolicy(this, 'Policy', {
                policyName: `${props.vehicleId}-policy`,
                policyDocument: `{
          "Version": "2012-10-17",
          "Statement": [{
                  "Effect": "Allow",
                  "Action": [
                      "iot:Connect",
                      "iot:Subscribe",
                      "iot:Publish",
                      "iot:Receive"
                  ],
                  "Resource": [
                      "arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:client/${props.vehicleId}*",
                      "arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:topic/*",
                      "arn:aws:iot:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:topicfilter/*"
                  ]
          }]
        }`,
            });
            policy.node.addDependency(resource);
            const policy_attachement = new aws_cdk_lib_1.aws_iot.CfnPolicyPrincipalAttachment(this, 'Attachment', {
                policyName: policy.policyName,
                principal: this.certificateArn,
            });
            policy_attachement.node.addDependency(policy);
            const thing_attachment = new aws_cdk_lib_1.aws_iot.CfnThingPrincipalAttachment(this, 'ThingAttachment', {
                thingName: props.vehicleId,
                principal: this.certificateArn,
            });
            thing_attachment.node.addDependency(policy_attachement);
        }
    }
}
exports.Vehicle = Vehicle;
_a = JSII_RTTI_SYMBOL_1;
Vehicle[_a] = { fqn: "cdk-aws-iotfleetwise.Vehicle", version: "0.2.0" };
//# sourceMappingURL=data:application/json;base64,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