"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignalCatalog = exports.SignalCatalogSensor = exports.SignalCatalogBranch = exports.SignalCatalogNode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class SignalCatalogNode {
    constructor() {
        this.node = {};
    }
    toObject() {
        return (this.node);
    }
}
exports.SignalCatalogNode = SignalCatalogNode;
_a = JSII_RTTI_SYMBOL_1;
SignalCatalogNode[_a] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogNode", version: "0.2.0" };
class SignalCatalogBranch extends SignalCatalogNode {
    constructor(name, fullyQualifiedName, description) {
        super();
        this.node = {
            type: 'Branch',
            branch: {
                name: name,
                fullyQualifiedName: fullyQualifiedName,
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogBranch = SignalCatalogBranch;
_b = JSII_RTTI_SYMBOL_1;
SignalCatalogBranch[_b] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogBranch", version: "0.2.0" };
class SignalCatalogSensor extends SignalCatalogNode {
    constructor(name, fullyQualifiedName, dataType, unit, min, max, description) {
        super();
        this.node = {
            type: 'Sensor',
            sensor: {
                name,
                fullyQualifiedName,
                dataType,
                ...unit && { unit },
                ...min && { min },
                ...max && { max },
                ...description && { description },
            },
        };
    }
}
exports.SignalCatalogSensor = SignalCatalogSensor;
_c = JSII_RTTI_SYMBOL_1;
SignalCatalogSensor[_c] = { fqn: "cdk-aws-iotfleetwise.SignalCatalogSensor", version: "0.2.0" };
/**
 * The Signal Catalog represents the list of all signals that you want to collect from all
 * the vehicles.
 *
 *
 * The AWS IoT Fleetwise preview can only support a single Signal Catalog per account.
 *
 */
class SignalCatalog extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name || 'default';
        this.description = props.description;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:signal-catalog/${this.name}`;
        this.lambdaRole = new aws_cdk_lib_1.aws_iam.Role(this, 'Role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AdministratorAccess'),
            ],
        });
        this.lambdaLayer = new aws_cdk_lib_1.aws_lambda.LayerVersion(this, 'Boto3', {
            description: 'Boto3 Library with Iot Fleetwise Support',
            compatibleRuntimes: [aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9],
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../layer.zip')),
        });
        const code = aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers'));
        const onEventHandlerService = new aws_cdk_lib_1.aws_lambda.Function(this, 'Service', {
            code,
            handler: 'servicehandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.lambdaLayer],
            role: this.lambdaRole,
        });
        const isCompleteHandlerService = new aws_cdk_lib_1.aws_lambda.Function(this, 'ServiceComplete', {
            code,
            handler: 'servicehandler.is_complete',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.lambdaLayer],
            role: this.lambdaRole,
        });
        const providerService = new aws_cdk_lib_1.custom_resources.Provider(this, 'ServiceProvider', {
            onEventHandler: onEventHandlerService,
            isCompleteHandler: isCompleteHandlerService,
        });
        const serviceResource = new cdk.CustomResource(this, 'ServiceResource', {
            serviceToken: providerService.serviceToken,
            properties: {
                role_arn: props.role.roleArn,
                database_name: props.database.databaseName,
                table_name: props.table.tableName,
            },
        });
        const onEventHandlerCatalog = new aws_cdk_lib_1.aws_lambda.Function(this, 'Catalog', {
            code,
            handler: 'signalcataloghandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.lambdaLayer],
            role: this.lambdaRole,
        });
        const providerCatalog = new aws_cdk_lib_1.custom_resources.Provider(this, 'CatalogProvider', {
            onEventHandler: onEventHandlerCatalog,
        });
        const resourceCatalog = new cdk.CustomResource(this, 'CatalogResource', {
            serviceToken: providerCatalog.serviceToken,
            properties: {
                name: this.name,
                description: this.description,
                nodes: JSON.stringify(props.nodes.map(node => node.toObject())),
            },
        });
        resourceCatalog.node.addDependency(serviceResource);
    }
}
exports.SignalCatalog = SignalCatalog;
_d = JSII_RTTI_SYMBOL_1;
SignalCatalog[_d] = { fqn: "cdk-aws-iotfleetwise.SignalCatalog", version: "0.2.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2lnbmFsY2F0YWxvZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9zaWduYWxjYXRhbG9nLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLG1DQUFtQztBQUNuQyw2Q0FLcUI7QUFDckIsMkNBQXVDO0FBRXZDLE1BQWEsaUJBQWlCO0lBRzVCO1FBQ0UsSUFBSSxDQUFDLElBQUksR0FBRyxFQUFFLENBQUM7SUFDakIsQ0FBQztJQUVELFFBQVE7UUFDTixPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3JCLENBQUM7O0FBVEgsOENBVUM7OztBQUVELE1BQWEsbUJBQW9CLFNBQVEsaUJBQWlCO0lBQ3hELFlBQ0UsSUFBWSxFQUNaLGtCQUEwQixFQUMxQixXQUFvQjtRQUdwQixLQUFLLEVBQUUsQ0FBQztRQUVSLElBQUksQ0FBQyxJQUFJLEdBQUc7WUFDVixJQUFJLEVBQUUsUUFBUTtZQUNkLE1BQU0sRUFBRTtnQkFDTixJQUFJLEVBQUUsSUFBSTtnQkFDVixrQkFBa0IsRUFBRSxrQkFBa0I7Z0JBQ3RDLEdBQUcsV0FBVyxJQUFJLEVBQUUsV0FBVyxFQUFFO2FBQ2xDO1NBQ0YsQ0FBQztJQUNKLENBQUM7O0FBakJILGtEQWtCQzs7O0FBRUQsTUFBYSxtQkFBb0IsU0FBUSxpQkFBaUI7SUFDeEQsWUFDRSxJQUFZLEVBQ1osa0JBQTBCLEVBQzFCLFFBQWdCLEVBQ2hCLElBQWEsRUFDYixHQUFZLEVBQ1osR0FBWSxFQUNaLFdBQW9CO1FBQ3BCLEtBQUssRUFBRSxDQUFDO1FBRVIsSUFBSSxDQUFDLElBQUksR0FBRztZQUNWLElBQUksRUFBRSxRQUFRO1lBQ2QsTUFBTSxFQUFFO2dCQUNOLElBQUk7Z0JBQ0osa0JBQWtCO2dCQUNsQixRQUFRO2dCQUNSLEdBQUcsSUFBSSxJQUFJLEVBQUUsSUFBSSxFQUFFO2dCQUNuQixHQUFHLEdBQUcsSUFBSSxFQUFFLEdBQUcsRUFBRTtnQkFDakIsR0FBRyxHQUFHLElBQUksRUFBRSxHQUFHLEVBQUU7Z0JBQ2pCLEdBQUcsV0FBVyxJQUFJLEVBQUUsV0FBVyxFQUFFO2FBRWxDO1NBQ0YsQ0FBQztJQUNKLENBQUM7O0FBeEJILGtEQXlCQzs7O0FBV0Q7Ozs7Ozs7R0FPRztBQUNILE1BQWEsYUFBYyxTQUFRLHNCQUFTO0lBVTFDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMkI7UUFDbkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUdqQixJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLElBQUksU0FBUyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztRQUNyQyxJQUFJLENBQUMsR0FBRyxHQUFHLHdCQUF3QixHQUFHLENBQUMsR0FBRyxDQUFDLE1BQU0sSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLFVBQVUsbUJBQW1CLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztRQUV0RyxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUkscUJBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLE1BQU0sRUFBRTtZQUMzQyxTQUFTLEVBQUUsSUFBSSxxQkFBRyxDQUFDLGdCQUFnQixDQUFDLHNCQUFzQixDQUFDO1lBQzNELGVBQWUsRUFBRTtnQkFDZixxQkFBRyxDQUFDLGFBQWEsQ0FBQyx3QkFBd0IsQ0FBQywwQ0FBMEMsQ0FBQztnQkFDdEYscUJBQUcsQ0FBQyxhQUFhLENBQUMsd0JBQXdCLENBQUMscUJBQXFCLENBQUM7YUFDbEU7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksd0JBQU0sQ0FBQyxZQUFZLENBQUMsSUFBSSxFQUFFLE9BQU8sRUFBRTtZQUN4RCxXQUFXLEVBQUUsMENBQTBDO1lBQ3ZELGtCQUFrQixFQUFFLENBQUMsd0JBQU0sQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDO1lBQy9DLElBQUksRUFBRSx3QkFBTSxDQUFDLFNBQVMsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsZUFBZSxDQUFDLENBQUM7U0FDeEUsQ0FBQyxDQUFDO1FBRUgsTUFBTSxJQUFJLEdBQUcsd0JBQU0sQ0FBQyxTQUFTLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLGtCQUFrQixDQUFDLENBQUMsQ0FBQztRQUVsRixNQUFNLHFCQUFxQixHQUFHLElBQUksd0JBQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRTtZQUNqRSxJQUFJO1lBQ0osT0FBTyxFQUFFLHlCQUF5QjtZQUNsQyxPQUFPLEVBQUUsR0FBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDO1lBQ2xDLE9BQU8sRUFBRSx3QkFBTSxDQUFDLE9BQU8sQ0FBQyxVQUFVO1lBQ2xDLE1BQU0sRUFBRSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUM7WUFDMUIsSUFBSSxFQUFFLElBQUksQ0FBQyxVQUFVO1NBQ3RCLENBQUMsQ0FBQztRQUVILE1BQU0sd0JBQXdCLEdBQUcsSUFBSSx3QkFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsaUJBQWlCLEVBQUU7WUFDNUUsSUFBSTtZQUNKLE9BQU8sRUFBRSw0QkFBNEI7WUFDckMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQztZQUNsQyxPQUFPLEVBQUUsd0JBQU0sQ0FBQyxPQUFPLENBQUMsVUFBVTtZQUNsQyxNQUFNLEVBQUUsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQzFCLElBQUksRUFBRSxJQUFJLENBQUMsVUFBVTtTQUN0QixDQUFDLENBQUM7UUFFSCxNQUFNLGVBQWUsR0FBRyxJQUFJLDhCQUFFLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxpQkFBaUIsRUFBRTtZQUMvRCxjQUFjLEVBQUUscUJBQXFCO1lBQ3JDLGlCQUFpQixFQUFFLHdCQUF3QjtTQUM1QyxDQUFDLENBQUM7UUFFSCxNQUFNLGVBQWUsR0FBRyxJQUFJLEdBQUcsQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLGlCQUFpQixFQUFFO1lBQ3RFLFlBQVksRUFBRSxlQUFlLENBQUMsWUFBWTtZQUMxQyxVQUFVLEVBQUU7Z0JBQ1YsUUFBUSxFQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsT0FBTztnQkFDNUIsYUFBYSxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsWUFBWTtnQkFDMUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxLQUFLLENBQUMsU0FBUzthQUNsQztTQUNGLENBQUMsQ0FBQztRQUVILE1BQU0scUJBQXFCLEdBQUcsSUFBSSx3QkFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsU0FBUyxFQUFFO1lBQ2pFLElBQUk7WUFDSixPQUFPLEVBQUUsK0JBQStCO1lBQ3hDLE9BQU8sRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUM7WUFDbEMsT0FBTyxFQUFFLHdCQUFNLENBQUMsT0FBTyxDQUFDLFVBQVU7WUFDbEMsTUFBTSxFQUFFLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztZQUMxQixJQUFJLEVBQUUsSUFBSSxDQUFDLFVBQVU7U0FDdEIsQ0FBQyxDQUFDO1FBRUgsTUFBTSxlQUFlLEdBQUcsSUFBSSw4QkFBRSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsaUJBQWlCLEVBQUU7WUFDL0QsY0FBYyxFQUFFLHFCQUFxQjtTQUN0QyxDQUFDLENBQUM7UUFFSCxNQUFNLGVBQWUsR0FBRyxJQUFJLEdBQUcsQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLGlCQUFpQixFQUFFO1lBQ3RFLFlBQVksRUFBRSxlQUFlLENBQUMsWUFBWTtZQUMxQyxVQUFVLEVBQUU7Z0JBQ1YsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO2dCQUNmLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztnQkFDN0IsS0FBSyxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQzthQUNoRTtTQUNGLENBQUMsQ0FBQztRQUVILGVBQWUsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ3RELENBQUM7O0FBekZILHNDQTBGQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHtcbiAgYXdzX2lhbSBhcyBpYW0sXG4gIGF3c190aW1lc3RyZWFtIGFzIHRzLFxuICBhd3NfbGFtYmRhIGFzIGxhbWJkYSxcbiAgY3VzdG9tX3Jlc291cmNlcyBhcyBjcixcbn0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbmV4cG9ydCBjbGFzcyBTaWduYWxDYXRhbG9nTm9kZSB7XG4gIHByb3RlY3RlZCBub2RlOiBvYmplY3Q7XG5cbiAgY29uc3RydWN0b3IoKSB7XG4gICAgdGhpcy5ub2RlID0ge307XG4gIH1cblxuICB0b09iamVjdCgpOiBvYmplY3Qge1xuICAgIHJldHVybiAodGhpcy5ub2RlKTtcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgU2lnbmFsQ2F0YWxvZ0JyYW5jaCBleHRlbmRzIFNpZ25hbENhdGFsb2dOb2RlIHtcbiAgY29uc3RydWN0b3IoXG4gICAgbmFtZTogc3RyaW5nLFxuICAgIGZ1bGx5UXVhbGlmaWVkTmFtZTogc3RyaW5nLFxuICAgIGRlc2NyaXB0aW9uPzogc3RyaW5nLFxuXG4gICkge1xuICAgIHN1cGVyKCk7XG5cbiAgICB0aGlzLm5vZGUgPSB7XG4gICAgICB0eXBlOiAnQnJhbmNoJyxcbiAgICAgIGJyYW5jaDoge1xuICAgICAgICBuYW1lOiBuYW1lLFxuICAgICAgICBmdWxseVF1YWxpZmllZE5hbWU6IGZ1bGx5UXVhbGlmaWVkTmFtZSxcbiAgICAgICAgLi4uZGVzY3JpcHRpb24gJiYgeyBkZXNjcmlwdGlvbiB9LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBTaWduYWxDYXRhbG9nU2Vuc29yIGV4dGVuZHMgU2lnbmFsQ2F0YWxvZ05vZGUge1xuICBjb25zdHJ1Y3RvcihcbiAgICBuYW1lOiBzdHJpbmcsXG4gICAgZnVsbHlRdWFsaWZpZWROYW1lOiBzdHJpbmcsXG4gICAgZGF0YVR5cGU6IHN0cmluZyxcbiAgICB1bml0Pzogc3RyaW5nLFxuICAgIG1pbj86IG51bWJlcixcbiAgICBtYXg/OiBudW1iZXIsXG4gICAgZGVzY3JpcHRpb24/OiBzdHJpbmcpIHtcbiAgICBzdXBlcigpO1xuXG4gICAgdGhpcy5ub2RlID0ge1xuICAgICAgdHlwZTogJ1NlbnNvcicsXG4gICAgICBzZW5zb3I6IHtcbiAgICAgICAgbmFtZSxcbiAgICAgICAgZnVsbHlRdWFsaWZpZWROYW1lLFxuICAgICAgICBkYXRhVHlwZSxcbiAgICAgICAgLi4udW5pdCAmJiB7IHVuaXQgfSxcbiAgICAgICAgLi4ubWluICYmIHsgbWluIH0sXG4gICAgICAgIC4uLm1heCAmJiB7IG1heCB9LFxuICAgICAgICAuLi5kZXNjcmlwdGlvbiAmJiB7IGRlc2NyaXB0aW9uIH0sXG5cbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIElTZXJ2aWNlQ2F0YWxvZ1Byb3BzIHtcbiAgbmFtZT86IHN0cmluZztcbiAgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG4gIHJvbGU6IGlhbS5Sb2xlO1xuICBkYXRhYmFzZTogdHMuQ2ZuRGF0YWJhc2U7XG4gIHRhYmxlOiB0cy5DZm5UYWJsZTtcbiAgbm9kZXM6IFNpZ25hbENhdGFsb2dOb2RlW107XG59XG5cbi8qKlxuICogVGhlIFNpZ25hbCBDYXRhbG9nIHJlcHJlc2VudHMgdGhlIGxpc3Qgb2YgYWxsIHNpZ25hbHMgdGhhdCB5b3Ugd2FudCB0byBjb2xsZWN0IGZyb20gYWxsXG4gKiB0aGUgdmVoaWNsZXMuXG4gKlxuICpcbiAqIFRoZSBBV1MgSW9UIEZsZWV0d2lzZSBwcmV2aWV3IGNhbiBvbmx5IHN1cHBvcnQgYSBzaW5nbGUgU2lnbmFsIENhdGFsb2cgcGVyIGFjY291bnQuXG4gKlxuICovXG5leHBvcnQgY2xhc3MgU2lnbmFsQ2F0YWxvZyBleHRlbmRzIENvbnN0cnVjdCB7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgc2lnbmFsIGNhdGFsb2dcbiAgICovXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgZGVzY3JpcHRpb246IChzdHJpbmd8dW5kZWZpbmVkKTtcbiAgcmVhZG9ubHkgYXJuOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGxhbWJkYVJvbGU6IGlhbS5Sb2xlO1xuICByZWFkb25seSBsYW1iZGFMYXllcjogbGFtYmRhLkxheWVyVmVyc2lvbjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSVNlcnZpY2VDYXRhbG9nUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG5cbiAgICB0aGlzLm5hbWUgPSBwcm9wcy5uYW1lIHx8ICdkZWZhdWx0JztcbiAgICB0aGlzLmRlc2NyaXB0aW9uID0gcHJvcHMuZGVzY3JpcHRpb247XG4gICAgdGhpcy5hcm4gPSBgYXJuOmF3czppb3RmbGVldHdpc2U6JHtjZGsuQXdzLlJFR0lPTn06JHtjZGsuQXdzLkFDQ09VTlRfSUR9OnNpZ25hbC1jYXRhbG9nLyR7dGhpcy5uYW1lfWA7XG5cbiAgICB0aGlzLmxhbWJkYVJvbGUgPSBuZXcgaWFtLlJvbGUodGhpcywgJ1JvbGUnLCB7XG4gICAgICBhc3N1bWVkQnk6IG5ldyBpYW0uU2VydmljZVByaW5jaXBhbCgnbGFtYmRhLmFtYXpvbmF3cy5jb20nKSxcbiAgICAgIG1hbmFnZWRQb2xpY2llczogW1xuICAgICAgICBpYW0uTWFuYWdlZFBvbGljeS5mcm9tQXdzTWFuYWdlZFBvbGljeU5hbWUoJ3NlcnZpY2Utcm9sZS9BV1NMYW1iZGFCYXNpY0V4ZWN1dGlvblJvbGUnKSxcbiAgICAgICAgaWFtLk1hbmFnZWRQb2xpY3kuZnJvbUF3c01hbmFnZWRQb2xpY3lOYW1lKCdBZG1pbmlzdHJhdG9yQWNjZXNzJyksXG4gICAgICBdLFxuICAgIH0pO1xuXG4gICAgdGhpcy5sYW1iZGFMYXllciA9IG5ldyBsYW1iZGEuTGF5ZXJWZXJzaW9uKHRoaXMsICdCb3RvMycsIHtcbiAgICAgIGRlc2NyaXB0aW9uOiAnQm90bzMgTGlicmFyeSB3aXRoIElvdCBGbGVldHdpc2UgU3VwcG9ydCcsXG4gICAgICBjb21wYXRpYmxlUnVudGltZXM6IFtsYW1iZGEuUnVudGltZS5QWVRIT05fM185XSxcbiAgICAgIGNvZGU6IGxhbWJkYS5Bc3NldENvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICcvLi4vbGF5ZXIuemlwJykpLFxuICAgIH0pO1xuXG4gICAgY29uc3QgY29kZSA9IGxhbWJkYS5Bc3NldENvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICcvLi4vc3JjL2hhbmRsZXJzJykpO1xuXG4gICAgY29uc3Qgb25FdmVudEhhbmRsZXJTZXJ2aWNlID0gbmV3IGxhbWJkYS5GdW5jdGlvbih0aGlzLCAnU2VydmljZScsIHtcbiAgICAgIGNvZGUsXG4gICAgICBoYW5kbGVyOiAnc2VydmljZWhhbmRsZXIub25fZXZlbnQnLFxuICAgICAgdGltZW91dDogY2RrLkR1cmF0aW9uLnNlY29uZHMoMzAwKSxcbiAgICAgIHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lLlBZVEhPTl8zXzksXG4gICAgICBsYXllcnM6IFt0aGlzLmxhbWJkYUxheWVyXSxcbiAgICAgIHJvbGU6IHRoaXMubGFtYmRhUm9sZSxcbiAgICB9KTtcblxuICAgIGNvbnN0IGlzQ29tcGxldGVIYW5kbGVyU2VydmljZSA9IG5ldyBsYW1iZGEuRnVuY3Rpb24odGhpcywgJ1NlcnZpY2VDb21wbGV0ZScsIHtcbiAgICAgIGNvZGUsXG4gICAgICBoYW5kbGVyOiAnc2VydmljZWhhbmRsZXIuaXNfY29tcGxldGUnLFxuICAgICAgdGltZW91dDogY2RrLkR1cmF0aW9uLnNlY29uZHMoMzAwKSxcbiAgICAgIHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lLlBZVEhPTl8zXzksXG4gICAgICBsYXllcnM6IFt0aGlzLmxhbWJkYUxheWVyXSxcbiAgICAgIHJvbGU6IHRoaXMubGFtYmRhUm9sZSxcbiAgICB9KTtcblxuICAgIGNvbnN0IHByb3ZpZGVyU2VydmljZSA9IG5ldyBjci5Qcm92aWRlcih0aGlzLCAnU2VydmljZVByb3ZpZGVyJywge1xuICAgICAgb25FdmVudEhhbmRsZXI6IG9uRXZlbnRIYW5kbGVyU2VydmljZSxcbiAgICAgIGlzQ29tcGxldGVIYW5kbGVyOiBpc0NvbXBsZXRlSGFuZGxlclNlcnZpY2UsXG4gICAgfSk7XG5cbiAgICBjb25zdCBzZXJ2aWNlUmVzb3VyY2UgPSBuZXcgY2RrLkN1c3RvbVJlc291cmNlKHRoaXMsICdTZXJ2aWNlUmVzb3VyY2UnLCB7XG4gICAgICBzZXJ2aWNlVG9rZW46IHByb3ZpZGVyU2VydmljZS5zZXJ2aWNlVG9rZW4sXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIHJvbGVfYXJuOiBwcm9wcy5yb2xlLnJvbGVBcm4sXG4gICAgICAgIGRhdGFiYXNlX25hbWU6IHByb3BzLmRhdGFiYXNlLmRhdGFiYXNlTmFtZSxcbiAgICAgICAgdGFibGVfbmFtZTogcHJvcHMudGFibGUudGFibGVOYW1lLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIGNvbnN0IG9uRXZlbnRIYW5kbGVyQ2F0YWxvZyA9IG5ldyBsYW1iZGEuRnVuY3Rpb24odGhpcywgJ0NhdGFsb2cnLCB7XG4gICAgICBjb2RlLFxuICAgICAgaGFuZGxlcjogJ3NpZ25hbGNhdGFsb2doYW5kbGVyLm9uX2V2ZW50JyxcbiAgICAgIHRpbWVvdXQ6IGNkay5EdXJhdGlvbi5zZWNvbmRzKDMwMCksXG4gICAgICBydW50aW1lOiBsYW1iZGEuUnVudGltZS5QWVRIT05fM185LFxuICAgICAgbGF5ZXJzOiBbdGhpcy5sYW1iZGFMYXllcl0sXG4gICAgICByb2xlOiB0aGlzLmxhbWJkYVJvbGUsXG4gICAgfSk7XG5cbiAgICBjb25zdCBwcm92aWRlckNhdGFsb2cgPSBuZXcgY3IuUHJvdmlkZXIodGhpcywgJ0NhdGFsb2dQcm92aWRlcicsIHtcbiAgICAgIG9uRXZlbnRIYW5kbGVyOiBvbkV2ZW50SGFuZGxlckNhdGFsb2csXG4gICAgfSk7XG5cbiAgICBjb25zdCByZXNvdXJjZUNhdGFsb2cgPSBuZXcgY2RrLkN1c3RvbVJlc291cmNlKHRoaXMsICdDYXRhbG9nUmVzb3VyY2UnLCB7XG4gICAgICBzZXJ2aWNlVG9rZW46IHByb3ZpZGVyQ2F0YWxvZy5zZXJ2aWNlVG9rZW4sXG4gICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgIG5hbWU6IHRoaXMubmFtZSxcbiAgICAgICAgZGVzY3JpcHRpb246IHRoaXMuZGVzY3JpcHRpb24sXG4gICAgICAgIG5vZGVzOiBKU09OLnN0cmluZ2lmeShwcm9wcy5ub2Rlcy5tYXAobm9kZSA9PiBub2RlLnRvT2JqZWN0KCkpKSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICByZXNvdXJjZUNhdGFsb2cubm9kZS5hZGREZXBlbmRlbmN5KHNlcnZpY2VSZXNvdXJjZSk7XG4gIH1cbn1cblxuIl19