"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Fleet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * The fleet of vehicles
 */
class Fleet extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:fleet/${props.fleetId}`;
        this.signalCatalog = props.signalCatalog;
        this.fleetId = props.fleetId;
        this.vehicles = props.vehicles || [];
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Lambda', {
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: 'fleethandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.signalCatalog.lambdaLayer],
            role: this.signalCatalog.lambdaRole,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: onEventHandler,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                fleet_id: this.fleetId,
                signal_catalog_arn: this.signalCatalog.arn,
                description: props.description,
                vehicle_ids: this.vehicles.map(v => v.vehicleId),
            },
        });
        resource.node.addDependency(this.signalCatalog);
    }
}
exports.Fleet = Fleet;
_a = JSII_RTTI_SYMBOL_1;
Fleet[_a] = { fqn: "cdk-aws-iotfleetwise.Fleet", version: "0.2.0" };
//# sourceMappingURL=data:application/json;base64,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