"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Campaign = exports.CampaignSignal = exports.TimeBasedCollectionScheme = exports.CollectionScheme = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class CollectionScheme {
    constructor() {
        this.scheme = {};
    }
    toObject() {
        return (this.scheme);
    }
}
exports.CollectionScheme = CollectionScheme;
_a = JSII_RTTI_SYMBOL_1;
CollectionScheme[_a] = { fqn: "cdk-aws-iotfleetwise.CollectionScheme", version: "0.2.0" };
class TimeBasedCollectionScheme extends CollectionScheme {
    constructor(period) {
        super();
        this.scheme = {
            timeBasedCollectionScheme: {
                periodMs: period.toMilliseconds(),
            },
        };
    }
}
exports.TimeBasedCollectionScheme = TimeBasedCollectionScheme;
_b = JSII_RTTI_SYMBOL_1;
TimeBasedCollectionScheme[_b] = { fqn: "cdk-aws-iotfleetwise.TimeBasedCollectionScheme", version: "0.2.0" };
class CampaignSignal {
    constructor(name, maxSampleCount, minimumSamplingInterval) {
        this.signal = {
            signalName: name,
            ...maxSampleCount && { maxSampleCount },
            ...minimumSamplingInterval && { minimumSamplingInterval },
        };
    }
    toObject() {
        return (this.signal);
    }
}
exports.CampaignSignal = CampaignSignal;
_c = JSII_RTTI_SYMBOL_1;
CampaignSignal[_c] = { fqn: "cdk-aws-iotfleetwise.CampaignSignal", version: "0.2.0" };
class Campaign extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name;
        this.arn = `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:vehicle/${props.target}`;
        this.target = props.target;
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Lambda', {
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: 'campaignhandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.target.vehicleModel.signalCatalog.lambdaLayer],
            role: this.target.vehicleModel.signalCatalog.lambdaRole,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: onEventHandler,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                campaign_name: this.name,
                signal_catalog_arn: this.target.vehicleModel.signalCatalog.arn,
                target_arn: this.target.arn,
                collection_scheme: JSON.stringify(props.collectionScheme.toObject()),
                signals_to_collect: JSON.stringify(props.signals.map(s => s.toObject())),
            },
        });
        resource.node.addDependency(this.target);
    }
}
exports.Campaign = Campaign;
_d = JSII_RTTI_SYMBOL_1;
Campaign[_d] = { fqn: "cdk-aws-iotfleetwise.Campaign", version: "0.2.0" };
//# sourceMappingURL=data:application/json;base64,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