# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository   # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class CreateInboxDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'description': 'str',
        'email_address': 'str',
        'expires_at': 'datetime',
        'favourite': 'bool',
        'name': 'str',
        'tags': 'list[str]'
    }

    attribute_map = {
        'description': 'description',
        'email_address': 'emailAddress',
        'expires_at': 'expiresAt',
        'favourite': 'favourite',
        'name': 'name',
        'tags': 'tags'
    }

    def __init__(self, description=None, email_address=None, expires_at=None, favourite=None, name=None, tags=None, local_vars_configuration=None):  # noqa: E501
        """CreateInboxDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._description = None
        self._email_address = None
        self._expires_at = None
        self._favourite = None
        self._name = None
        self._tags = None
        self.discriminator = None

        if description is not None:
            self.description = description
        if email_address is not None:
            self.email_address = email_address
        if expires_at is not None:
            self.expires_at = expires_at
        if favourite is not None:
            self.favourite = favourite
        if name is not None:
            self.name = name
        if tags is not None:
            self.tags = tags

    @property
    def description(self):
        """Gets the description of this CreateInboxDto.  # noqa: E501

        Optional description of an inbox for labelling purposes  # noqa: E501

        :return: The description of this CreateInboxDto.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this CreateInboxDto.

        Optional description of an inbox for labelling purposes  # noqa: E501

        :param description: The description of this CreateInboxDto.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def email_address(self):
        """Gets the email_address of this CreateInboxDto.  # noqa: E501

        Optionally specify an email address you want the inbox to have. When left blank an email address will be randomly assigned to the inbox usually ending in `@mailslurp.com`. Custom email addresses must include your own custom domain that you have configured in MailSlurp. So if your domain is `mysite.com` you can created any email address ending in `@mysite.com`. All email addresses are transformed to lowercase!  # noqa: E501

        :return: The email_address of this CreateInboxDto.  # noqa: E501
        :rtype: str
        """
        return self._email_address

    @email_address.setter
    def email_address(self, email_address):
        """Sets the email_address of this CreateInboxDto.

        Optionally specify an email address you want the inbox to have. When left blank an email address will be randomly assigned to the inbox usually ending in `@mailslurp.com`. Custom email addresses must include your own custom domain that you have configured in MailSlurp. So if your domain is `mysite.com` you can created any email address ending in `@mysite.com`. All email addresses are transformed to lowercase!  # noqa: E501

        :param email_address: The email_address of this CreateInboxDto.  # noqa: E501
        :type: str
        """

        self._email_address = email_address

    @property
    def expires_at(self):
        """Gets the expires_at of this CreateInboxDto.  # noqa: E501

        When, if ever, will the inbox expire and be deleted. If null then this inbox is permanent and the emails in it won't be deleted. Timestamp passed as string.  # noqa: E501

        :return: The expires_at of this CreateInboxDto.  # noqa: E501
        :rtype: datetime
        """
        return self._expires_at

    @expires_at.setter
    def expires_at(self, expires_at):
        """Sets the expires_at of this CreateInboxDto.

        When, if ever, will the inbox expire and be deleted. If null then this inbox is permanent and the emails in it won't be deleted. Timestamp passed as string.  # noqa: E501

        :param expires_at: The expires_at of this CreateInboxDto.  # noqa: E501
        :type: datetime
        """

        self._expires_at = expires_at

    @property
    def favourite(self):
        """Gets the favourite of this CreateInboxDto.  # noqa: E501

        Is the inbox favorited. Favouriting inboxes is typically done in the dashboard for quick access  # noqa: E501

        :return: The favourite of this CreateInboxDto.  # noqa: E501
        :rtype: bool
        """
        return self._favourite

    @favourite.setter
    def favourite(self, favourite):
        """Sets the favourite of this CreateInboxDto.

        Is the inbox favorited. Favouriting inboxes is typically done in the dashboard for quick access  # noqa: E501

        :param favourite: The favourite of this CreateInboxDto.  # noqa: E501
        :type: bool
        """

        self._favourite = favourite

    @property
    def name(self):
        """Gets the name of this CreateInboxDto.  # noqa: E501

        Optional name of the inbox. Displayed in the dashboard for easier search  # noqa: E501

        :return: The name of this CreateInboxDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateInboxDto.

        Optional name of the inbox. Displayed in the dashboard for easier search  # noqa: E501

        :param name: The name of this CreateInboxDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def tags(self):
        """Gets the tags of this CreateInboxDto.  # noqa: E501

        Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI.  # noqa: E501

        :return: The tags of this CreateInboxDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this CreateInboxDto.

        Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI.  # noqa: E501

        :param tags: The tags of this CreateInboxDto.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateInboxDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateInboxDto):
            return True

        return self.to_dict() != other.to_dict()
