/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry;

import javax.vecmath.Point3d;
import org.openscience.cdk.geometry.IRDFWeightFunction;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class RDFCalculator {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(RDFCalculator.class);
    private double startCutoff;
    private double cutoff;
    private double resolution;
    private double peakWidth;
    private IRDFWeightFunction weightFunction;

    public RDFCalculator(double startCutoff, double cutoff, double resolution, double peakWidth) {
        this(startCutoff, cutoff, resolution, peakWidth, null);
    }

    public RDFCalculator(double startCutoff, double cutoff, double resolution, double peakWidth, IRDFWeightFunction weightFunction) {
        this.startCutoff = startCutoff;
        this.cutoff = cutoff;
        this.resolution = resolution;
        this.peakWidth = peakWidth;
        this.weightFunction = weightFunction;
    }

    public double[] calculate(IAtomContainer container, IAtom atom) {
        int length = (int)((this.cutoff - this.startCutoff) / this.resolution) + 1;
        logger.debug("Creating RDF of length ", length);
        int binsToFillOnEachSide = (int)(this.peakWidth * 3.0 / this.resolution);
        double sigmaSquare = Math.pow(this.peakWidth, 2.0);
        double[] factors = new double[binsToFillOnEachSide];
        double totalArea = 0.0;
        if (factors.length > 0) {
            int binCounter;
            factors[0] = 1.0;
            for (binCounter = 1; binCounter < factors.length; ++binCounter) {
                double height;
                factors[binCounter] = height = Math.exp(-1.0 * Math.pow((double)binCounter * this.resolution, 2.0) / sigmaSquare);
                totalArea += height;
            }
            for (binCounter = 0; binCounter < factors.length; ++binCounter) {
                factors[binCounter] = factors[binCounter] / totalArea;
            }
        }
        double[] rdf = new double[length];
        double distance = 0.0;
        int index = 0;
        Point3d atomPoint = atom.getPoint3d();
        for (IAtom atomInContainer : container.atoms()) {
            if (atom == atomInContainer) continue;
            distance = atomPoint.distance(atomInContainer.getPoint3d());
            index = (int)((distance - this.startCutoff) / this.resolution);
            double weight = 1.0;
            if (this.weightFunction != null) {
                weight = this.weightFunction.calculate(atom, atomInContainer);
            }
            if (factors.length > 0) {
                int n = index;
                rdf[n] = rdf[n] + weight * factors[0];
                for (int binCounter = 1; binCounter < factors.length; ++binCounter) {
                    double diff = weight * factors[binCounter];
                    if (index - binCounter >= 0) {
                        int n2 = index - binCounter;
                        rdf[n2] = rdf[n2] + diff;
                    }
                    if (index + binCounter >= length) continue;
                    int n3 = index + binCounter;
                    rdf[n3] = rdf[n3] + diff;
                }
                continue;
            }
            int n = index;
            rdf[n] = rdf[n] + weight;
        }
        return rdf;
    }
}

