/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import libpadeldescriptor.AtomConstants;
import libpadeldescriptor.IntrinsicStateDescriptor;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class BurdenModifiedEigenvaluesDescriptor
implements IMolecularDescriptor {
    private static final int maxEigenValues = 8;
    public String[] names = new String[16 * wtypes.length];
    private static final String[] wtypes = new String[]{"m", "v", "e", "p", "i", "s"};

    public BurdenModifiedEigenvaluesDescriptor() {
        int n = 0;
        for (String string : wtypes) {
            int n2;
            for (n2 = 1; n2 <= 8; ++n2) {
                this.names[n++] = "SpMax" + n2 + "_Bh" + string;
            }
            for (n2 = 1; n2 <= 8; ++n2) {
                this.names[n++] = "SpMin" + n2 + "_Bh" + string;
            }
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("BME", this.getClass().getName(), "$Id: BurdenModifiedEigenvaluesDescriptor.java 1 2014-06-06 12:00:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n = iAtomContainer.getAtomCount();
        double[][] dArray = new double[wtypes.length][n];
        IntrinsicStateDescriptor intrinsicStateDescriptor = new IntrinsicStateDescriptor();
        int n2 = 0;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n3 = iAtomContainer.getAtom(i).getAtomicNumber();
            dArray[0][i] = n3 < AtomConstants.masses.length ? AtomConstants.masses[n3] / AtomConstants.masses[6] : Double.NaN;
            dArray[1][i] = n3 < AtomConstants.volumes.length ? AtomConstants.volumes[n3] / AtomConstants.volumes[6] : Double.NaN;
            dArray[2][i] = n3 < AtomConstants.sandersonelnegativities.length ? AtomConstants.sandersonelnegativities[n3] / AtomConstants.sandersonelnegativities[6] : Double.NaN;
            dArray[3][i] = n3 < AtomConstants.polarizabilities.length ? AtomConstants.polarizabilities[n3] / AtomConstants.polarizabilities[6] : Double.NaN;
            dArray[4][i] = n3 < AtomConstants.ionpotentials.length ? AtomConstants.ionpotentials[n3] / AtomConstants.ionpotentials[6] : Double.NaN;
            IAtom iAtom = iAtomContainer.getAtom(i);
            if (n3 == 1) {
                dArray[5][i] = 1.0;
                continue;
            }
            DoubleArrayResult doubleArrayResult = (DoubleArrayResult)intrinsicStateDescriptor.calculate(iAtom, iAtomContainer).getValue();
            dArray[5][i] = doubleArrayResult.get(0);
            if (n3 != 6) continue;
            ++n2;
            d += doubleArrayResult.get(0);
        }
        double d2 = d / (double)n2;
        int n4 = 0;
        while (n4 < n) {
            double[] dArray2 = dArray[5];
            int n5 = n4++;
            dArray2[n5] = dArray2[n5] / d2;
        }
        for (n4 = 0; n4 < wtypes.length; ++n4) {
            for (int i = 0; i < n; ++i) {
                if (!Double.isNaN(dArray[n4][i])) continue;
                return this.getDummyDescriptorValue(new CDKException("Atom in molecule is not recognized"));
            }
        }
        double[][] dArray3 = this.getBurdenModifiedMatrixTemplate(iAtomContainer);
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        for (int i = 0; i < wtypes.length; ++i) {
            int n6;
            for (int j = 0; j < n; ++j) {
                dArray3[j][j] = dArray[i][j];
            }
            Matrix matrix = new Matrix(dArray3);
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
            double[] dArray4 = eigenvalueDecomposition.getRealEigenvalues();
            int n7 = dArray4.length - 1;
            for (n6 = 0; n6 < 8; ++n6) {
                if (n7 >= 0) {
                    doubleArrayResult.add(Math.abs(dArray4[n7--]));
                    continue;
                }
                doubleArrayResult.add(Double.NaN);
            }
            n7 = 0;
            for (n6 = 0; n6 < 8; ++n6) {
                if (n7 < dArray4.length) {
                    doubleArrayResult.add(Math.abs(dArray4[n7++]));
                    continue;
                }
                doubleArrayResult.add(Double.NaN);
            }
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    private double[][] getBurdenModifiedMatrixTemplate(IAtomContainer iAtomContainer) {
        int n = iAtomContainer.getAtomCount();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[i][j] = 0.0;
            }
        }
        double d = Math.sqrt(1.5);
        double d2 = Math.sqrt(2.0);
        double d3 = Math.sqrt(3.0);
        for (IBond iBond : iAtomContainer.bonds()) {
            int n2 = iAtomContainer.getAtomNumber(iBond.getAtom(0));
            int n3 = iAtomContainer.getAtomNumber(iBond.getAtom(1));
            IBond.Order order = iBond.getOrder();
            if (iBond.getFlag(5)) {
                dArray[n2][n3] = d;
            } else if (order == IBond.Order.SINGLE) {
                dArray[n2][n3] = 1.0;
            } else if (order == IBond.Order.DOUBLE) {
                dArray[n2][n3] = d2;
            } else if (order == IBond.Order.TRIPLE) {
                dArray[n2][n3] = d3;
            }
            if (iAtomContainer.getAtom(n2).getAtomicNumber() != 1 && iAtomContainer.getAtom(n3).getAtomicNumber() != 1 && (iAtomContainer.getConnectedBondsCount(n2) == 1 || iAtomContainer.getConnectedBondsCount(n3) == 1)) {
                double[] dArray2 = dArray[n2];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + 0.1;
            }
            dArray[n3][n2] = dArray[n2][n3];
        }
        return dArray;
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }
}

