# mypy-boto3-wafv2

[![PyPI - mypy-boto3-wafv2](https://img.shields.io/pypi/v/mypy-boto3-wafv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-wafv2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-wafv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-wafv2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-wafv2?color=blue)](https://pypistats.org/packages/mypy-boto3-wafv2)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.WAFV2 1.17.61](https://boto3.amazonaws.com/v1/documentation/api/1.17.61/reference/services/wafv2.html#WAFV2) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.8.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[auto-generated docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_wafv2/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-wafv2](#mypy-boto3-wafv2)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `WAFV2` service.

```bash
python -m pip install boto3-stubs[wafv2]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[wafv2]` in your environment: `python -m pip install 'boto3-stubs[wafv2]'`

Both type checking and auto-complete should work for `WAFV2` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[wafv2]` in your environment: `python -m pip install 'boto3-stubs[wafv2]'`

Both type checking and auto-complete should work for `WAFV2` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[wafv2]` in your environment: `python -m pip install 'boto3-stubs[wafv2]'`
- Run `mypy` as usual

Type checking should work for `WAFV2` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[wafv2]` in your environment: `python -m pip install 'boto3-stubs[wafv2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `WAFV2` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`WAFV2Client` provides annotations for `boto3.client("wafv2")`.

```python
import boto3

from mypy_boto3_wafv2 import WAFV2Client

client: WAFV2Client = boto3.client("wafv2")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WAFV2Client = session.client("wafv2")
```








### Literals

`mypy_boto3_wafv2.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_wafv2.literals import (
    ActionValue,
    BodyParsingFallbackBehavior,
    ComparisonOperator,
    CountryCode,
    FallbackBehavior,
    FilterBehavior,
    FilterRequirement,
    ForwardedIPPosition,
    IPAddressVersion,
    JsonMatchScope,
    LabelMatchScope,
    PositionalConstraint,
    RateBasedStatementAggregateKeyType,
    ResourceType,
    ResponseContentType,
    Scope,
    TextTransformationType,
)

def check_value(value: ActionValue) -> bool:
    ...
```



### Typed dictionaries

`mypy_boto3_wafv2.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_wafv2.type_defs import (
    ActionConditionTypeDef,
    AllowActionTypeDef,
    AndStatementTypeDef,
    BlockActionTypeDef,
    ByteMatchStatementTypeDef,
    CheckCapacityResponseTypeDef,
    ConditionTypeDef,
    CountActionTypeDef,
    CreateIPSetResponseTypeDef,
    CreateRegexPatternSetResponseTypeDef,
    CreateRuleGroupResponseTypeDef,
    CreateWebACLResponseTypeDef,
    CustomHTTPHeaderTypeDef,
    CustomRequestHandlingTypeDef,
    CustomResponseBodyTypeDef,
    CustomResponseTypeDef,
    DefaultActionTypeDef,
    DeleteFirewallManagerRuleGroupsResponseTypeDef,
    DescribeManagedRuleGroupResponseTypeDef,
    ExcludedRuleTypeDef,
    FieldToMatchTypeDef,
    FilterTypeDef,
    FirewallManagerRuleGroupTypeDef,
    FirewallManagerStatementTypeDef,
    ForwardedIPConfigTypeDef,
    GeoMatchStatementTypeDef,
    GetIPSetResponseTypeDef,
    GetLoggingConfigurationResponseTypeDef,
    GetPermissionPolicyResponseTypeDef,
    GetRateBasedStatementManagedKeysResponseTypeDef,
    GetRegexPatternSetResponseTypeDef,
    GetRuleGroupResponseTypeDef,
    GetSampledRequestsResponseTypeDef,
    GetWebACLForResourceResponseTypeDef,
    GetWebACLResponseTypeDef,
    HTTPHeaderTypeDef,
    HTTPRequestTypeDef,
    IPSetForwardedIPConfigTypeDef,
    IPSetReferenceStatementTypeDef,
    IPSetSummaryTypeDef,
    IPSetTypeDef,
    JsonBodyTypeDef,
    JsonMatchPatternTypeDef,
    LabelMatchStatementTypeDef,
    LabelNameConditionTypeDef,
    LabelSummaryTypeDef,
    LabelTypeDef,
    ListAvailableManagedRuleGroupsResponseTypeDef,
    ListIPSetsResponseTypeDef,
    ListLoggingConfigurationsResponseTypeDef,
    ListRegexPatternSetsResponseTypeDef,
    ListResourcesForWebACLResponseTypeDef,
    ListRuleGroupsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListWebACLsResponseTypeDef,
    LoggingConfigurationTypeDef,
    LoggingFilterTypeDef,
    ManagedRuleGroupStatementTypeDef,
    ManagedRuleGroupSummaryTypeDef,
    NotStatementTypeDef,
    OrStatementTypeDef,
    OverrideActionTypeDef,
    PutLoggingConfigurationResponseTypeDef,
    RateBasedStatementManagedKeysIPSetTypeDef,
    RateBasedStatementTypeDef,
    RegexPatternSetReferenceStatementTypeDef,
    RegexPatternSetSummaryTypeDef,
    RegexPatternSetTypeDef,
    RegexTypeDef,
    RuleActionTypeDef,
    RuleGroupReferenceStatementTypeDef,
    RuleGroupSummaryTypeDef,
    RuleGroupTypeDef,
    RuleSummaryTypeDef,
    RuleTypeDef,
    SampledHTTPRequestTypeDef,
    SingleHeaderTypeDef,
    SingleQueryArgumentTypeDef,
    SizeConstraintStatementTypeDef,
    SqliMatchStatementTypeDef,
    StatementTypeDef,
    TagInfoForResourceTypeDef,
    TagTypeDef,
    TextTransformationTypeDef,
    TimeWindowTypeDef,
    UpdateIPSetResponseTypeDef,
    UpdateRegexPatternSetResponseTypeDef,
    UpdateRuleGroupResponseTypeDef,
    UpdateWebACLResponseTypeDef,
    VisibilityConfigTypeDef,
    WebACLSummaryTypeDef,
    WebACLTypeDef,
    XssMatchStatementTypeDef,
)

def get_structure() -> ActionConditionTypeDef:
    return {
      ...
    }
```
