"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_docdb_1 = require("monocdk/aws-docdb");
/**
 * Document DB clusters have the username and password stored in Secrets Manager
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_docdb_1.CfnDBCluster) {
        const masterUsername = monocdk_1.Stack.of(node).resolve(node.masterUsername);
        const masterUserPassword = monocdk_1.Stack.of(node).resolve(node.masterUserPassword);
        if (masterUsername.includes('{{resolve:secretsmanager') == false ||
            masterUserPassword.includes('{{resolve:secretsmanager') == false) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRE9DMy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvZGF0YWJhc2VzL0RPQzMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRixxQ0FBNkM7QUFDN0MsaURBQWlEO0FBRWpEOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSx3QkFBWSxFQUFFO1FBQ2hDLE1BQU0sY0FBYyxHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUNuRSxNQUFNLGtCQUFrQixHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzNFLElBQ0UsY0FBYyxDQUFDLFFBQVEsQ0FBQywwQkFBMEIsQ0FBQyxJQUFJLEtBQUs7WUFDNUQsa0JBQWtCLENBQUMsUUFBUSxDQUFDLDBCQUEwQixDQUFDLElBQUksS0FBSyxFQUNoRTtZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQVpELDRCQVlDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkRCQ2x1c3RlciB9IGZyb20gJ21vbm9jZGsvYXdzLWRvY2RiJztcblxuLyoqXG4gKiBEb2N1bWVudCBEQiBjbHVzdGVycyBoYXZlIHRoZSB1c2VybmFtZSBhbmQgcGFzc3dvcmQgc3RvcmVkIGluIFNlY3JldHMgTWFuYWdlclxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkRCQ2x1c3Rlcikge1xuICAgIGNvbnN0IG1hc3RlclVzZXJuYW1lID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShub2RlLm1hc3RlclVzZXJuYW1lKTtcbiAgICBjb25zdCBtYXN0ZXJVc2VyUGFzc3dvcmQgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKG5vZGUubWFzdGVyVXNlclBhc3N3b3JkKTtcbiAgICBpZiAoXG4gICAgICBtYXN0ZXJVc2VybmFtZS5pbmNsdWRlcygne3tyZXNvbHZlOnNlY3JldHNtYW5hZ2VyJykgPT0gZmFsc2UgfHxcbiAgICAgIG1hc3RlclVzZXJQYXNzd29yZC5pbmNsdWRlcygne3tyZXNvbHZlOnNlY3JldHNtYW5hZ2VyJykgPT0gZmFsc2VcbiAgICApIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=