"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_msk_1 = require("monocdk/aws-msk");
/**
 * MSK clusters use TLS communication between brokers
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_msk_1.CfnCluster) {
        const encryptionInfo = monocdk_1.Stack.of(node).resolve(node.encryptionInfo);
        if (encryptionInfo != undefined) {
            const encryptionInTransit = monocdk_1.Stack.of(node).resolve(encryptionInfo.encryptionInTransit);
            if (encryptionInTransit != undefined) {
                const inCluster = monocdk_1.Stack.of(node).resolve(encryptionInTransit.inCluster);
                if (inCluster != undefined && inCluster == false) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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