# API Reference

**Classes**

Name|Description
----|-----------
[AwsSolutionsChecks](#monocdk-nag-awssolutionschecks)|Check Best practices based on AWS Solutions Security Matrix.
[NIST80053Checks](#monocdk-nag-nist80053checks)|Check for NIST 800-53 compliance.
[NagPack](#monocdk-nag-nagpack)|Base class for all rule sets.


**Structs**

Name|Description
----|-----------
[NagPackProps](#monocdk-nag-nagpackprops)|Interface for creating a Nag rule set.



## class AwsSolutionsChecks  <a id="monocdk-nag-awssolutionschecks"></a>

Check Best practices based on AWS Solutions Security Matrix.

__Implements__: [IAspect](#monocdk-iaspect)
__Extends__: [NagPack](#monocdk-nag-nagpack)

### Initializer




```ts
new AwsSolutionsChecks(props?: NagPackProps)
```

* **props** (<code>[NagPackProps](#monocdk-nag-nagpackprops)</code>)  *No description*
  * **verbose** (<code>boolean</code>)  Whether or not to enable extended explanatory descriptions on warning and error messages. __*Optional*__


### Methods


#### visit(node) <a id="monocdk-nag-awssolutionschecks-visit"></a>

All aspects can visit an IConstruct.

```ts
visit(node: IConstruct): void
```

* **node** (<code>[IConstruct](#monocdk-iconstruct)</code>)  *No description*






## class NIST80053Checks  <a id="monocdk-nag-nist80053checks"></a>

Check for NIST 800-53 compliance.

Based on the NIST 800-53 AWS operational best practices: https://docs.aws.amazon.com/config/latest/developerguide/operational-best-practices-for-nist-800-53_rev_4.html

__Implements__: [IAspect](#monocdk-iaspect)
__Extends__: [NagPack](#monocdk-nag-nagpack)

### Initializer




```ts
new NIST80053Checks(props?: NagPackProps)
```

* **props** (<code>[NagPackProps](#monocdk-nag-nagpackprops)</code>)  *No description*
  * **verbose** (<code>boolean</code>)  Whether or not to enable extended explanatory descriptions on warning and error messages. __*Optional*__


### Methods


#### visit(node) <a id="monocdk-nag-nist80053checks-visit"></a>

All aspects can visit an IConstruct.

```ts
visit(node: IConstruct): void
```

* **node** (<code>[IConstruct](#monocdk-iconstruct)</code>)  *No description*






## class NagPack  <a id="monocdk-nag-nagpack"></a>

Base class for all rule sets.

__Implements__: [IAspect](#monocdk-iaspect)
__Implemented by__: [AwsSolutionsChecks](#monocdk-nag-awssolutionschecks), [NIST80053Checks](#monocdk-nag-nist80053checks)

### Initializer




```ts
new NagPack(props?: NagPackProps)
```

* **props** (<code>[NagPackProps](#monocdk-nag-nagpackprops)</code>)  *No description*
  * **verbose** (<code>boolean</code>)  Whether or not to enable extended explanatory descriptions on warning and error messages. __*Optional*__



### Properties


Name | Type | Description 
-----|------|-------------
**verbose** | <code>boolean</code> | <span></span>

### Methods


#### createMessage(ruleId, info, explanation) <a id="monocdk-nag-nagpack-createmessage"></a>

The message to output to the console when a rule is triggered.

```ts
createMessage(ruleId: string, info: string, explanation: string): string
```

* **ruleId** (<code>string</code>)  the id of the rule.
* **info** (<code>string</code>)  why the rule was triggered.
* **explanation** (<code>string</code>)  why the rule exists.

__Returns__:
* <code>string</code>

#### ignoreRule(ignores, ruleId) <a id="monocdk-nag-nagpack-ignorerule"></a>

Check whether a specific rule should be ignored.

```ts
ignoreRule(ignores: any, ruleId: string): boolean
```

* **ignores** (<code>any</code>)  ignores listed in cdkNag metadata.
* **ruleId** (<code>string</code>)  the id of the rule to ignore.

__Returns__:
* <code>boolean</code>

#### visit(node) <a id="monocdk-nag-nagpack-visit"></a>

All aspects can visit an IConstruct.

```ts
visit(node: IConstruct): void
```

* **node** (<code>[IConstruct](#monocdk-iconstruct)</code>)  *No description*






## struct NagPackProps  <a id="monocdk-nag-nagpackprops"></a>


Interface for creating a Nag rule set.



Name | Type | Description 
-----|------|-------------
**verbose**? | <code>boolean</code> | Whether or not to enable extended explanatory descriptions on warning and error messages.<br/>__*Optional*__



