# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pybound']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'pybound',
    'version': '1.0.5',
    'description': 'pyBound is a collection of helpful functions that are useful in almost every python file.',
    'long_description': '# pyBound\n\nAllows you to access multiple useful tools in your python code quick and easy.\n\n---\n### Documentation:\n\n - `clear()` - clears console\n\n - `wait(time=___)` - pauses code for number for seconds inputed. `time` is an optional parameter. By default it is 1 second.\n```\nprint("Hello, welcome to pyBound!")\nwait()\nprint("This is some extra text!")\nwait(4)\nclear()\n```\nwill display:\n```\nHello, welcome to pyBound!\n```\nfor 1 second, and then it will display:\n```\nHello, welcome to pyBound!\nThis is some extra text!\n```\nfor 4 seconds, after which the console will be cleared. The final display will be:\n\n```\n```\n\nHere are some formatting functions that pybound has to offer:\n\n - `rgb_fore(r, g, b)` - Changes color of printed text to an RGB value. \n - `rgb_back(r, g, b)` - Changes background of printed text to an RGB value\n\nThere are also more formatting options for your python text. They are used the same way the `rgb_fore()` and rgb_back` is used. They are listed here:\n\n- `end()` - Deletes all existing formatting\n\n- `bold()` - Bolds text\n\n- `faint()` - Decreases the opacity of text\n\n- `italic()` - Italicizes text\n\n- `underline()` - Underlines text\n\n- `blink_slow()` - Makes text blink slowly\n\n- `blink_fast()` - Makes text blink quickly\n\n- `negative()` - Inverts the background color and the foreground color of text\n\n- `conceal()` - Makes text invisible\n\n- `crossed()` - Strikes through text\n\n```\nred = rgb_fore(255, 0, 0)\nblue = rgb_fore(0, 0, 255)\nprint(red + "Hello, " + blue + "there!")\nprint("I love pyBound!")\n```\nwill print\n```\nHello there!\nI love pyBound!\n```\nsuch that `Hello,` is in red and `there! I love pyBound!` is in blue. However, you can use `end()` to fix this.\n\n```\nred = rgb_fore(255, 0, 0)\nblue = rgb_fore(0, 0, 255)\nend = end()\nprint(red + "Hello, " + blue + "there!" + end)\nprint("I love pyBound!")\n```\nwill print `Hello,` in red, and `there!` in blue, and `I love pyBound!` in the default console text color, usually white.\n\npyBound also provides the `\\x1b` ANSI Escape Codes with easier functionality. All parameters are optional. For most of the `\\x1b` ANSI Escape Code functions, the default is 1. Exceptions are listed below the functions.\n\n- `cursor_up(num=___)` - Moves cursor up `num` number of times.\n- `cursor_down(num=___)` - Moves cursor down `num` number of times.\n- `cursor_forward(num=___)` - Moves cursor forward `num` number of times.\n- `cursor_back(num=___)` - Moves cursor backwards `num` number of times.\n- `cursor_next_line(num=___)` - Moves cursor to the next line `num` number of times.\n- `cursor_prev_line(num=___)` - Moves cursor to the previous line `num` number of times.\n- `cursor_horiz_abs_pos(col=___)` - Cursor is moved to the column that the `col` parameter provides, within the row that it is already in.\n- `cursor_pos(row=___, col=___)` - Moves cursor to the specified row and column provided by the `row` and `col` parameters from the top left.\n- `cursor_indent(num=___)` - Indents cursor. Can be used alternatively to \\t.\n- `erase_in_display(mode=___)` - Check below for modes.\n- `erase_in_line(mode=___)` - Check below for modes.\n- `scroll_up(num=___)` - EXPLANATION NEEDED\n- `scroll_down(num=___)` - EXPLANATION NEEDED\n- `cursor_save_pos()` - Saves cursor position to be used when restoring cursor position.\n- `cursor_restore_pos()` - Uses saved cursor position to restore it.\n- `cursor_invisible()` - Makes cursor invisible in the console.\n- `cursor_visible()` - Makes the cursor visible in the console.\n\n\n---\nThe following are exceptions for the \\x1b functions\' default parameter of "1":\n- `erase_in_display(mode=___)` -  Check the next section for information on this.\n- `erase_in_line(mode=___)` - Check the next section for information on this.\n- `cursor_save_pos()`, `cursor_restore_pos()`, `cursor_invisible()`, and `cursor_visible()` all don\'t have parameters.\n\n---\nThe following are the modes for `erase_in_display(mode=___)`:\n- Mode `cursorToEnd` - Erase from cursor to end of screen.\n- Mode `startToCursor` - Erase from start of screen to cursor.\n- Mode `entireScreen` - Erase entire screen (default if mode not specified).\n- Mode `scrollback` - Erase scrollback.\n- \nThe following are the modes for `erase_in_line(mode=___):`\n- Mode `cursorToEnd` - Erase from cursor to end of line\n- Mode `startToCursor` - Erase from start of line to cursor\n- Mode `entireLine` - Erase entire line (default if mode not specified)\n---\n - `slow_print(*strings, \ntime=___\n, sep=___\n, end=___)` - prints text in a typwriter animation, one character at a time. All parameters are optional.\n\nPybound\'s `slow_print()` function was modeled after Python\'s original print statement, you can do virtually all the same things in `slow_print()` and in `print()`. The default paramaters are showcased below, such that the following lines will do the same thing:\n\n```\nslow_print("Hello", "Welcome!", time = 0.045, sep = \' \', end = \'\\n\')\n\nslow_print("Hello", "Welcome!", )\n```\nThis is basically the same as the `print()` function, but the `flush` parameter is replaced by the `time` parameter. Time represents the time in seconds between the printing of each character.   You have to write the time as an integer or a float, although it is recommended that you stay in between 0 and 1 seconds. ',
    'author': "Xhaiden D'Souza",
    'author_email': 'xhaidendsouza@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://pypi.org/project/pybound/',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
