# The FlexMeasures Platform

![lint-and-test](https://github.com/SeitaBV/flexmeasures/workflows/lint-and-test/badge.svg)
[![Pypi Version](https://img.shields.io/pypi/v/flexmeasures.svg)](https://pypi.python.org/pypi/flexmeasures)
[![](https://img.shields.io/badge/python-3.6+-blue.svg)](https://www.python.org/downloads/)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Documentation Status](https://readthedocs.org/projects/flexmeasures/badge/?version=latest)](https://flexmeasures.readthedocs.io/en/latest/?badge=latest)

The *FlexMeasures Platform* is a tool for building real-time energy flexibility services, rapidly and scalable. 

- Developing energy flexibility services (e.g. to enable demand response) is crucial, but expensive.
- FlexMeasures reduces development costs with real-time data integrations, uncertainty models and API/UI support.

![Separation of concerns ― FlexMeasures enhancing Energy Service Company services](https://seita.nl/wp-content/uploads/2021/02/SeparationOfConcerns.png)


The role of FlexMeasures is to enhance the services of energy service companies (ESCOs) towards energy flexibility. For instance, forecasts and schedules are made available via API (designed with [the USEF framework](https://usef.energy) in mind). Uncertainty about ongoing events is modelled accurately and for a decentralised eco-system with the [timely-beliefs framework](https://github.com/SeitaBV/timely-beliefs).

![Integration view of the FlexMeasures platform architecture](https://seita.nl/wp-content/uploads/2021/02/FlexMeasures-HighLevel.png)

FlexMeasures is developed by [Seita BV](https://www.seita.nl) in The Netherlands.

We made FlexMeasures freely available under the Apache2.0 licence. Please get in contact if you use FlexMeasures or are considering it.

Head over to our [documentation](https://flexmeasures.readthedocs.io), e.g. the [getting started guide](https://flexmeasures.readthedocs.io/en/latest/getting-started.html). Or find more information on [FlexMeasures.io](https://flexmeasures.io).

