# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class FileUploadApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def file_upload_get_dataset_file_upload_url(self, file_name, **kwargs):  # noqa: E501
        """GetDatasetFileUploadURL  # noqa: E501

        Returns a pre-signed upload URL for a dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_upload_get_dataset_file_upload_url(file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_name: Name of dataset file. (required)
        :param str upload_path: Path to uploaded data.
        :return: RimeGetDatasetFileUploadURLResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.file_upload_get_dataset_file_upload_url_with_http_info(file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.file_upload_get_dataset_file_upload_url_with_http_info(file_name, **kwargs)  # noqa: E501
            return data

    def file_upload_get_dataset_file_upload_url_with_http_info(self, file_name, **kwargs):  # noqa: E501
        """GetDatasetFileUploadURL  # noqa: E501

        Returns a pre-signed upload URL for a dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_upload_get_dataset_file_upload_url_with_http_info(file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_name: Name of dataset file. (required)
        :param str upload_path: Path to uploaded data.
        :return: RimeGetDatasetFileUploadURLResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_name', 'upload_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method file_upload_get_dataset_file_upload_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `file_upload_get_dataset_file_upload_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'file_name' in params:
            query_params.append(('fileName', params['file_name']))  # noqa: E501
        if 'upload_path' in params:
            query_params.append(('uploadPath', params['upload_path']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/datasets/upload-url', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetDatasetFileUploadURLResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def file_upload_get_model_directory_upload_urls(self, directory_name, relative_file_paths, **kwargs):  # noqa: E501
        """GetModelDirectoryUploadURL  # noqa: E501

        Returns a pre-signed upload URL for a model directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_upload_get_model_directory_upload_urls(directory_name, relative_file_paths, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_name: Name of model directory. (required)
        :param list[str] relative_file_paths: Array of relative paths from model directory to model files. (required)
        :param str upload_path: Path to uploaded data.
        :return: RimeGetModelDirectoryUploadURLsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.file_upload_get_model_directory_upload_urls_with_http_info(directory_name, relative_file_paths, **kwargs)  # noqa: E501
        else:
            (data) = self.file_upload_get_model_directory_upload_urls_with_http_info(directory_name, relative_file_paths, **kwargs)  # noqa: E501
            return data

    def file_upload_get_model_directory_upload_urls_with_http_info(self, directory_name, relative_file_paths, **kwargs):  # noqa: E501
        """GetModelDirectoryUploadURL  # noqa: E501

        Returns a pre-signed upload URL for a model directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_upload_get_model_directory_upload_urls_with_http_info(directory_name, relative_file_paths, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_name: Name of model directory. (required)
        :param list[str] relative_file_paths: Array of relative paths from model directory to model files. (required)
        :param str upload_path: Path to uploaded data.
        :return: RimeGetModelDirectoryUploadURLsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['directory_name', 'relative_file_paths', 'upload_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method file_upload_get_model_directory_upload_urls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'directory_name' is set
        if ('directory_name' not in params or
                params['directory_name'] is None):
            raise ValueError("Missing the required parameter `directory_name` when calling `file_upload_get_model_directory_upload_urls`")  # noqa: E501
        # verify the required parameter 'relative_file_paths' is set
        if ('relative_file_paths' not in params or
                params['relative_file_paths'] is None):
            raise ValueError("Missing the required parameter `relative_file_paths` when calling `file_upload_get_model_directory_upload_urls`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'directory_name' in params:
            query_params.append(('directoryName', params['directory_name']))  # noqa: E501
        if 'relative_file_paths' in params:
            query_params.append(('relativeFilePaths', params['relative_file_paths']))  # noqa: E501
            collection_formats['relativeFilePaths'] = 'multi'  # noqa: E501
        if 'upload_path' in params:
            query_params.append(('uploadPath', params['upload_path']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/models/upload-url', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetModelDirectoryUploadURLsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def file_upload_list_uploaded_file_urls(self, **kwargs):  # noqa: E501
        """ListUploadedFileURLs  # noqa: E501

        List URLs for all uploaded files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_upload_list_uploaded_file_urls(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RimeListUploadedFileURLsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.file_upload_list_uploaded_file_urls_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.file_upload_list_uploaded_file_urls_with_http_info(**kwargs)  # noqa: E501
            return data

    def file_upload_list_uploaded_file_urls_with_http_info(self, **kwargs):  # noqa: E501
        """ListUploadedFileURLs  # noqa: E501

        List URLs for all uploaded files  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_upload_list_uploaded_file_urls_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RimeListUploadedFileURLsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method file_upload_list_uploaded_file_urls" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/uploaded-file-urls', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListUploadedFileURLsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
