from typing import List, Union

from pydantic import BaseModel

from weaverbird.steps import (
    AggregateStep,
    AppendStep,
    ArgmaxStep,
    ArgminStep,
    ConcatenateStep,
    ConvertStep,
    CumSumStep,
    DateExtractStep,
    DeleteStep,
    DomainStep,
    DuplicateStep,
    EvolutionStep,
    FillnaStep,
    FilterStep,
    FormulaStep,
    FromdateStep,
    IfthenelseStep,
    JoinStep,
    LowercaseStep,
    PercentageStep,
    PivotStep,
    RankStep,
    RenameStep,
    ReplaceStep,
    RollupStep,
    SelectStep,
    SortStep,
    SplitStep,
    StatisticsStep,
    SubstringStep,
    TextStep,
    ToDateStep,
    TopStep,
    UniqueGroupsStep,
    UnpivotStep,
    UppercaseStep,
    WaterfallStep,
)

PipelineStep = Union[
    AggregateStep,
    AppendStep,
    ArgmaxStep,
    ArgminStep,
    ConcatenateStep,
    ConvertStep,
    CumSumStep,
    DateExtractStep,
    DeleteStep,
    DomainStep,
    DuplicateStep,
    EvolutionStep,
    FillnaStep,
    FilterStep,
    FromdateStep,
    FormulaStep,
    JoinStep,
    RankStep,
    RenameStep,
    PercentageStep,
    StatisticsStep,
    IfthenelseStep,
    FromdateStep,
    LowercaseStep,
    SelectStep,
    PivotStep,
    ReplaceStep,
    SortStep,
    TextStep,
    UnpivotStep,
    TopStep,
    ToDateStep,
    RollupStep,
    UniqueGroupsStep,
    UppercaseStep,
    SplitStep,
    SubstringStep,
    WaterfallStep,
]


class Pipeline(BaseModel):
    steps: List[PipelineStep]
