from datetime import datetime
import os
import subprocess
import warnings
import sys

import py
import pytest
from _pytest import runner

# we know this bit is bad, but we cant help it with the current pytest setup


# copied from xdist remote
def serialize_report(rep):
    import py

    d = rep.__dict__.copy()
    if hasattr(rep.longrepr, "toterminal"):
        d["longrepr"] = str(rep.longrepr)
    else:
        d["longrepr"] = rep.longrepr
    for name in d:
        if isinstance(d[name], py.path.local):
            d[name] = str(d[name])
        elif name == "result":
            d[name] = None  # for now
    return d


def pytest_addoption(parser):
    group = parser.getgroup("subprocessed", "subprocess test execution")
    group.addoption(
        "--subprocessed",
        action="store_true",
        dest="subprocessed",
        default=False,
        help="invoke test with a standalone 'pytest' invocation",
    )
    group.addoption(
        "--is-in-subprocess",
        action="store_true",
        dest="subprocessed",
        default=False,
        help="(internal) used when invoking a test in a subprocess",
    )


def pytest_load_initial_conftests(early_config, parser, args):
    early_config.addinivalue_line(
        "markers",
        "subprocessed: Always subprocess this test",
    )


@pytest.hookimpl(tryfirst=True)
def pytest_runtest_protocol(item):
    if "--is-in-subprocess" in sys.argv:
        return None

    if item.config.getvalue("subprocessed") or item.get_closest_marker("subprocessed"):
        ihook = item.ihook
        ihook.pytest_runtest_logstart(nodeid=item.nodeid, location=item.location)
        reports = forked_run_report(item)
        if "--is-in-subprocess" in sys.argv:
            return None
        else:
            for rep in reports:
                ihook.pytest_runtest_logreport(report=rep)
            ihook.pytest_runtest_logfinish(nodeid=item.nodeid, location=item.location)
            return True


def forked_run_report(item):
    # for now, we run setup/teardown in the subprocess
    # XXX optionally allow sharing of setup/teardown
    # return []
    # print("WOW")
    # print(item)
    # import rich
    # print(rich.inspect(item))
    # TODO: pass through args
    cmd = [sys.argv[0], "--is-in-subprocess", item.nodeid]
    proc = subprocess.run(cmd)
    if proc.returncode == 0:
        outcome = "passed"
    else:
        outcome = "failed"
    return [runner.TestReport(item.nodeid, (item.fspath, None, item.name), item.name, outcome, "", "call")]
    from _pytest.runner import runtestprotocol

    EXITSTATUS_TESTEXIT = 4
    import marshal

    def runforked():
        try:
            reports = runtestprotocol(item, log=False)
        except KeyboardInterrupt:
            os._exit(EXITSTATUS_TESTEXIT)
        return marshal.dumps([serialize_report(x) for x in reports])

    ff = py.process.ForkedFunc(runforked)
    result = ff.waitfinish()
    if result.retval is not None:
        report_dumps = marshal.loads(result.retval)
        return [runner.TestReport(**x) for x in report_dumps]
    else:
        if result.exitstatus == EXITSTATUS_TESTEXIT:
            pytest.exit(f"forked test item {item} raised Exit")
        return [report_process_crash(item, result)]


def report_process_crash(item, result):
    from _pytest._code import getfslineno

    path, lineno = getfslineno(item)
    info = "%s:%s: running the test CRASHED with signal %d" % (
        path,
        lineno,
        result.signal,
    )
    from _pytest import runner

    # pytest >= 4.1
    has_from_call = getattr(runner.CallInfo, "from_call", None) is not None
    if has_from_call:
        call = runner.CallInfo.from_call(lambda: 0 / 0, "???")
    else:
        call = runner.CallInfo(lambda: 0 / 0, "???")
    call.excinfo = info
    rep = runner.pytest_runtest_makereport(item, call)
    if result.out:
        rep.sections.append(("captured stdout", result.out))
    if result.err:
        rep.sections.append(("captured stderr", result.err))

    xfail_marker = item.get_closest_marker("xfail")
    if not xfail_marker:
        return rep

    rep.outcome = "skipped"
    rep.wasxfail = (
        "reason: {xfail_reason}; "
        "pytest-forked reason: {crash_info}".format(
            xfail_reason=xfail_marker.kwargs["reason"],
            crash_info=info,
        )
    )
    warnings.warn(
        "pytest-forked xfail support is incomplete at the moment and may "
        "output a misleading reason message",
        RuntimeWarning,
    )

    return rep
