from setuptools import setup

setup(
    name="pytest-subprocessed",
    use_scm_version=False,
    version="1.0.0",
    description="run tests in isolated subprocesses",
    long_description=open("README.rst").read(),
    long_description_content_type="text/x-rst",
    license="MIT",
    author="driazati",
    url="https://github.com/pytest-dev/pytest-forked",
    platforms=["linux", "osx"],
    packages=["pytest_subprocessed"],
    package_dir={"": "src"},
    entry_points={
        "pytest11": [
            "pytest_subprocessed = pytest_subprocessed",
        ],
    },
    zip_safe=False,
    install_requires=["py", "pytest>=3.10"],
    setup_requires=["setuptools_scm"],
    python_requires=">=3.6",
    classifiers=[
        "Development Status :: 7 - Inactive",
        "Framework :: Pytest",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: POSIX",
        "Operating System :: MacOS :: MacOS X",
        "Topic :: Software Development :: Testing",
        "Topic :: Software Development :: Quality Assurance",
        "Topic :: Utilities",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3 :: Only",
    ],
)
