/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.perfmark;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PerfTag {
    private static final long NULL_NUMERIC_TAG = 0L;
    private static final String NULL_STRING_TAG = null;
    private final long numericTag;
    private final String stringTag;

    private PerfTag(long numericTag, @Nullable String stringTag) {
        this.numericTag = numericTag;
        this.stringTag = stringTag;
    }

    public long getNumericTag() {
        return this.numericTag;
    }

    @Nullable
    public String getStringTag() {
        return this.stringTag;
    }

    public String toString() {
        return "Tag(numericTag=" + this.numericTag + ",stringTag='" + this.stringTag + "')";
    }

    public int hashCode() {
        int longHashCode = (int)(this.numericTag ^ this.numericTag >>> 32);
        return longHashCode + (this.stringTag != null ? this.stringTag.hashCode() : 31);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PerfTag)) {
            return false;
        }
        PerfTag that = (PerfTag)obj;
        return this.numericTag == that.numericTag && (this.stringTag == that.stringTag || this.stringTag != null && this.stringTag.equals(that.stringTag));
    }

    static final class TagFactory {
        private TagFactory() {
            throw new AssertionError((Object)"nope");
        }

        public static PerfTag create(long numericTag, String stringTag) {
            return new PerfTag(numericTag, stringTag);
        }

        public static PerfTag create(String stringTag) {
            return new PerfTag(0L, stringTag);
        }

        public static PerfTag create(long numericTag) {
            return new PerfTag(numericTag, NULL_STRING_TAG);
        }

        static PerfTag create() {
            return new PerfTag(0L, NULL_STRING_TAG);
        }
    }
}

