/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.plugin;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import org.spongepowered.server.launch.plugin.PluginCandidate;

final class PluginReporter {
    private static final String NEW_DETAILS_LINE = "\n\t\t";
    private static final String SEPARATOR = ": ";

    private PluginReporter() {
    }

    static String formatRequirements(Map<String, String> requirements) {
        StringBuilder builder = new StringBuilder();
        PluginReporter.formatRequirements(builder, requirements);
        return builder.toString();
    }

    private static void formatRequirements(StringBuilder builder, Map<String, String> requirements) {
        Preconditions.checkArgument((!requirements.isEmpty() ? 1 : 0) != 0, (Object)"Requirements cannot be empty");
        boolean first = true;
        for (Map.Entry<String, String> entry : requirements.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(entry.getKey());
            String version = entry.getValue();
            if (version == null) continue;
            builder.append(" (Version ").append(version).append(')');
        }
    }

    static RuntimeException crash(Throwable e, Collection<PluginCandidate> candidates) {
        CrashReport crash = CrashReport.func_85055_a((Throwable)e, (String)"Loading Sponge plugins");
        CrashReportCategory category = crash.func_85058_a("Plugins being loaded");
        StringBuilder pluginsBuilder = new StringBuilder();
        StringBuilder requirementsBuilder = new StringBuilder();
        StringBuilder dependenciesBuilder = new StringBuilder();
        for (PluginCandidate candidate : candidates) {
            pluginsBuilder.append(NEW_DETAILS_LINE).append(candidate);
            if (!candidate.dependenciesCollected()) continue;
            Set<PluginCandidate> requirements = candidate.getRequirements();
            Map<String, String> missingRequirements = candidate.getMissingRequirements();
            if (!requirements.isEmpty() || !missingRequirements.isEmpty()) {
                requirementsBuilder.append(NEW_DETAILS_LINE).append(candidate.getId()).append(SEPARATOR);
                if (!requirements.isEmpty()) {
                    HashMap<String, String> versioned = new HashMap<String, String>();
                    for (PluginCandidate requirement : requirements) {
                        versioned.put(requirement.getId(), candidate.getVersion(requirement.getId()));
                    }
                    PluginReporter.formatRequirements(requirementsBuilder, versioned);
                    if (!missingRequirements.isEmpty()) {
                        requirementsBuilder.append(", ");
                    }
                }
                if (!missingRequirements.isEmpty()) {
                    requirementsBuilder.append("missing: ");
                    PluginReporter.formatRequirements(requirementsBuilder, missingRequirements);
                }
            }
            if (candidate.getDependencies().isEmpty()) continue;
            dependenciesBuilder.append(NEW_DETAILS_LINE).append(candidate.getId()).append(SEPARATOR).append(candidate.getDependencies());
        }
        category.func_71507_a("Plugins", (Object)pluginsBuilder);
        if (requirementsBuilder.length() > 0) {
            category.func_71507_a("Requirements", (Object)requirementsBuilder);
        }
        if (dependenciesBuilder.length() > 0) {
            category.func_71507_a("Dependencies", (Object)dependenciesBuilder);
        }
        throw new ReportedException(crash);
    }
}

