/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.plugin.asm;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.spongepowered.plugin.meta.PluginDependency;
import org.spongepowered.plugin.meta.PluginMetadata;
import org.spongepowered.server.launch.plugin.InvalidPluginException;
import org.spongepowered.server.launch.plugin.asm.WarningAnnotationVisitor;

final class DependencyAnnotationVisitor
extends WarningAnnotationVisitor {
    private final PluginMetadata metadata;
    @Nullable
    private String id;
    @Nullable
    private String version;
    private boolean optional;

    DependencyAnnotationVisitor(String className, PluginMetadata metadata) {
        super(327680, className);
        this.metadata = metadata;
    }

    @Override
    String getAnnotation() {
        return "@Dependency";
    }

    @Override
    public void visit(String name, Object value) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        switch (name) {
            case "id": {
                if (!(value instanceof String)) {
                    throw new InvalidPluginException("Dependency annotation has invalid element 'id'");
                }
                this.id = (String)value;
                return;
            }
            case "version": {
                if (!(value instanceof String)) {
                    throw new InvalidPluginException("Dependency annotation has invalid element 'version'");
                }
                this.version = (String)value;
                return;
            }
            case "optional": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidPluginException("Dependency annotation has invalid element 'optional'");
                }
                this.optional = (Boolean)value;
                return;
            }
        }
        super.visit(name, value);
    }

    @Override
    public void visitEnd() {
        if (this.id == null) {
            throw new IllegalArgumentException("Dependency plugin ID is required");
        }
        this.metadata.addDependency(new PluginDependency(PluginDependency.LoadOrder.BEFORE, this.id, this.version, this.optional));
    }
}

