/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.plugin;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.plugin.meta.McModInfo;
import org.spongepowered.plugin.meta.PluginMetadata;
import org.spongepowered.server.launch.VanillaLaunch;
import org.spongepowered.server.launch.plugin.InvalidPluginException;
import org.spongepowered.server.launch.plugin.PluginAccessTransformers;
import org.spongepowered.server.launch.plugin.PluginCandidate;
import org.spongepowered.server.launch.plugin.PluginSource;
import org.spongepowered.server.launch.plugin.PluginTweakers;
import org.spongepowered.server.launch.plugin.asm.PluginClassVisitor;
import org.spongepowered.server.launch.transformer.at.AccessTransformers;

final class PluginScanner {
    private static final String ID_WARNING = "Plugin IDs should be lowercase, and only contain characters from a-z, dashes or underscores, start with a lowercase letter, and not exceed 64 characters.";
    private static final String CLASS_EXTENSION = ".class";
    static final String JAR_EXTENSION = ".jar";
    private static final PathMatcher CLASS_FILE = path -> path.toString().endsWith(CLASS_EXTENSION);
    private static final PathMatcher JAR_FILE = path -> path.toString().endsWith(JAR_EXTENSION);
    private static final DirectoryStream.Filter<Path> JAR_FILTER = path -> path.toString().endsWith(JAR_EXTENSION);
    private static final String METADATA_FILE = "mcmod.info";
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final Logger logger = VanillaLaunch.getLogger();
    private final Map<String, PluginCandidate> plugins = new HashMap<String, PluginCandidate>();
    private final Set<String> pluginClasses = new HashSet<String>();
    @Nullable
    private FileVisitor<Path> classFileVisitor;

    PluginScanner() {
    }

    public Map<String, PluginCandidate> getPlugins() {
        return this.plugins;
    }

    void scanClassPath(URLClassLoader loader, boolean scanJars) {
        HashSet<URI> sources = new HashSet<URI>();
        for (URL url : loader.getURLs()) {
            URI source;
            if (!url.getProtocol().equals("file")) {
                logger.warn("Skipping unsupported classpath source: {}", (Object)url);
                continue;
            }
            if (url.getPath().startsWith(JAVA_HOME)) {
                logger.trace("Skipping JRE classpath entry: {}", (Object)url);
                continue;
            }
            if (!scanJars && url.getFile().endsWith(JAR_EXTENSION)) {
                logger.trace("Skipping classpath JAR file: {}", (Object)url);
                continue;
            }
            try {
                source = url.toURI();
            }
            catch (URISyntaxException e) {
                logger.error("Failed to search for classpath plugins in {}", (Object)url);
                continue;
            }
            if (!sources.add(source)) continue;
            Path path = Paths.get(source);
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.scanClasspathDirectory(path);
                continue;
            }
            if (!scanJars || !JAR_FILE.matches(path) || !Files.exists(path, new LinkOption[0])) continue;
            this.scanJar(path, true);
        }
    }

    private void scanClasspathDirectory(Path dir) {
        logger.trace("Scanning {} for plugins", (Object)dir);
        if (this.classFileVisitor == null) {
            this.classFileVisitor = new ClassFileVisitor();
        }
        try {
            Files.walkFileTree(dir, Collections.singleton(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, this.classFileVisitor);
        }
        catch (IOException e) {
            logger.error("Failed to search for plugins in {}", (Object)dir, (Object)e);
        }
    }

    void visitClasspathFile(Path path) {
        if (CLASS_FILE.matches(path)) {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                PluginCandidate candidate = this.scanClassFile(in, PluginSource.CLASSPATH);
                if (candidate != null) {
                    this.addCandidate(candidate);
                }
            }
            catch (IOException e) {
                logger.error("Failed to search for plugins in {}", (Object)path, (Object)e);
            }
        }
    }

    void scanDirectory(Path path) {
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(path, JAR_FILTER);){
            for (Path jar : dir) {
                this.scanJar(jar, false);
            }
        }
        catch (IOException e) {
            logger.error("Failed to search for plugins in {}", (Object)path, (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void scanJar(Path path, boolean classpath) {
        Object object;
        logger.trace("Scanning {} for plugins", (Object)path);
        Set<Object> annotationProcessors = Collections.emptySet();
        ArrayList<PluginCandidate> candidates = new ArrayList<PluginCandidate>();
        List<PluginMetadata> metadata = null;
        Set<String> mixinConfigs = null;
        Set<String> mixinTokenProviders = null;
        PluginSource source = new PluginSource(path);
        try {
            JarInputStream jar = new JarInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
            object = null;
            try {
                ZipEntry entry = jar.getNextEntry();
                if (entry == null) {
                    return;
                }
                Manifest manifest = jar.getManifest();
                if (manifest == null) {
                    try (JarFile jarFile = new JarFile(path.toFile());){
                        manifest = jarFile.getManifest();
                    }
                }
                if (manifest != null) {
                    Attributes attributes = manifest.getMainAttributes();
                    annotationProcessors = PluginAccessTransformers.find(attributes);
                    mixinConfigs = PluginTweakers.findMixinConfigs(path, attributes);
                    if (mixinConfigs != null) {
                        mixinTokenProviders = PluginTweakers.findTokenProviders(attributes);
                    }
                } else if (!classpath) {
                    logger.warn("Missing JAR manifest in {}", (Object)path);
                }
                do {
                    if (entry.isDirectory()) continue;
                    String name = entry.getName();
                    if (!name.endsWith(CLASS_EXTENSION)) {
                        if (name.equals(METADATA_FILE)) {
                            try {
                                metadata = McModInfo.DEFAULT.read(jar);
                            }
                            catch (IOException e) {
                                logger.error("Failed to read plugin metadata from mcmod.info in {}", (Object)path, (Object)e);
                                if (jar == null) return;
                                if (object == null) {
                                    jar.close();
                                    return;
                                }
                                try {
                                    jar.close();
                                    return;
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                    return;
                                }
                            }
                        } else {
                            if (!annotationProcessors.remove(name)) continue;
                            try {
                                AccessTransformers.register(jar);
                            }
                            catch (IOException e) {
                                logger.warn("Failed to read access transformer from: {}!{}", (Object)path, (Object)name, (Object)e);
                            }
                            continue;
                        }
                    }
                    PluginCandidate candidate = this.scanClassFile(jar, source);
                    if (candidate == null) continue;
                    candidates.add(candidate);
                } while ((entry = jar.getNextEntry()) != null);
            }
            catch (Throwable entry) {
                object = entry;
                throw entry;
            }
            finally {
                if (jar != null) {
                    if (object != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        jar.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("Failed to scan plugin JAR: {}", (Object)path, (Object)e);
            return;
        }
        if (!annotationProcessors.isEmpty()) {
            logger.warn("Found non-existent access transformers in plugin manifest of {}: {}", (Object)path, annotationProcessors);
        }
        if (mixinConfigs != null) {
            logger.warn("Plugin from {} uses Mixins to modify the Minecraft Server. If something breaks, remove it before reporting the problem to Sponge!", (Object)source);
            source.addToClasspath();
            for (String config : mixinConfigs) {
                logger.debug("Registering Mixin config '{}' from {}", (Object)config, (Object)source);
                PluginTweakers.registerConfig(config);
            }
            if (mixinTokenProviders != null) {
                for (String provider : mixinTokenProviders) {
                    logger.debug("Registering Mixin token provider '{}' from {}", (Object)provider, (Object)source);
                    PluginTweakers.registerTokenProvider(provider);
                }
            }
        }
        if (candidates.isEmpty()) {
            if (classpath) return;
            if (mixinConfigs != null) return;
            logger.error("No valid plugins found in {}. Is the file actually a plugin JAR? Please keep in mind Forge mods can be only loaded on SpongeForge servers, SpongeVanilla supports only Sponge plugins.", (Object)path);
            return;
        }
        boolean success = false;
        object = candidates.iterator();
        while (true) {
            if (!object.hasNext()) {
                if (!success) return;
                if (metadata != null) return;
                logger.warn("{} is missing a valid mcmod.info file.\nThis is not a problem when testing plugins, however it is recommended to include one in public plugins.\nPlease see https://docs.spongepowered.org/master/en/plugin/plugin-meta.html for details.", (Object)path);
                return;
            }
            PluginCandidate candidate = (PluginCandidate)object.next();
            success |= this.addCandidate(candidate);
            if (metadata == null) continue;
            boolean found = false;
            for (PluginMetadata meta : metadata) {
                if (!candidate.getId().equals(meta.getId())) continue;
                found = true;
                candidate.setMetadata(meta);
                break;
            }
            if (found) continue;
            logger.warn("No matching metadata found for plugin '{}' in mcmod.info from {}", (Object)candidate.getId(), (Object)path);
        }
    }

    private boolean addCandidate(PluginCandidate candidate) {
        String pluginClass = candidate.getPluginClass();
        String id = candidate.getId();
        if (!Plugin.ID_PATTERN.matcher(id).matches()) {
            logger.error("Skipping plugin with invalid plugin ID '{}' from {}. Plugin IDs should be lowercase, and only contain characters from a-z, dashes or underscores, start with a lowercase letter, and not exceed 64 characters.", (Object)id, (Object)candidate.getSource());
            return false;
        }
        if (this.plugins.containsKey(id)) {
            logger.error("Skipping plugin with duplicate plugin ID '{}' from {}", (Object)id, (Object)candidate.getSource());
            return false;
        }
        if (!this.pluginClasses.add(pluginClass)) {
            logger.error("Skipping duplicate plugin class {} from {}", (Object)pluginClass, (Object)candidate.getSource());
            return false;
        }
        this.plugins.put(id, candidate);
        return true;
    }

    private PluginCandidate scanClassFile(InputStream in, PluginSource source) throws IOException {
        ClassReader reader = new ClassReader(in);
        PluginClassVisitor visitor = new PluginClassVisitor();
        try {
            reader.accept(visitor, 7);
            PluginMetadata metadata = visitor.getMetadata();
            if (metadata == null) {
                return null;
            }
            return new PluginCandidate(visitor.getClassName().replace('/', '.'), source, metadata);
        }
        catch (InvalidPluginException e) {
            logger.error("Skipping invalid plugin {} from {}", (Object)visitor.getClassName(), (Object)source, (Object)e);
            return null;
        }
    }

    private final class ClassFileVisitor
    extends SimpleFileVisitor<Path> {
        private ClassFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            PluginScanner.this.visitClasspathFile(file);
            return FileVisitResult.CONTINUE;
        }
    }
}

