/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.api.world.schematic.BlockPaletteTypes;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.common.world.schematic.BlockPaletteWrapper;

public class GlobalPalette<T extends CatalogType>
implements Palette<T> {
    @Nullable
    private static Palette<BlockState> blockPalette;
    @Nullable
    private static GlobalPalette<BiomeType> biomePalette;
    private final Function<T, Integer> typeToInt;
    private final IntFunction<T> intToType;
    private final PaletteType<T> paletteType;
    private final Class<T> catalogType;
    private final int length;

    private GlobalPalette(PaletteType<T> paletteType, Function<T, Integer> map, IntFunction<T> identity, Class<T> catalogType) {
        int highest = 0;
        for (CatalogType type : Sponge.getRegistry().getAllOf(catalogType)) {
            int id = map.apply(type);
            if (id <= highest) continue;
            highest = id;
        }
        this.length = highest;
        this.typeToInt = map;
        this.intToType = identity;
        this.paletteType = paletteType;
        this.catalogType = catalogType;
    }

    public static Palette<BlockState> getBlockPalette() {
        if (blockPalette == null) {
            blockPalette = new BlockPaletteWrapper(new GlobalPalette<BlockState>(PaletteTypes.GLOBAL_BLOCKS, type -> Block.field_176229_d.func_148747_b((Object)((IBlockState)type)), id -> (BlockState)Block.field_176229_d.func_148745_a(id), BlockState.class), BlockPaletteTypes.GLOBAL);
        }
        return blockPalette;
    }

    public static GlobalPalette<BiomeType> getBiomePalette() {
        if (biomePalette == null) {
            biomePalette = new GlobalPalette<BiomeType>(PaletteTypes.GLOBAL_BIOMES, type -> Biome.func_185362_a((Biome)((Biome)(type instanceof VirtualBiomeType ? ((VirtualBiomeType)type).getPersistedType() : type))), id -> (BiomeType)Biome.func_185357_a((int)id), BiomeType.class);
        }
        return biomePalette;
    }

    @Override
    public PaletteType<T> getType() {
        return this.paletteType;
    }

    @Override
    public int getHighestId() {
        return this.length;
    }

    @Override
    public Optional<Integer> get(T type) {
        return Optional.of(this.typeToInt.apply(type));
    }

    @Override
    public int getOrAssign(T state) {
        return this.typeToInt.apply(state);
    }

    @Override
    public Optional<T> get(int id) {
        return Optional.ofNullable(this.intToType.apply(id));
    }

    @Override
    public boolean remove(T state) {
        throw new UnsupportedOperationException("Cannot remove blockstates from the global palette");
    }

    @Override
    public Collection<T> getEntries() {
        return Sponge.getRegistry().getAllOf(this.catalogType);
    }

    public int hashCode() {
        return Objects.hash(this.paletteType, this.catalogType, this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalPalette other = (GlobalPalette)obj;
        return Objects.equals(this.paletteType, other.paletteType) && Objects.equals(this.catalogType, other.catalogType) && Objects.equals(this.length, other.length);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("paletteType", this.paletteType).add("catalogType", this.catalogType).add("length", this.length).toString();
    }
}

