/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Random;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.ChorusFlower;

public class ChorusFlowerPopulator
implements ChorusFlower {
    private NoiseGeneratorSimplex noise;
    private long lastSeed = -1L;
    private int exclusion = 1024;

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.CHORUS_FLOWER;
    }

    @Override
    public int getExclusionRadius() {
        return this.exclusion;
    }

    @Override
    public void setExclusionRadius(int radius) {
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (Object)"Exclusion radius must be positive or zero");
        this.exclusion = radius;
    }

    @Override
    public void populate(org.spongepowered.api.world.World world, Extent extent, Random rand) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        if (this.noise == null || world.getProperties().getSeed() != this.lastSeed) {
            this.lastSeed = world.getProperties().getSeed();
            this.noise = new NoiseGeneratorSimplex(new Random(this.lastSeed));
        }
        World worldObj = (World)world;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int chunkX = min.getX() / 16;
        int chunkZ = min.getZ() / 16;
        if ((long)min.getX() * (long)min.getX() + (long)min.getZ() * (long)min.getZ() > (long)(this.exclusion * this.exclusion) && this.func_185960_a(chunkX, chunkZ, 1, 1) > 40.0f) {
            int count = rand.nextInt(5);
            for (int n = 0; n < count; ++n) {
                int y;
                int x = rand.nextInt(size.getX());
                int z = worldObj.func_175645_m(chunkPos.func_177982_a(x, 0, y = rand.nextInt(size.getZ()))).func_177956_o();
                if (z <= 0 || !worldObj.func_175623_d(chunkPos.func_177982_a(x, z, y)) || worldObj.func_180495_p(chunkPos.func_177982_a(x, z - 1, y)).func_177230_c() != Blocks.field_150377_bs) continue;
                BlockChorusFlower.func_185603_a((World)worldObj, (BlockPos)chunkPos.func_177982_a(x, z, y), (Random)rand, (int)8);
            }
        }
    }

    private float func_185960_a(int x, int z, int p_185960_3_, int p_185960_4_) {
        float f = x * 2 + p_185960_3_;
        float f1 = z * 2 + p_185960_4_;
        float f2 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * 8.0f;
        if (f2 > 80.0f) {
            f2 = 80.0f;
        }
        if (f2 < -100.0f) {
            f2 = -100.0f;
        }
        for (int i = -12; i <= 12; ++i) {
            for (int j = -12; j <= 12; ++j) {
                long k = x + i;
                long l = z + j;
                if (k * k + l * l <= 4096L || !(this.noise.func_151605_a((double)k, (double)l) < (double)-0.9f)) continue;
                float f3 = (MathHelper.func_76135_e((float)k) * 3439.0f + MathHelper.func_76135_e((float)l) * 147.0f) % 13.0f + 9.0f;
                f = p_185960_3_ - i * 2;
                f1 = p_185960_4_ - j * 2;
                float f4 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * f3;
                if (f4 > 80.0f) {
                    f4 = 80.0f;
                }
                if (f4 < -100.0f) {
                    f4 = -100.0f;
                }
                if (!(f4 > f2)) continue;
                f2 = f4;
            }
        }
        return f2;
    }
}

