/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import co.aikar.timings.Timing;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.plugin.BasicPluginContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsManager;
import org.spongepowered.common.scheduler.ScheduledTask;

abstract class SchedulerBase {
    private final Map<UUID, ScheduledTask> taskMap = Maps.newConcurrentMap();
    private long sequenceNumber = 0L;
    private final String taskNameFmt;

    protected SchedulerBase(ScheduledTask.TaskSynchronicity type) {
        this.taskNameFmt = "%s-" + (type == ScheduledTask.TaskSynchronicity.SYNCHRONOUS ? "S" : "A") + "-%d";
    }

    protected String nextName(PluginContainer plugin) {
        return String.format(this.taskNameFmt, plugin.getId(), this.sequenceNumber++);
    }

    protected long getTimestamp(ScheduledTask task) {
        return System.nanoTime();
    }

    protected void addTask(ScheduledTask task) {
        task.setTimestamp(this.getTimestamp(task));
        this.taskMap.put(task.getUniqueId(), task);
    }

    protected void removeTask(ScheduledTask task) {
        this.taskMap.remove(task.getUniqueId());
    }

    protected Optional<Task> getTask(UUID id) {
        return Optional.ofNullable(this.taskMap.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Task> getScheduledTasks() {
        Map<UUID, ScheduledTask> map = this.taskMap;
        synchronized (map) {
            return Sets.newHashSet(this.taskMap.values());
        }
    }

    protected final void runTick() {
        this.preTick();
        TimingsManager.PLUGIN_SCHEDULER_HANDLER.startTimingIfSync();
        try {
            this.taskMap.values().forEach(this::processTask);
            this.postTick();
        }
        finally {
            this.finallyPostTick();
        }
        TimingsManager.PLUGIN_SCHEDULER_HANDLER.stopTimingIfSync();
    }

    protected void preTick() {
    }

    protected void postTick() {
    }

    protected void finallyPostTick() {
    }

    protected void processTask(ScheduledTask task) {
        if (task.getState() == ScheduledTask.ScheduledTaskState.CANCELED) {
            this.removeTask(task);
            return;
        }
        if (task.getState() == ScheduledTask.ScheduledTaskState.EXECUTING) {
            return;
        }
        long threshold = Long.MAX_VALUE;
        if (task.getState() == ScheduledTask.ScheduledTaskState.WAITING) {
            threshold = task.offset;
        } else if (task.getState() == ScheduledTask.ScheduledTaskState.RUNNING) {
            threshold = task.period;
        }
        long now = this.getTimestamp(task);
        if (threshold <= now - task.getTimestamp()) {
            task.setState(ScheduledTask.ScheduledTaskState.SWITCHING);
            task.setTimestamp(this.getTimestamp(task));
            this.startTask(task);
            if (task.period == 0L) {
                this.removeTask(task);
            }
        }
    }

    protected void startTask(ScheduledTask task) {
        this.executeTaskRunnable(task, () -> {
            task.setState(ScheduledTask.ScheduledTaskState.EXECUTING);
            try (PhaseContext<?> context = this.createContext(task, task.getOwner());
                 Timing timings = task.getTimingsHandler();){
                timings.startTimingIfSync();
                if (context != null) {
                    context.buildAndSwitch();
                }
                try {
                    task.getConsumer().accept(task);
                }
                catch (Throwable t) {
                    SpongeImpl.getLogger().error("The Scheduler tried to run the task {} owned by {}, but an error occured.", (Object)task.getName(), (Object)task.getOwner(), (Object)t);
                }
            }
            finally {
                task.setState(ScheduledTask.ScheduledTaskState.RUNNING);
                this.onTaskCompletion(task);
            }
        });
    }

    @Nullable
    protected PhaseContext<?> createContext(ScheduledTask task, PluginContainer container) {
        if (task.isAsynchronous() || !Sponge.isServerAvailable()) {
            return null;
        }
        return ((BasicPluginContext)PluginPhase.State.SCHEDULED_TASK.createPhaseContext().source(task)).container(container);
    }

    protected abstract void executeTaskRunnable(ScheduledTask var1, Runnable var2);

    protected void onTaskCompletion(ScheduledTask task) {
    }
}

