/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.OcelotType;
import org.spongepowered.api.data.type.OcelotTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.entity.SpongeOcelotType;

public class OcelotTypeRegistryModule
implements CatalogRegistryModule<OcelotType> {
    public static final Map<String, OcelotType> OCELOT_TYPES = Maps.newHashMap();
    public static final Int2ObjectMap<OcelotType> OCELOT_IDMAP = new Int2ObjectOpenHashMap();
    public static final SpongeOcelotType WILD_OCELOT = new SpongeOcelotType(0, "WILD_OCELOT");
    public static final SpongeOcelotType BLACK_CAT = new SpongeOcelotType(1, "BLACK_CAT");
    public static final SpongeOcelotType RED_CAT = new SpongeOcelotType(2, "RED_CAT");
    public static final SpongeOcelotType SIAMESE_CAT = new SpongeOcelotType(3, "SIAMESE_CAT");
    @RegisterCatalog(value=OcelotTypes.class)
    private final Map<String, OcelotType> ocelotTypeMap = new HashMap<String, OcelotType>();

    @Override
    public Optional<OcelotType> getById(String id) {
        return Optional.ofNullable(this.ocelotTypeMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<OcelotType> getAll() {
        return ImmutableList.copyOf(this.ocelotTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        OCELOT_TYPES.put("wild_ocelot", WILD_OCELOT);
        OCELOT_TYPES.put("black_cat", BLACK_CAT);
        OCELOT_TYPES.put("red_cat", RED_CAT);
        OCELOT_TYPES.put("siamese_cat", SIAMESE_CAT);
        OCELOT_IDMAP.put(0, (Object)WILD_OCELOT);
        OCELOT_IDMAP.put(1, (Object)BLACK_CAT);
        OCELOT_IDMAP.put(2, (Object)RED_CAT);
        OCELOT_IDMAP.put(3, (Object)SIAMESE_CAT);
        this.ocelotTypeMap.putAll(OCELOT_TYPES);
    }
}

