/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.message;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.PlayerConnection;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.network.message.MessageTrackerDataRequest;
import org.spongepowered.common.network.message.MessageTrackerDataResponse;

public final class SpongeMessageHandler {
    private static ChannelBinding.IndexedMessageChannel channel;

    private SpongeMessageHandler() {
    }

    public static ChannelBinding.IndexedMessageChannel getChannel() {
        return channel;
    }

    public static void init() {
        channel = Sponge.getChannelRegistrar().createChannel(SpongeImpl.getPlugin(), "Sponge");
        channel.registerMessage(MessageTrackerDataRequest.class, 0, Platform.Type.SERVER, SpongeMessageHandler::handleRequest);
        channel.registerMessage(MessageTrackerDataResponse.class, 1);
    }

    public static void handleRequest(MessageTrackerDataRequest message, RemoteConnection connection, Platform.Type side) {
        Entity entity;
        if (!(connection instanceof PlayerConnection)) {
            return;
        }
        Player player = ((PlayerConnection)connection).getPlayer();
        if (!player.hasPermission("sponge.debug.block-tracking")) {
            return;
        }
        EntityPlayerMP sender = (EntityPlayerMP)player;
        BlockPos pos = new BlockPos(message.x, message.y, message.z);
        if (!sender.field_70170_p.func_175667_e(pos)) {
            return;
        }
        Optional<User> owner = Optional.empty();
        Optional<User> notifier = Optional.empty();
        if (message.type == 0) {
            ChunkBridge spongeChunk = (ChunkBridge)sender.field_70170_p.func_175726_f(pos);
            owner = spongeChunk.bridge$getBlockOwner(pos);
            notifier = spongeChunk.bridge$getBlockNotifier(pos);
        } else if (message.type == 1 && (entity = sender.field_70170_p.func_73045_a(message.entityId)) instanceof OwnershipTrackedBridge) {
            OwnershipTrackedBridge ownerBridge = (OwnershipTrackedBridge)entity;
            owner = ownerBridge.tracked$getOwnerReference();
            notifier = ownerBridge.tracked$getNotifierReference();
        }
        String ownerName = owner.map(User::getName).orElse("");
        String notifierName = notifier.map(User::getName).orElse("");
        channel.sendTo(player, new MessageTrackerDataResponse(ownerName, notifierName));
    }
}

