/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.world.chunk;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge_AsyncLighting;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge_AsyncLighting;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderBridge;
import org.spongepowered.common.util.Constants;

@Mixin(value={Chunk.class}, priority=1002)
public abstract class ChunkMixin_Async_Lighting
implements ChunkBridge_AsyncLighting {
    private Set<Short> asyncLighting$queuedSkyLightingUpdates = ConcurrentHashMap.newKeySet();
    private Set<Short> asyncLighting$queuedBlockLightingUpdates = ConcurrentHashMap.newKeySet();
    private AtomicInteger asyncLighting$pendingLightUpdates = new AtomicInteger();
    private long asyncLighting$lightUpdateTime;
    private ExecutorService asyncLighting$lightExecutorService;
    private boolean asyncLighting$isServerChunk;
    @Shadow
    @Final
    private World field_76637_e;
    @Shadow
    @Final
    private int[] field_76634_f;
    @Shadow
    @Final
    private ExtendedBlockStorage[] field_76652_q;
    @Shadow
    private boolean field_76646_k;
    @Shadow
    private boolean field_150814_l;
    @Shadow
    private boolean field_150815_m;
    @Shadow
    private boolean field_76643_l;
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    @Final
    private boolean[] field_76639_c;
    @Shadow
    private boolean field_76650_s;
    @Shadow
    private int field_82912_p;
    @Shadow
    @Final
    private ConcurrentLinkedQueue<BlockPos> field_177447_w;

    @Shadow
    public abstract int func_76625_h();

    @Shadow
    public abstract int func_76611_b(int var1, int var2);

    @Shadow
    protected abstract void func_76599_g(int var1, int var2, int var3);

    @Shadow
    @Nullable
    public abstract TileEntity func_177424_a(BlockPos var1, Chunk.EnumCreateEntityType var2);

    @Shadow
    protected abstract TileEntity func_177422_i(BlockPos var1);

    @Shadow
    public abstract IBlockState func_177435_g(BlockPos var1);

    @Shadow
    protected abstract int func_150808_b(int var1, int var2, int var3);

    @Shadow
    protected abstract void func_76609_d(int var1, int var2, int var3, int var4);

    @Shadow
    protected abstract void func_180700_a(EnumFacing var1);

    @Inject(method={"<init>(Lnet/minecraft/world/World;II)V"}, at={@At(value="RETURN")})
    private void asyncLighting$initializeFields(World worldIn, int x, int z, CallbackInfo ci) {
        boolean bl = this.asyncLighting$isServerChunk = !((WorldBridge)worldIn).bridge$isFake();
        if (this.asyncLighting$isServerChunk) {
            this.asyncLighting$lightExecutorService = ((WorldServerBridge_AsyncLighting)worldIn).asyncLightingBridge$getLightingExecutor();
        }
    }

    @Override
    public AtomicInteger asyncLightingBridge$getPendingLightUpdates() {
        return this.asyncLighting$pendingLightUpdates;
    }

    @Override
    public long asyncLightingBridge$getLightUpdateTime() {
        return this.asyncLighting$lightUpdateTime;
    }

    @Override
    public void asyncLightingBridge$setLightUpdateTime(long time) {
        this.asyncLighting$lightUpdateTime = time;
    }

    @Inject(method={"onTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void asyncLighting$onTickHead(boolean skipRecheckGaps, CallbackInfo ci) {
        if (this.asyncLighting$isServerChunk) {
            List<Chunk> neighbors = this.asyncLighting$getSurroundingChunks();
            if (this.field_76650_s && this.field_76637_e.field_73011_w.func_191066_m() && !skipRecheckGaps && !neighbors.isEmpty()) {
                this.asyncLighting$lightExecutorService.execute(() -> this.asyncLighting$recheckGapsAsync(neighbors));
                this.field_76650_s = false;
            }
            this.field_150815_m = true;
            if (!this.field_150814_l && this.field_76646_k && !neighbors.isEmpty()) {
                this.asyncLighting$lightExecutorService.execute(() -> this.asyncLighting$checkLightAsync(neighbors));
                this.field_150814_l = true;
            }
            while (!this.field_177447_w.isEmpty()) {
                BlockPos blockpos = this.field_177447_w.poll();
                if (this.func_177424_a(blockpos, Chunk.EnumCreateEntityType.CHECK) != null || !this.func_177435_g(blockpos).func_177230_c().func_149716_u()) continue;
                TileEntity tileentity = this.func_177422_i(blockpos);
                this.field_76637_e.func_175690_a(blockpos, tileentity);
                this.field_76637_e.func_175704_b(blockpos, blockpos);
            }
            ci.cancel();
        }
    }

    @Redirect(method={"checkSkylightNeighborHeight"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getHeight(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/BlockPos;"))
    private BlockPos asyncLighting$onCheckSkylightGetHeight(World world, BlockPos pos) {
        Chunk chunk = this.asyncLighting$getLightChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, null);
        if (chunk == null) {
            return Constants.DUMMY_POS;
        }
        return new BlockPos(pos.func_177958_n(), chunk.func_76611_b(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF), pos.func_177952_p());
    }

    @Redirect(method={"updateSkylightNeighborHeight"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isAreaLoaded(Lnet/minecraft/util/math/BlockPos;I)Z"))
    private boolean asyncLighting$onAreaLoadedSkyLightNeighbor(World world, BlockPos pos, int radius) {
        return this.asyncLighting$isAreaLoaded();
    }

    @Redirect(method={"updateSkylightNeighborHeight"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;checkLightFor(Lnet/minecraft/world/EnumSkyBlock;Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean asyncLighting$onCheckLightForSkylightNeighbor(World world, EnumSkyBlock enumSkyBlock, BlockPos pos) {
        if (!this.asyncLighting$isServerChunk) {
            return world.func_180500_c(enumSkyBlock, pos);
        }
        return this.asyncLighting$checkWorldLightFor(enumSkyBlock, pos);
    }

    private void asyncLighting$recheckGapsAsync(List<Chunk> neighbors) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (!this.field_76639_c[i + j * 16]) continue;
                this.field_76639_c[i + j * 16] = false;
                int k = this.func_76611_b(i, j);
                int l = this.field_76635_g * 16 + i;
                int i1 = this.field_76647_h * 16 + j;
                int j1 = Integer.MAX_VALUE;
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    Chunk chunk = this.asyncLighting$getLightChunk(l + enumfacing.func_82601_c() >> 4, i1 + enumfacing.func_82599_e() >> 4, neighbors);
                    if (chunk == null || chunk.field_189550_d) continue;
                    j1 = Math.min(j1, chunk.func_177442_v());
                }
                this.func_76599_g(l, i1, j1);
                for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                    this.func_76599_g(l + enumfacing1.func_82601_c(), i1 + enumfacing1.func_82599_e(), k);
                }
            }
        }
    }

    @Redirect(method={"enqueueRelightChecks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"))
    private IBlockState asyncLighting$onRelightChecksGetBlockState(World world, BlockPos pos) {
        Chunk chunk = ((ChunkProviderBridge)world.func_72863_F()).bridge$getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        ChunkBridge spongeChunk = (ChunkBridge)chunk;
        if (chunk == null || chunk.field_189550_d || !spongeChunk.bridge$areNeighborsLoaded()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return chunk.func_177435_g(pos);
    }

    @Redirect(method={"enqueueRelightChecks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;checkLight(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean asyncLighting$onRelightChecksCheckLight(World world, BlockPos pos) {
        if (this.asyncLighting$isServerChunk) {
            return this.asyncLighting$checkWorldLight(pos);
        }
        return world.func_175664_x(pos);
    }

    @Redirect(method={"checkLight(II)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;checkLight(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean asyncLighting$onCheckLightWorld(World world, BlockPos pos) {
        if (this.asyncLighting$isServerChunk) {
            return this.asyncLighting$checkWorldLight(pos);
        }
        return world.func_175664_x(pos);
    }

    /*
     * Unable to fully structure code
     */
    @Inject(method={"checkLight()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void asyncLighting$checkLightHead(CallbackInfo ci) {
        if (this.asyncLighting$isServerChunk) {
            if (this.field_76637_e.func_73046_m().func_71241_aa() || this.asyncLighting$lightExecutorService.isShutdown()) {
                return;
            }
            if (this.bridge$isQueuedForUnload()) {
                return;
            }
            neighborChunks = this.asyncLighting$getSurroundingChunks();
            if (neighborChunks.isEmpty()) {
                this.field_150814_l = false;
                return;
            }
            if (SpongeImpl.getServer().func_152345_ab()) {
                try {
                    this.asyncLighting$lightExecutorService.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$asyncLighting$checkLightHead$2(java.util.List ), ()V)((ChunkMixin_Async_Lighting)this, neighborChunks));
                }
                catch (RejectedExecutionException e) {
                    if (this.field_76637_e.func_73046_m().func_71241_aa() || this.asyncLighting$lightExecutorService.isShutdown()) ** GOTO lbl18
                    throw e;
                }
            } else {
                this.asyncLighting$checkLightAsync(neighborChunks);
            }
lbl18:
            // 3 sources

            ci.cancel();
        }
    }

    private void asyncLighting$checkLightAsync(List<Chunk> neighbors) {
        this.field_76646_k = true;
        this.field_150814_l = true;
        BlockPos blockpos = new BlockPos(this.field_76635_g << 4, 0, this.field_76647_h << 4);
        if (this.field_76637_e.field_73011_w.func_191066_m()) {
            block0: for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (this.asyncLighting$checkLightAsync(i, j, neighbors)) continue;
                    this.field_150814_l = false;
                    break block0;
                }
            }
            if (this.field_150814_l) {
                Iterator i = EnumFacing.Plane.HORIZONTAL.iterator();
                while (i.hasNext()) {
                    EnumFacing enumfacing;
                    int k = (enumfacing = (EnumFacing)i.next()).func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 16 : 1;
                    BlockPos pos = blockpos.func_177967_a(enumfacing, k);
                    Chunk chunk = this.asyncLighting$getLightChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, neighbors);
                    if (chunk == null) continue;
                    ((ChunkMixin_Async_Lighting)chunk).func_180700_a(enumfacing.func_176734_d());
                }
                for (int i2 = 0; i2 < this.field_76639_c.length; ++i2) {
                    this.field_76639_c[i2] = true;
                }
                this.asyncLighting$recheckGapsAsync(neighbors);
            }
        }
    }

    private boolean asyncLighting$checkLightAsync(int x, int z, List<Chunk> neighbors) {
        int i = this.func_76625_h();
        boolean flag = false;
        boolean flag1 = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos((this.field_76635_g << 4) + x, 0, (this.field_76647_h << 4) + z);
        for (int j = i + 16 - 1; j > this.field_76637_e.func_181545_F() || j > 0 && !flag1; --j) {
            blockpos$mutableblockpos.func_181079_c(blockpos$mutableblockpos.func_177958_n(), j, blockpos$mutableblockpos.func_177952_p());
            int k = this.func_177435_g((BlockPos)blockpos$mutableblockpos).func_185891_c();
            if (k == 255 && blockpos$mutableblockpos.func_177956_o() < this.field_76637_e.func_181545_F()) {
                flag1 = true;
            }
            if (!flag && k > 0) {
                flag = true;
                continue;
            }
            if (!flag || k != 0 || this.asyncLighting$checkWorldLight((BlockPos)blockpos$mutableblockpos, neighbors)) continue;
            return false;
        }
        for (int l = blockpos$mutableblockpos.func_177956_o(); l > 0; --l) {
            blockpos$mutableblockpos.func_181079_c(blockpos$mutableblockpos.func_177958_n(), l, blockpos$mutableblockpos.func_177952_p());
            if (this.func_177435_g((BlockPos)blockpos$mutableblockpos).func_185906_d() <= 0) continue;
            this.asyncLighting$checkWorldLight((BlockPos)blockpos$mutableblockpos, neighbors);
        }
        return true;
    }

    @Nullable
    private Chunk asyncLighting$getLightChunk(int chunkX, int chunkZ, @Nullable List<Chunk> neighbors) {
        Chunk currentChunk = (Chunk)this;
        if (currentChunk.func_76600_a(chunkX, chunkZ)) {
            if (currentChunk.field_189550_d) {
                return null;
            }
            return currentChunk;
        }
        if (neighbors == null && (neighbors = this.asyncLighting$getSurroundingChunks()).isEmpty()) {
            return null;
        }
        for (Chunk neighbor : neighbors) {
            if (!neighbor.func_76600_a(chunkX, chunkZ)) continue;
            if (neighbor.field_189550_d) {
                return null;
            }
            return neighbor;
        }
        return null;
    }

    private boolean asyncLighting$isAreaLoaded() {
        if (!this.bridge$areNeighborsLoaded()) {
            return false;
        }
        Chunk southEastChunk = ((ChunkBridge)this.bridge$getNeighborChunk(0)).bridge$getNeighborChunk(2);
        if (southEastChunk == null) {
            return false;
        }
        Chunk southWestChunk = ((ChunkBridge)this.bridge$getNeighborChunk(0)).bridge$getNeighborChunk(3);
        if (southWestChunk == null) {
            return false;
        }
        Chunk northEastChunk = ((ChunkBridge)this.bridge$getNeighborChunk(1)).bridge$getNeighborChunk(2);
        if (northEastChunk == null) {
            return false;
        }
        Chunk northWestChunk = ((ChunkBridge)this.bridge$getNeighborChunk(1)).bridge$getNeighborChunk(3);
        return northWestChunk != null;
    }

    private List<Chunk> asyncLighting$getSurroundingChunks() {
        if (!this.bridge$areNeighborsLoaded()) {
            return Collections.emptyList();
        }
        Chunk southEastChunk = ((ChunkBridge)this.bridge$getNeighborChunk(0)).bridge$getNeighborChunk(2);
        if (southEastChunk == null) {
            return Collections.emptyList();
        }
        Chunk southWestChunk = ((ChunkBridge)this.bridge$getNeighborChunk(0)).bridge$getNeighborChunk(3);
        if (southWestChunk == null) {
            return Collections.emptyList();
        }
        Chunk northEastChunk = ((ChunkBridge)this.bridge$getNeighborChunk(1)).bridge$getNeighborChunk(2);
        if (northEastChunk == null) {
            return Collections.emptyList();
        }
        Chunk northWestChunk = ((ChunkBridge)this.bridge$getNeighborChunk(1)).bridge$getNeighborChunk(3);
        if (northWestChunk == null) {
            return Collections.emptyList();
        }
        List<Chunk> chunkList = this.bridge$getNeighbors();
        chunkList.add(southEastChunk);
        chunkList.add(southWestChunk);
        chunkList.add(northEastChunk);
        chunkList.add(northWestChunk);
        return chunkList;
    }

    @Inject(method={"relightBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void asyncLighting$onRelightBlock(int x, int y, int z, CallbackInfo ci) {
        if (this.asyncLighting$isServerChunk) {
            this.asyncLighting$lightExecutorService.execute(() -> this.asyncLighting$relightBlockAsync(x, y, z));
            ci.cancel();
        }
    }

    private void asyncLighting$relightBlockAsync(int x, int y, int z) {
        int i;
        int j = i = this.field_76634_f[z << 4 | x] & 0xFF;
        if (y > i) {
            j = y;
        }
        while (j > 0 && this.func_150808_b(x, j - 1, z) == 0) {
            --j;
        }
        if (j != i) {
            this.asyncLighting$markBlocksDirtyVerticalAsync(x + this.field_76635_g * 16, z + this.field_76647_h * 16, j, i);
            this.field_76634_f[z << 4 | x] = j;
            int k = this.field_76635_g * 16 + x;
            int l = this.field_76647_h * 16 + z;
            if (this.field_76637_e.field_73011_w.func_191066_m()) {
                if (j < i) {
                    for (int j1 = j; j1 < i; ++j1) {
                        ExtendedBlockStorage extendedblockstorage2 = this.field_76652_q[j1 >> 4];
                        if (extendedblockstorage2 == Chunk.field_186036_a) continue;
                        extendedblockstorage2.func_76657_c(x, j1 & 0xF, z, 15);
                        this.field_76637_e.func_175679_n(new BlockPos((this.field_76635_g << 4) + x, j1, (this.field_76647_h << 4) + z));
                    }
                } else {
                    for (int i1 = i; i1 < j; ++i1) {
                        ExtendedBlockStorage extendedblockstorage = this.field_76652_q[i1 >> 4];
                        if (extendedblockstorage == Chunk.field_186036_a) continue;
                        extendedblockstorage.func_76657_c(x, i1 & 0xF, z, 0);
                        this.field_76637_e.func_175679_n(new BlockPos((this.field_76635_g << 4) + x, i1, (this.field_76647_h << 4) + z));
                    }
                }
                int k1 = 15;
                while (j > 0 && k1 > 0) {
                    ExtendedBlockStorage extendedblockstorage1;
                    int i2;
                    if ((i2 = this.func_150808_b(x, --j, z)) == 0) {
                        i2 = 1;
                    }
                    if ((k1 -= i2) < 0) {
                        k1 = 0;
                    }
                    if ((extendedblockstorage1 = this.field_76652_q[j >> 4]) == Chunk.field_186036_a) continue;
                    extendedblockstorage1.func_76657_c(x, j & 0xF, z, k1);
                }
            }
            int l1 = this.field_76634_f[z << 4 | x];
            int j2 = i;
            int k2 = l1;
            if (l1 < i) {
                j2 = l1;
                k2 = i;
            }
            if (l1 < this.field_82912_p) {
                this.field_82912_p = l1;
            }
            if (this.field_76637_e.field_73011_w.func_191066_m()) {
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    this.func_76609_d(k + enumfacing.func_82601_c(), l + enumfacing.func_82599_e(), j2, k2);
                }
                this.func_76609_d(k, l, j2, k2);
            }
            this.field_76643_l = true;
        }
    }

    private void asyncLighting$markBlocksDirtyVerticalAsync(int x1, int z1, int x2, int z2) {
        if (x2 > z2) {
            int i = z2;
            z2 = x2;
            x2 = i;
        }
        if (this.field_76637_e.field_73011_w.func_191066_m()) {
            for (int j = x2; j <= z2; ++j) {
                BlockPos pos = new BlockPos(x1, j, z1);
                Chunk chunk = this.asyncLighting$getLightChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, null);
                if (chunk == null) continue;
                ((WorldServerBridge_AsyncLighting)this.field_76637_e).asyncLightingBridge$updateLightAsync(EnumSkyBlock.SKY, new BlockPos(x1, j, z1), chunk);
            }
        }
        this.field_76637_e.func_147458_c(x1, x2, z1, x1, z2, z1);
    }

    private boolean asyncLighting$checkWorldLightFor(EnumSkyBlock lightType, BlockPos pos) {
        Chunk chunk = this.asyncLighting$getLightChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, null);
        if (chunk == null) {
            return false;
        }
        return ((WorldServerBridge_AsyncLighting)this.field_76637_e).asyncLightingBridge$updateLightAsync(lightType, pos, chunk);
    }

    private boolean asyncLighting$checkWorldLight(BlockPos pos) {
        return this.asyncLighting$checkWorldLight(pos, null);
    }

    private boolean asyncLighting$checkWorldLight(BlockPos pos, List<Chunk> neighbors) {
        boolean flag = false;
        Chunk chunk = this.asyncLighting$getLightChunk(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, neighbors);
        if (chunk == null) {
            return false;
        }
        if (this.field_76637_e.field_73011_w.func_191066_m()) {
            flag = ((WorldServerBridge_AsyncLighting)this.field_76637_e).asyncLightingBridge$updateLightAsync(EnumSkyBlock.SKY, pos, chunk);
        }
        return flag |= ((WorldServerBridge_AsyncLighting)this.field_76637_e).asyncLightingBridge$updateLightAsync(EnumSkyBlock.BLOCK, pos, chunk);
    }

    @Override
    public Set<Short> asyncLightingBridge$getQueuedLightingUpdates(EnumSkyBlock type) {
        if (type == EnumSkyBlock.SKY) {
            return this.asyncLighting$queuedSkyLightingUpdates;
        }
        return this.asyncLighting$queuedBlockLightingUpdates;
    }

    private /* synthetic */ void lambda$asyncLighting$checkLightHead$2(List neighborChunks) {
        this.asyncLighting$checkLightAsync(neighborChunks);
    }
}

