/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.world;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.util.math.BlockPosBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge_AsyncLighting;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge_AsyncLighting;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderBridge;
import org.spongepowered.common.mixin.core.world.WorldMixin;

@Mixin(value={WorldServer.class})
public abstract class WorldServerMixin_Async_Lighting
extends WorldMixin
implements WorldServerBridge_AsyncLighting {
    private ExecutorService asyncLightingImpl$lightExecutorService = Executors.newFixedThreadPool(SpongeImpl.getGlobalConfigAdapter().getConfig().getOptimizations().getAsyncLightingCategory().getNumThreads(), new ThreadFactoryBuilder().setNameFormat("Sponge - Async Light Thread").build());

    @Override
    public boolean func_180500_c(EnumSkyBlock lightType, BlockPos pos) {
        return this.asyncLightingBridge$updateLightAsync(lightType, pos, null);
    }

    @Override
    public boolean asyncLightingBridge$checkLightAsync(EnumSkyBlock lightType, BlockPos pos, Chunk currentChunk, List<Chunk> neighbors) {
        ChunkBridge_AsyncLighting spongeChunk = (ChunkBridge_AsyncLighting)currentChunk;
        int i = 0;
        int j = 0;
        int k = this.asyncLightingImpl$getLightForAsync(lightType, pos, currentChunk, neighbors);
        int l = this.asyncLightingImpl$getRawBlockLightAsync(lightType, pos, currentChunk, neighbors);
        int i1 = pos.func_177958_n();
        int j1 = pos.func_177956_o();
        int k1 = pos.func_177952_p();
        if (l > k) {
            this.field_72994_J[j++] = 133152;
        } else if (l < k) {
            this.field_72994_J[j++] = 0x20820 | k << 18;
            while (i < j) {
                int l3;
                int k3;
                int j3;
                int l1 = this.field_72994_J[i++];
                int i2 = (l1 & 0x3F) - 32 + i1;
                int j2 = (l1 >> 6 & 0x3F) - 32 + j1;
                int k2 = (l1 >> 12 & 0x3F) - 32 + k1;
                int l2 = l1 >> 18 & 0xF;
                BlockPos blockpos = new BlockPos(i2, j2, k2);
                int i3 = this.asyncLightingImpl$getLightForAsync(lightType, blockpos, currentChunk, neighbors);
                if (i3 != l2) continue;
                this.asyncLightingImpl$setLightForAsync(lightType, blockpos, 0, currentChunk, neighbors);
                if (l2 <= 0 || (j3 = MathHelper.func_76130_a((int)(i2 - i1))) + (k3 = MathHelper.func_76130_a((int)(j2 - j1))) + (l3 = MathHelper.func_76130_a((int)(k2 - k1))) >= 17) continue;
                BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    int i4 = i2 + enumfacing.func_82601_c();
                    int j4 = j2 + enumfacing.func_96559_d();
                    int k4 = k2 + enumfacing.func_82599_e();
                    blockpos$pooledmutableblockpos.func_181079_c(i4, j4, k4);
                    Chunk pooledChunk = this.asyncLightingImpl$getLightChunk((BlockPos)blockpos$pooledmutableblockpos, currentChunk, neighbors);
                    if (pooledChunk == null) continue;
                    int l4 = Math.max(1, pooledChunk.func_177435_g((BlockPos)blockpos$pooledmutableblockpos).func_185891_c());
                    i3 = this.asyncLightingImpl$getLightForAsync(lightType, (BlockPos)blockpos$pooledmutableblockpos, currentChunk, neighbors);
                    if (i3 != l2 - l4 || j >= this.field_72994_J.length) continue;
                    this.field_72994_J[j++] = i4 - i1 + 32 | j4 - j1 + 32 << 6 | k4 - k1 + 32 << 12 | l2 - l4 << 18;
                }
                blockpos$pooledmutableblockpos.func_185344_t();
            }
            i = 0;
        }
        while (i < j) {
            boolean flag;
            int i5 = this.field_72994_J[i++];
            int j5 = (i5 & 0x3F) - 32 + i1;
            int k5 = (i5 >> 6 & 0x3F) - 32 + j1;
            int l5 = (i5 >> 12 & 0x3F) - 32 + k1;
            BlockPos blockpos1 = new BlockPos(j5, k5, l5);
            int i6 = this.asyncLightingImpl$getLightForAsync(lightType, blockpos1, currentChunk, neighbors);
            int j6 = this.asyncLightingImpl$getRawBlockLightAsync(lightType, blockpos1, currentChunk, neighbors);
            if (j6 == i6) continue;
            this.asyncLightingImpl$setLightForAsync(lightType, blockpos1, j6, currentChunk, neighbors);
            if (j6 <= i6) continue;
            int k6 = Math.abs(j5 - i1);
            int l6 = Math.abs(k5 - j1);
            int i7 = Math.abs(l5 - k1);
            boolean bl = flag = j < this.field_72994_J.length - 6;
            if (k6 + l6 + i7 >= 17 || !flag) continue;
            if (this.asyncLightingImpl$getLightForAsync(lightType, blockpos1.func_177976_e(), currentChunk, neighbors) < j6) {
                this.field_72994_J[j++] = j5 - 1 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.asyncLightingImpl$getLightForAsync(lightType, blockpos1.func_177974_f(), currentChunk, neighbors) < j6) {
                this.field_72994_J[j++] = j5 + 1 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.asyncLightingImpl$getLightForAsync(lightType, blockpos1.func_177977_b(), currentChunk, neighbors) < j6) {
                this.field_72994_J[j++] = j5 - i1 + 32 + (k5 - 1 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.asyncLightingImpl$getLightForAsync(lightType, blockpos1.func_177984_a(), currentChunk, neighbors) < j6) {
                this.field_72994_J[j++] = j5 - i1 + 32 + (k5 + 1 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.asyncLightingImpl$getLightForAsync(lightType, blockpos1.func_177978_c(), currentChunk, neighbors) < j6) {
                this.field_72994_J[j++] = j5 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - 1 - k1 + 32 << 12);
            }
            if (this.asyncLightingImpl$getLightForAsync(lightType, blockpos1.func_177968_d(), currentChunk, neighbors) >= j6) continue;
            this.field_72994_J[j++] = j5 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 + 1 - k1 + 32 << 12);
        }
        spongeChunk.asyncLightingBridge$getQueuedLightingUpdates(lightType).remove(this.asyncLightingImpl$blockPosToShort(pos));
        spongeChunk.asyncLightingBridge$getPendingLightUpdates().decrementAndGet();
        for (Chunk neighborChunk : neighbors) {
            ChunkBridge_AsyncLighting neighbor = (ChunkBridge_AsyncLighting)neighborChunk;
            neighbor.asyncLightingBridge$getPendingLightUpdates().decrementAndGet();
        }
        return true;
    }

    @Override
    public boolean asyncLightingBridge$updateLightAsync(EnumSkyBlock lightType, BlockPos pos, @Nullable Chunk currentChunk) {
        ChunkBridge northChunk;
        if (this.func_73046_m().func_71241_aa() || this.asyncLightingImpl$lightExecutorService.isShutdown()) {
            return false;
        }
        if (currentChunk == null) {
            currentChunk = ((ChunkProviderBridge)this.field_73020_y).bridge$getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        }
        ChunkBridge_AsyncLighting spongeChunk = (ChunkBridge_AsyncLighting)currentChunk;
        if (currentChunk == null || currentChunk.field_189550_d || !spongeChunk.bridge$areNeighborsLoaded()) {
            return false;
        }
        short shortPos = this.asyncLightingImpl$blockPosToShort(pos);
        if (spongeChunk.asyncLightingBridge$getQueuedLightingUpdates(lightType).contains(shortPos)) {
            return false;
        }
        Chunk chunk = currentChunk;
        spongeChunk.asyncLightingBridge$getQueuedLightingUpdates(lightType).add(shortPos);
        spongeChunk.asyncLightingBridge$getPendingLightUpdates().incrementAndGet();
        spongeChunk.asyncLightingBridge$setLightUpdateTime(chunk.func_177412_p().func_82737_E());
        List<Chunk> neighbors = spongeChunk.bridge$getNeighbors();
        ChunkBridge southChunk = (ChunkBridge)spongeChunk.bridge$getNeighborChunk(0);
        if (southChunk != null) {
            Chunk southEastChunk = southChunk.bridge$getNeighborChunk(2);
            Chunk southWestChunk = southChunk.bridge$getNeighborChunk(3);
            if (southEastChunk != null) {
                neighbors.add(southEastChunk);
            }
            if (southWestChunk != null) {
                neighbors.add(southWestChunk);
            }
        }
        if ((northChunk = (ChunkBridge)spongeChunk.bridge$getNeighborChunk(1)) != null) {
            Chunk northEastChunk = northChunk.bridge$getNeighborChunk(2);
            Chunk northWestChunk = northChunk.bridge$getNeighborChunk(3);
            if (northEastChunk != null) {
                neighbors.add(northEastChunk);
            }
            if (northWestChunk != null) {
                neighbors.add(northWestChunk);
            }
        }
        for (Chunk neighborChunk : neighbors) {
            ChunkBridge_AsyncLighting neighbor = (ChunkBridge_AsyncLighting)neighborChunk;
            neighbor.asyncLightingBridge$getPendingLightUpdates().incrementAndGet();
            neighbor.asyncLightingBridge$setLightUpdateTime(chunk.func_177412_p().func_82737_E());
        }
        if (SpongeImpl.getServer().func_152345_ab()) {
            this.asyncLightingImpl$lightExecutorService.execute(() -> this.asyncLightingBridge$checkLightAsync(lightType, pos, chunk, neighbors));
        } else {
            this.asyncLightingBridge$checkLightAsync(lightType, pos, chunk, neighbors);
        }
        return true;
    }

    @Override
    public ExecutorService asyncLightingBridge$getLightingExecutor() {
        return this.asyncLightingImpl$lightExecutorService;
    }

    private Chunk asyncLightingImpl$getLightChunk(BlockPos pos, Chunk currentChunk, List<Chunk> neighbors) {
        if (currentChunk.func_76600_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            if (currentChunk.field_189550_d) {
                return null;
            }
            return currentChunk;
        }
        for (Chunk neighbor : neighbors) {
            if (!neighbor.func_76600_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) continue;
            if (neighbor.field_189550_d) {
                return null;
            }
            return neighbor;
        }
        return null;
    }

    private int asyncLightingImpl$getLightForAsync(EnumSkyBlock lightType, BlockPos pos, Chunk currentChunk, List<Chunk> neighbors) {
        if (pos.func_177956_o() < 0) {
            pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        if (!((BlockPosBridge)pos).bridge$isValidPosition()) {
            return lightType.field_77198_c;
        }
        Chunk chunk = this.asyncLightingImpl$getLightChunk(pos, currentChunk, neighbors);
        if (chunk == null || chunk.field_189550_d) {
            return lightType.field_77198_c;
        }
        return chunk.func_177413_a(lightType, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int asyncLightingImpl$getRawBlockLightAsync(EnumSkyBlock lightType, BlockPos pos, Chunk currentChunk, List<Chunk> neighbors) {
        Chunk chunk = this.asyncLightingImpl$getLightChunk(pos, currentChunk, neighbors);
        if (chunk == null || chunk.field_189550_d) {
            return lightType.field_77198_c;
        }
        if (lightType == EnumSkyBlock.SKY && chunk.func_177444_d(pos)) {
            return 15;
        }
        IBlockState blockState = chunk.func_177435_g(pos);
        int blockLight = SpongeImplHooks.getChunkPosLight(blockState, (World)this, pos);
        int i = lightType == EnumSkyBlock.SKY ? 0 : blockLight;
        int j = SpongeImplHooks.getBlockLightOpacity(blockState, (IBlockAccess)((World)this), pos);
        if (j >= 15 && blockLight > 0) {
            j = 1;
        }
        if (j < 1) {
            j = 1;
        }
        if (j >= 15) {
            return 0;
        }
        if (i >= 14) {
            return i;
        }
        BlockPos.PooledMutableBlockPos pooledBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                pooledBlockPos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing);
                int k = this.asyncLightingImpl$getLightForAsync(lightType, (BlockPos)pooledBlockPos, currentChunk, neighbors) - j;
                if (k > i) {
                    i = k;
                }
                if (i < 14) continue;
                int n = i;
                return n;
            }
            int n = i;
            return n;
        }
        finally {
            pooledBlockPos.func_185344_t();
        }
    }

    private void asyncLightingImpl$setLightForAsync(EnumSkyBlock type, BlockPos pos, int lightValue, Chunk currentChunk, List<Chunk> neighbors) {
        Chunk chunk;
        if (((BlockPosBridge)pos).bridge$isValidPosition() && (chunk = this.asyncLightingImpl$getLightChunk(pos, currentChunk, neighbors)) != null && !chunk.field_189550_d) {
            chunk.func_177431_a(type, pos, lightValue);
            this.func_175679_n(pos);
        }
    }

    private short asyncLightingImpl$blockPosToShort(BlockPos pos) {
        short serialized = (short)this.asyncLightingImpl$setNibble(0, pos.func_177958_n() & 0xF, 0, 4);
        serialized = (short)this.asyncLightingImpl$setNibble(serialized, pos.func_177956_o() & 0xFF, 1, 8);
        serialized = (short)this.asyncLightingImpl$setNibble(serialized, pos.func_177952_p() & 0xF, 3, 4);
        return serialized;
    }

    private int asyncLightingImpl$setNibble(int num, int data, int which, int bitsToReplace) {
        return num & ~(bitsToReplace << which * 4) | data << which * 4;
    }
}

