/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.storage.SaveHandlerBridge;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;

@NonnullByDefault
@Mixin(value={SaveHandler.class})
public abstract class SaveHandlerMixin
implements SaveHandlerBridge {
    @Shadow
    @Final
    private File field_75770_b;
    @Shadow
    @Final
    private File field_75771_c;
    @Nullable
    private Exception impl$capturedException;
    @Nullable
    private Path impl$file;
    private Set<File> impl$directoriesToCreate = new HashSet<File>();

    @Shadow
    protected abstract void shadow$func_75766_h();

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/io/File;mkdirs()Z", remap=false))
    private boolean impl$createDirectoryIfSavingFiles(File dir) {
        IPhaseState<?> state = PhaseTracker.getInstance().getCurrentState();
        if (!state.shouldCreateWorldDirectories(PhaseTracker.getInstance().getCurrentContext())) {
            this.impl$directoriesToCreate.add(dir);
            return false;
        }
        return dir.mkdirs();
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/SaveHandler;setSessionLock()V"))
    private void impl$setSessionLockIfCreatingFiles(SaveHandler self) {
        IPhaseState<?> state = PhaseTracker.getInstance().getCurrentState();
        if (state.shouldCreateWorldDirectories(PhaseTracker.getInstance().getCurrentContext())) {
            this.shadow$func_75766_h();
        }
    }

    @Redirect(method={"checkSessionLock"}, at=@At(value="NEW", target="java/io/FileInputStream", remap=false))
    private FileInputStream impl$createSessionLockAndCreateDirectories(File file) throws FileNotFoundException {
        if (!file.exists()) {
            WorldProperties props = Sponge.getServer().getWorldProperties(this.field_75770_b.getName()).get();
            if (props.getSerializationBehavior() == SerializationBehaviors.NONE) {
                throw new IllegalStateException("Should not be saving with SerializationBehaviors.NONE");
            }
            for (File dir : this.impl$directoriesToCreate) {
                dir.mkdirs();
            }
            this.impl$directoriesToCreate.clear();
            this.shadow$func_75766_h();
        }
        return new FileInputStream(file);
    }

    @ModifyArg(method={"checkSessionLock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/MinecraftException;<init>(Ljava/lang/String;)V", ordinal=0, remap=false))
    private String modifyMinecraftExceptionOutputIfNotInitializationTime(String message) {
        return "The save folder for world " + this.field_75770_b + " is being accessed from another location, aborting";
    }

    @ModifyArg(method={"checkSessionLock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/MinecraftException;<init>(Ljava/lang/String;)V", ordinal=1, remap=false))
    private String modifyMinecraftExceptionOutputIfIOException(String message) {
        return "Failed to check session lock for world " + this.field_75770_b + ", aborting";
    }

    @Inject(method={"saveWorldInfoWithPlayer"}, at={@At(value="RETURN")})
    private void impl$saveLevelSpongeDataFile(WorldInfo worldInformation, NBTTagCompound tagCompound, CallbackInfo ci) {
        boolean performChecks = SpongeImpl.getGlobalConfigAdapter().getConfig().getGeneral().isCheckFileWhenSavingSpongeDataFile();
        try {
            NBTTagCompound spongeRootLevelNBT = ((WorldInfoBridge)worldInformation).bridge$getSpongeRootLevelNbt();
            if (spongeRootLevelNBT.func_82582_d()) {
                Integer dimensionId = ((WorldInfoBridge)worldInformation).bridge$getDimensionId();
                String dimensionIdString = dimensionId == null ? "unknown" : String.valueOf(dimensionId);
                new PrettyPrinter().add("Sponge Root Level NBT for world %s is empty!", worldInformation.func_76065_j()).centre().hr().add("When trying to save Sponge data for the world %s, an empty NBT compound was provided. The old Sponge data file was left intact.", worldInformation.func_76065_j()).add().add("The following information may be useful in debugging:").add().add("UUID: ", ((WorldInfoBridge)worldInformation).bridge$getAssignedId()).add("Dimension ID: ", dimensionIdString).add("Is Modded: ", ((WorldInfoBridge)worldInformation).bridge$getIsMod()).add("Valid flag: ", ((WorldInfoBridge)worldInformation).bridge$isValid()).add().add("Stack trace:").add(new Exception()).print(System.err);
                return;
            }
            File newDataFile = new File(this.field_75770_b, "level_sponge.dat_new");
            File oldDataFile = new File(this.field_75770_b, "level_sponge.dat_old");
            File dataFile = new File(this.field_75770_b, "level_sponge.dat");
            try (FileOutputStream stream = new FileOutputStream(newDataFile);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)spongeRootLevelNBT, (OutputStream)stream);
            }
            if (performChecks) {
                boolean shouldDelete;
                block40: {
                    if (newDataFile.length() == 0L) {
                        Integer dimensionId = ((WorldInfoBridge)worldInformation).bridge$getDimensionId();
                        String dimensionIdString = dimensionId == null ? "unknown" : String.valueOf(dimensionId);
                        new PrettyPrinter().add("Zero length level_sponge.dat file was created for %s!", worldInformation.func_76065_j()).centre().hr().add("When saving the data file for the world %s, a zero length file was written. Sponge has discarded this file.", worldInformation.func_76065_j()).add().add("The following information may be useful in debugging:").add().add("UUID: ", ((WorldInfoBridge)worldInformation).bridge$getAssignedId()).add("Dimension ID: ", dimensionIdString).add("Is Modded: ", ((WorldInfoBridge)worldInformation).bridge$getIsMod()).add("Valid flag: ", ((WorldInfoBridge)worldInformation).bridge$isValid()).add().add("Stack trace:").add(new Exception()).print(System.err);
                        newDataFile.delete();
                        return;
                    }
                    shouldDelete = false;
                    try (InputStream reader = Files.newInputStream(newDataFile.toPath(), new OpenOption[0]);){
                        Integer dimensionId;
                        int byte1 = reader.read();
                        int byte2 = reader.read();
                        if (byte1 == 31 && byte2 == 139) break block40;
                        shouldDelete = true;
                        int next = 1;
                        if (byte1 == 0 && byte2 == 0) {
                            while ((next = reader.read()) == 0) {
                            }
                        }
                        String dimensionIdString = (dimensionId = ((WorldInfoBridge)worldInformation).bridge$getDimensionId()) == null ? "unknown" : String.valueOf(dimensionId);
                        String copyText = null;
                        if (next != -1) {
                            try {
                                Path dataFilePath = newDataFile.toPath();
                                Path corrupted = dataFilePath.resolveSibling(newDataFile.getName() + ".corrupted-" + DateTimeFormatter.ISO_INSTANT.format(Instant.now()).replaceAll(":", "") + ".dat");
                                Files.copy(dataFilePath, corrupted, new CopyOption[0]);
                                copyText = String.format("We have backed up the corrupted file to %s. Please keep hold of this, it may be useful to Sponge developers.", corrupted.getFileName());
                            }
                            catch (IOException dataFilePath) {
                                // empty catch block
                            }
                        }
                        PrettyPrinter prettyPrinter = new PrettyPrinter(100).add("Badly formatted level_sponge.dat file was created for %s!", worldInformation.func_76065_j()).centre().hr().addWrapped("When saving the data file for the world %s, the file was not saved with the correct magic header. Sponge has discarded this file.", worldInformation.func_76065_j()).add();
                        if (copyText != null) {
                            prettyPrinter.addWrapped(copyText, new Object[0]).add();
                        }
                        prettyPrinter.add("The following information may be useful in debugging:").add().add("Magic header: %x %x (expected %x %x)", byte1, byte2, 31, 139).add("File size: %d bytes", newDataFile.length()).add("UUID: ", ((WorldInfoBridge)worldInformation).bridge$getAssignedId()).add("Dimension ID: ", dimensionIdString).add("Is Modded: ", ((WorldInfoBridge)worldInformation).bridge$getIsMod()).add("Valid flag: ", ((WorldInfoBridge)worldInformation).bridge$isValid()).add().add("Stack trace:").add(new Exception()).print(System.err);
                    }
                }
                if (shouldDelete) {
                    newDataFile.delete();
                    return;
                }
            }
            if (dataFile.exists()) {
                if (oldDataFile.exists()) {
                    oldDataFile.delete();
                }
                dataFile.renameTo(oldDataFile);
                dataFile.delete();
            }
            newDataFile.renameTo(dataFile);
            if (newDataFile.exists()) {
                newDataFile.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void bridge$loadSpongeDatData(WorldInfo info) {
        File spongeFile = new File(this.field_75770_b, "level_sponge.dat");
        File spongeOldFile = new File(this.field_75770_b, "level_sponge.dat_old");
        boolean exceptionRaised = false;
        if (spongeFile.exists()) {
            if (this.impl$loadSpongeDatFile(info, spongeFile, true)) {
                return;
            }
            exceptionRaised = true;
        }
        if (spongeOldFile.exists()) {
            if (this.impl$loadSpongeDatFile(info, spongeOldFile, false)) {
                if (exceptionRaised) {
                    SpongeImpl.getLogger().warn("Successfully loaded backup data file {} for world {}.", (Object)spongeFile.getName(), (Object)info.func_76065_j());
                    spongeFile.delete();
                }
                return;
            }
            exceptionRaised = true;
        }
        if (exceptionRaised) {
            throw new RuntimeException("Unable to load sponge data for world [" + info.func_76065_j() + "]");
        }
    }

    @Redirect(method={"readPlayerData(Lnet/minecraft/entity/player/EntityPlayer;)Lnet/minecraft/nbt/NBTTagCompound;"}, at=@At(value="INVOKE", target="Ljava/io/File;isFile()Z", remap=false))
    private boolean impl$grabFileToField(File localfile) {
        boolean isFile = localfile.isFile();
        this.impl$file = isFile ? localfile.toPath() : null;
        return isFile;
    }

    @Redirect(method={"readPlayerData(Lnet/minecraft/entity/player/EntityPlayer;)Lnet/minecraft/nbt/NBTTagCompound;"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/CompressedStreamTools;readCompressed(Ljava/io/InputStream;)Lnet/minecraft/nbt/NBTTagCompound;"))
    private NBTTagCompound impl$readLegacyDataAndOrSpongeData(InputStream inputStream) throws IOException {
        Instant creation = this.impl$file == null ? Instant.now() : Files.readAttributes(this.impl$file, BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant();
        NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        Instant lastPlayed = Instant.now();
        if (compound.func_150297_b("bukkit", 10)) {
            NBTTagCompound bukkitCompound = compound.func_74775_l("bukkit");
            creation = Instant.ofEpochMilli(bukkitCompound.func_74763_f("firstPlayed"));
            lastPlayed = Instant.ofEpochMilli(bukkitCompound.func_74763_f("lastPlayed"));
        }
        if (compound.func_150297_b("Canary", 10)) {
            NBTTagCompound canaryCompound = compound.func_74775_l("Canary");
            creation = Instant.ofEpochMilli(canaryCompound.func_74763_f("FirstJoin"));
            lastPlayed = Instant.ofEpochMilli(canaryCompound.func_74763_f("LastJoin"));
        }
        UUID playerId = null;
        if (compound.func_186855_b("UUID")) {
            playerId = compound.func_186857_a("UUID");
        }
        if (playerId != null) {
            Optional<Instant> savedJoined;
            Optional<Instant> savedFirst = SpongePlayerDataHandler.getFirstJoined(playerId);
            if (savedFirst.isPresent()) {
                creation = savedFirst.get();
            }
            if ((savedJoined = SpongePlayerDataHandler.getLastPlayed(playerId)).isPresent()) {
                lastPlayed = savedJoined.get();
            }
            SpongePlayerDataHandler.setPlayerInfo(playerId, creation, lastPlayed);
        }
        this.impl$file = null;
        return compound;
    }

    @Inject(method={"writePlayerData"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompressedStreamTools;writeCompressed(Lnet/minecraft/nbt/NBTTagCompound;Ljava/io/OutputStream;)V", shift=At.Shift.AFTER)})
    private void impl$saveSpongePlayerData(EntityPlayer player, CallbackInfo callbackInfo) {
        SpongePlayerDataHandler.savePlayer(player.func_110124_au());
    }

    @Inject(method={"writePlayerData"}, at={@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void impl$trackExceptionForLogging(EntityPlayer player, CallbackInfo ci, Exception exception) {
        this.impl$capturedException = exception;
    }

    @Redirect(method={"writePlayerData"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false))
    private void impl$useStoredException(Logger logger, String message, Object param) {
        logger.warn(message, param, (Object)this.impl$capturedException);
        this.impl$capturedException = null;
    }

    @Override
    public File bridge$getSpongeWorldDirectory() {
        return this.field_75770_b;
    }

    @Override
    public File bridge$getPlayersDirectory() {
        return this.field_75771_c;
    }

    private boolean impl$loadSpongeDatFile(WorldInfo info, File file, boolean isCurrent) {
        NBTTagCompound compound;
        try (FileInputStream stream = new FileInputStream(file);){
            compound = CompressedStreamTools.func_74796_a((InputStream)stream);
        }
        catch (Exception ex) {
            PrettyPrinter errorPrinter = new PrettyPrinter().add("Unable to load level data from world [%s] for file [%s]!", info.func_76065_j(), file.getName()).centre().hr();
            Path corrupted = file.toPath().getParent().resolve(file.getName() + ".corrupted-" + DateTimeFormatter.ISO_INSTANT.format(Instant.now()).replaceAll(":", "") + ".dat");
            try {
                Files.copy(file.toPath(), corrupted, new CopyOption[0]);
                errorPrinter.add("We have backed up the corrupted file to %s. Please keep hold of this, it may be useful to Sponge developers.", corrupted.getFileName());
            }
            catch (IOException e) {
                errorPrinter.add("We were unable to copy the corrupted file.");
            }
            if (isCurrent) {
                errorPrinter.add("We will try to load the backup file (if it exists)");
            }
            errorPrinter.hr().add("Exception:").add(ex).print(System.err);
            return false;
        }
        ((WorldInfoBridge)info).bridge$setSpongeRootLevelNBT(compound);
        if (compound.func_74764_b("SpongeData")) {
            NBTTagCompound spongeCompound = compound.func_74775_l("SpongeData");
            DataUtil.spongeDataFixer.func_188257_a((IFixType)FixTypes.LEVEL, spongeCompound);
            ((WorldInfoBridge)info).bridge$readSpongeNbt(spongeCompound);
        }
        return true;
    }
}

