/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.util.text.event;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.util.text.event.ClickEvent;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.util.text.event.ClickEventBridge;
import org.spongepowered.common.text.action.SpongeCallbackHolder;

@Mixin(value={ClickEvent.class})
public abstract class ClickEventMixin
implements ClickEventBridge {
    @Shadow
    @Final
    private ClickEvent.Action field_150671_a;
    @Shadow
    @Final
    private String field_150670_b;
    private ClickAction<?> handle;
    private volatile boolean initialized;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClickAction<?> bridge$getHandle() {
        if (this.initialized) return this.handle;
        try {
            switch (this.field_150671_a) {
                case OPEN_URL: {
                    try {
                        this.bridge$setHandle(TextActions.openUrl(new URL(this.field_150670_b)));
                        return this.handle;
                    }
                    catch (MalformedURLException e) {
                        SpongeImpl.getLogger().debug("Tried to parse invalid URL \"{}\": {}", (Object)this.field_150670_b, (Object)e.getMessage());
                        return this.handle;
                    }
                }
                case RUN_COMMAND: {
                    if (this.field_150670_b.startsWith("/sponge:callback")) {
                        try {
                            UUID callbackId = UUID.fromString(this.field_150670_b.substring("/sponge:callback".length() + 1));
                            Optional<Consumer<CommandSource>> callback = SpongeCallbackHolder.getInstance().getCallbackForUUID(callbackId);
                            if (callback.isPresent()) {
                                this.bridge$setHandle(TextActions.executeCallback(callback.get()));
                                return this.handle;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    this.bridge$setHandle(TextActions.runCommand(this.field_150670_b));
                    return this.handle;
                }
                case SUGGEST_COMMAND: {
                    this.bridge$setHandle(TextActions.suggestCommand(this.field_150670_b));
                    return this.handle;
                }
                case CHANGE_PAGE: {
                    this.bridge$setHandle(TextActions.changePage(Integer.parseInt(this.field_150670_b)));
                    return this.handle;
                }
            }
            return this.handle;
        }
        finally {
            this.initialized = true;
        }
    }

    @Override
    public void bridge$setHandle(ClickAction<?> handle) {
        if (this.initialized) {
            return;
        }
        this.handle = (ClickAction)Preconditions.checkNotNull(handle, (Object)"handle");
        this.initialized = true;
    }
}

