/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={EntityHanging.class})
public abstract class EntityHangingMixin
extends EntityMixin {
    @Shadow
    @Nullable
    public EnumFacing field_174860_b;
    private boolean ignorePhysics = false;

    @Shadow
    public abstract boolean func_70518_d();

    @Redirect(method={"onUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityHanging;onValidSurface()Z"))
    private boolean checkIfOnValidSurfaceAndIgnoresPhysics(EntityHanging entityHanging) {
        return this.func_70518_d() && !this.ignorePhysics;
    }

    @Override
    public void spongeImpl$writeToSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$writeToSpongeCompound(compound);
        compound.func_74757_a("ignorePhysics", this.ignorePhysics);
    }

    @Override
    public void spongeImpl$readFromSpongeCompound(NBTTagCompound compound) {
        super.spongeImpl$readFromSpongeCompound(compound);
        if (compound.func_74764_b("ignorePhysics")) {
            this.ignorePhysics = compound.func_74767_n("ignorePhysics");
        }
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityHanging;setDead()V")}, cancellable=true)
    private void onAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(source);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(frame.getCurrentCause(), new ArrayList(), (org.spongepowered.api.entity.Entity)((Object)this), 0, amount);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                cir.setReturnValue(true);
            }
        }
    }

    @Override
    @Overwrite
    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        double xOffset = (float)this.field_174860_b.func_82601_c() * 0.15f;
        double zOffset = (float)this.field_174860_b.func_82599_e() * 0.15f;
        if (((WorldBridge)this.field_70170_p).bridge$isFake()) {
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + xOffset, this.field_70163_u + (double)offsetY, this.field_70161_v + zOffset, stack);
            entityitem.func_174869_p();
            this.field_70170_p.func_72838_d((Entity)entityitem);
            return entityitem;
        }
        return EntityUtil.entityOnDropItem((Entity)((EntityHanging)this), stack, offsetY, this.field_70165_t + xOffset, this.field_70161_v + zOffset);
    }
}

